/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.IdentityType;
import oracle.bpm.casemgmt.model.Resource;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.ValueType;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.NoEmptyStringTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.LookupManagerService;
import oracle.bpm.casemgmt.ui.components.RoleChooserPanel;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.components.XPathExpressionBuilderDialog;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.javatools.ui.table.GenericTable;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditor;
import oracle.tip.tools.ide.common.ui.BrowsableTableCellEditorCallback;

class StakeHolderPanelBuilder
extends TableHeaderPanelBuilder<Resource>
implements EntityEvents {
    private Case casemgmt;
    private Organization organization;
    private StakeHolder stakeHolder;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return StakeHolderPanelBuilder.this.stakeHolder;
        }
    };
    private TranslationService translationService;

    public StakeHolderPanelBuilder(StakeHolder stakeHolder, Case casemgmt, TranslationService translationService, Organization organization) {
        super(Msg.QUOTE(""));
        this.stakeHolder = stakeHolder;
        this.casemgmt = casemgmt;
        this.translationService = translationService;
        this.organization = organization;
        this.updateTitle();
    }

    public StakeHolderTableModel createTableModel() {
        return new StakeHolderTableModel(this.stakeHolder);
    }

    public StakeHolderTableModel getTableModel() {
        return (StakeHolderTableModel)super.getTableModel();
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] stakeHolderEvents;
        block5: for (Event event : stakeHolderEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    if (!(childEvent.getNewValue() instanceof Resource)) continue block5;
                    this.addToModel((Resource)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    if (!(childEvent.getOldValue() instanceof Resource)) continue block5;
                    this.getTableModel().removeRow((Resource)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.updateTitle();
                    this.tableModelChanged();
                }
            }
        }
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
        result.add(super.buildEditor(result), "growx, wrap");
        return result;
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellEditor(IdentityTypeTableCellEditor.INSTANCE);
        column0.setCellRenderer(IdentityTypeTableCellRenderer.INSTANCE);
        StakeHolderPanelBuilder.setColumnSize(column0, 150);
        TableColumn column1 = columnModel.getColumn(1);
        column1.setCellEditor(ValueTypeTableCellEditor.INSTANCE);
        column1.setCellRenderer(ValueTypeTableCellRenderer.INSTANCE);
        StakeHolderPanelBuilder.setColumnSize(column1, 150);
        BrowsableTableCellEditorCallback callback = new BrowsableTableCellEditorCallback(){

            public Object showChooser(JTable table, int row, int col) {
                Resource resource = (Resource)StakeHolderPanelBuilder.this.getTableModel().getRow(row);
                IdentityType identityType = resource.getIdentityType();
                Value resourceValue = resource.getValue();
                String value = resourceValue.getValue();
                String result = null;
                if (resourceValue.getType().isXPath()) {
                    result = StakeHolderPanelBuilder.this.xPathChooser(value);
                } else if (identityType.isUser()) {
                    result = StakeHolderPanelBuilder.this.userChooser(value);
                } else if (identityType.isGroup()) {
                    result = StakeHolderPanelBuilder.this.groupChooser(value);
                } else if (identityType.isApplicationRole()) {
                    result = StakeHolderPanelBuilder.this.applicationRoleChooser(value);
                } else if (identityType.isProcessRole()) {
                    result = StakeHolderPanelBuilder.this.swimlaneChooser(value);
                }
                return result;
            }
        };
        TableColumn column3 = columnModel.getColumn(2);
        column3.setCellRenderer(NoEmptyStringTableCellRenderer.INSTANCE);
        column3.setCellEditor((TableCellEditor)((Object)new ValueTableCellEditor(callback)));
    }

    @Override
    protected Action[] addActions() {
        AbstractAction addUserAction = new AbstractAction(CaseUiMsg.ADD_USER.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StakeHolderPanelBuilder.this.addResource(IdentityType.USER);
            }
        };
        AbstractAction addGroupAction = new AbstractAction(CaseUiMsg.ADD_GROUP.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StakeHolderPanelBuilder.this.addResource(IdentityType.GROUP);
            }
        };
        AbstractAction addAppRoleAction = new AbstractAction(CaseUiMsg.ADD_APPLICATION_ROLE.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StakeHolderPanelBuilder.this.addResource(IdentityType.APPLICATION_ROLE);
            }
        };
        AbstractAction addSwimlaneRoleAction = new AbstractAction(CaseUiMsg.ADD_PROCESS_ROLE.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                StakeHolderPanelBuilder.this.addResource(IdentityType.PROCESS_ROLE);
            }
        };
        return new Action[]{addUserAction, addGroupAction, addAppRoleAction, addSwimlaneRoleAction};
    }

    @Override
    protected void editAction(Resource toEdit, int row) {
        String key = this.stakeHolder.getName();
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.EDIT_STAKEHOLDER, key);
        if (keyValue != null) {
            this.stakeHolder.setName(keyValue.getFirst());
            this.updateTitle();
        }
    }

    @Override
    protected void enableAction(int action, boolean value) {
        super.enableAction(action, action == 2 ? true : value);
    }

    @Override
    protected void removeAction(List<Resource> toRemove) {
        for (Resource resource : toRemove) {
            this.stakeHolder.remove((Object)resource);
        }
    }

    @Override
    protected int actions() {
        return 7;
    }

    private void updateTitle() {
        String name = this.stakeHolder.getName();
        String value = this.translationService.getValue(name);
        this.setTitle(Msg.QUOTE(value == null ? "[" + name + "]" : value));
    }

    private String xPathChooser(String value) {
        String result = null;
        oracle.bpm.project.model.Project bpmProject = this.organization.getProject();
        Project project = Platform.getAdapterService().adaptTo(bpmProject, Project.class);
        XPathExpressionBuilderDialog dialog = XPathExpressionBuilderDialog.create((JFrame)Ide.getMainWindow(), project, this.casemgmt, value);
        if (dialog.display() == 0) {
            result = dialog.getExpressionText();
            dialog.updateCasePrefixes(this.casemgmt);
        }
        return result;
    }

    private String userChooser(String value) {
        return LookupManagerService.showUserDialog(this.getEditor().asSwing());
    }

    private String groupChooser(String value) {
        return LookupManagerService.showGroupDialog(this.getEditor().asSwing());
    }

    private String applicationRoleChooser(String value) {
        return LookupManagerService.showApplicationRoleDialog(this.getEditor().asSwing());
    }

    private String swimlaneChooser(String value) {
        Role role = this.organization.findRoleById(value);
        Role selectedRole = RoleChooserPanel.showDialog(this.organization, role);
        return selectedRole != null ? selectedRole.getId() : null;
    }

    private void addResource(IdentityType type) {
        Resource resource = CaseFactory.createResource();
        resource.setIdentityType(type);
        if (type.isProcessRole()) {
            resource.setApplicationContext("OracleBPMProcessRolesApp");
        }
        this.stakeHolder.add((Object)resource);
    }

    private static class ValueTypeTableCellRenderer
    extends DefaultTableCellRenderer {
        public static ValueTypeTableCellRenderer INSTANCE = new ValueTypeTableCellRenderer();

        private ValueTypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setText(((ValueType)value).getString());
            return result;
        }
    }

    private static class ValueTypeTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public static ValueTypeTableCellEditor INSTANCE = new ValueTypeTableCellEditor();

        private ValueTypeTableCellEditor() {
            super(new JComboBox<ValueType>(ValueType.values()));
            this.getComponent().setRenderer(new ValueTypeCellRenderer());
        }

        @Override
        public JComboBox getComponent() {
            return (JComboBox)super.getComponent();
        }

        private static class ValueTypeCellRenderer
        extends DefaultListCellRenderer {
            private ValueTypeCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                result.setText(((ValueType)value).getString());
                return result;
            }
        }
    }

    private static class ValueTableCellEditor
    extends BrowsableTableCellEditor {
        public ValueTableCellEditor(BrowsableTableCellEditorCallback callback) {
            super(callback);
            this.setClickCountToStart(1);
        }
    }

    private static class StakeHolderTableModel
    extends ProviderTableModel<Resource> {
        private static final int COLUMN_IDENTITY_TYPE = 0;
        private static final int COLUMN_VALUE_TYPE = 1;
        private static final int COLUMN_VALUE = 2;

        public StakeHolderTableModel(StakeHolder stakeHolder) {
            super(MsgList.create(CaseUiMsg.MEMBER_TYPE, CaseUiMsg.VALUE_TYPE, CaseUiMsg.VALUE));
            this.populate(stakeHolder);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Resource resource = (Resource)this.getRow(row);
            switch (column) {
                case 0: {
                    resource.setIdentityType((IdentityType)value);
                    break;
                }
                case 1: {
                    if (((ValueType)value).isStatic()) {
                        resource.getValue().toStatic();
                        break;
                    }
                    resource.getValue().toXPath();
                    break;
                }
                case 2: {
                    resource.getValue().setValue((String)value);
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            Class<String> result = String.class;
            switch (column) {
                case 0: {
                    result = IdentityType.class;
                    break;
                }
                case 1: {
                    result = ValueType.class;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = null;
            Resource resource = (Resource)this.getRow(row);
            switch (column) {
                case 0: {
                    result = resource.getIdentityType();
                    break;
                }
                case 1: {
                    result = resource.getValue().getType();
                    break;
                }
                case 2: {
                    result = resource.getValue().getValue();
                }
            }
            return result;
        }

        private void populate(StakeHolder stakeHolder) {
            this.removeAllElements();
            for (Resource resource : stakeHolder) {
                this.addRow(resource);
            }
        }
    }

    private static class IdentityTypeTableCellRenderer
    extends DefaultTableCellRenderer {
        public static IdentityTypeTableCellRenderer INSTANCE = new IdentityTypeTableCellRenderer();

        private IdentityTypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setText(((IdentityType)value).getString());
            return result;
        }
    }

    private static class IdentityTypeTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public static IdentityTypeTableCellEditor INSTANCE = new IdentityTypeTableCellEditor();

        private IdentityTypeTableCellEditor() {
            super(new JComboBox<IdentityType>(IdentityType.values()));
            this.getComponent().setRenderer(new IdentityTypeCellRenderer());
        }

        @Override
        public JComboBox getComponent() {
            return (JComboBox)super.getComponent();
        }

        private static class IdentityTypeCellRenderer
        extends DefaultListCellRenderer {
            private IdentityTypeCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                result.setText(((IdentityType)value).getString());
                return result;
            }
        }
    }
}

