/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

class PriorityComboBox
extends ComboBox<Integer> {
    private static final int DEFAULT_VALUE = 3;
    private static final Msg[] PRIORITY_LABEL = new Msg[]{CaseUiMsg.HIGHEST_PRIORITY, CaseUiMsg.HIGH_PRIORITY, CaseUiMsg.NORMAL_PRIORITY, CaseUiMsg.LOW_PRIORITY, CaseUiMsg.LOWEST_PRIORITY};
    public static final List<Integer> VALUES = Arrays.asList(1, 2, 3, 4, 5);
    public static final PriorityLabelProvider LABEL_PROVIDER = new PriorityLabelProvider();

    public PriorityComboBox(UiContainer parent) {
        super(parent, false);
        this.init();
    }

    private void init() {
        this.setModelList(VALUES);
        this.setSelectedItem(3);
        this.setLabelProvider(LABEL_PROVIDER);
        this.setBackground(Color.WHITE);
    }

    public static class PriorityLabelProvider
    extends LabelProvider.Default<Integer> {
        @Override
        public String getText(Integer i) {
            return String.valueOf(i) + " ( " + PRIORITY_LABEL[i - 1] + " )";
        }
    }
}

