/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import oracle.bpm.casemgmt.model.cm.PermissionRole;
import oracle.bpm.casemgmt.ui.components.LookupManagerService;
import oracle.bpm.casemgmt.ui.components.TextFieldButtonPanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

class PermissionRolePanel
extends TextFieldButtonPanel {
    private PermissionRole permissionRole;

    public PermissionRolePanel(UiContainer parent, PermissionRole permissionRole) {
        super(parent);
        this.permissionRole = permissionRole;
        this.setComponentValue(permissionRole.getValue());
    }

    @Override
    protected Msg getMsg() {
        return UIMsg.BROWSE;
    }

    @Override
    protected void onButtonClick() {
        String value = LookupManagerService.showApplicationRoleDialog(this.asSwing());
        if (value != null) {
            this.change(value);
            this.setComponentValue(value);
        }
    }

    @Override
    protected TextField createTextField(UiContainer parent) {
        TextField textField = super.createTextField(parent);
        textField.setColumns(30);
        return textField;
    }

    @Override
    protected void change(String value) {
        this.permissionRole.setValue(value);
        this.permissionRole.setApplicationContext("OracleBPMProcessRolesApp");
        ((TextField)this.getComponent()).setToolTipText("OracleBPMProcessRolesApp");
    }
}

