/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.I18nTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;

class PermissionPanelBuilder
extends TableHeaderPanelBuilder<String>
implements EntityEvents {
    private Permissions permissions;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return PermissionPanelBuilder.this.permissions;
        }
    };
    private TranslationService translationService;

    public PermissionPanelBuilder(Permissions permissions, TranslationService translationService) {
        super(CaseUiMsg.PERMISSIONS);
        this.permissions = permissions;
        this.translationService = translationService;
    }

    @Override
    public ProviderTableModel<String> createTableModel() {
        return new PermissionTableModel(this.permissions);
    }

    @Override
    public int actions() {
        return 7;
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] eventsFiltered;
        block5: for (Event event : eventsFiltered = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    this.addToModel((String)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    this.getTableModel().removeRow((String)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.tableModelChanged();
                }
            }
        }
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(I18nTableCellRenderer.create(this.translationService.getDefaultPropertyBundle()));
    }

    @Override
    protected void addAction() {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.CREATE_PERMISSION, this.permissions.getDefaultName());
        if (keyValue != null) {
            this.permissions.add((Object)keyValue.getFirst());
        }
    }

    @Override
    protected void editAction(String toEdit, int row) {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.EDIT_PERMISSION, toEdit);
        if (keyValue != null) {
            String value = keyValue.getFirst();
            this.getTableModel().getData().set(row, value);
            this.permissions.set(row, (Object)value);
        }
    }

    @Override
    protected void removeAction(List<String> toRemove) {
        for (String permission : toRemove) {
            this.permissions.remove((Object)permission);
        }
    }

    protected PermissionTableModel getTableModel() {
        return (PermissionTableModel)super.getTableModel();
    }

    private static class PermissionTableModel
    extends ProviderTableModel<String> {
        private static final int COLUMN_NAME = 0;

        public PermissionTableModel(Permissions permissions) {
            super(MsgList.create(CoreMsg.NAME));
            this.populate(permissions);
        }

        @Override
        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.getRow(row);
        }

        private void populate(Permissions permissions) {
            this.removeAllElements();
            for (String permission : permissions) {
                this.addRow(permission);
            }
        }
    }
}

