/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.Outcomes;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.I18nTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;

class OutcomesPanelBuilder
extends TableHeaderPanelBuilder<String>
implements EntityEvents {
    private Outcomes outcomes;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return OutcomesPanelBuilder.this.outcomes;
        }
    };
    private TranslationService translationService;

    public OutcomesPanelBuilder(Outcomes outcomes, TranslationService translationService) {
        super(CaseUiMsg.OUTCOMES);
        this.outcomes = outcomes;
        this.translationService = translationService;
    }

    public OutcomeTableModel createTableModel() {
        return new OutcomeTableModel(this.outcomes);
    }

    public OutcomeTableModel getTableModel() {
        return (OutcomeTableModel)super.getTableModel();
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] filteredEvents;
        block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    this.addToModel((String)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    this.getTableModel().removeRow((String)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.tableModelChanged();
                }
            }
        }
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(I18nTableCellRenderer.create(this.translationService.getDefaultPropertyBundle()));
    }

    @Override
    protected void addAction() {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.CREATE_OUTCOME, this.outcomes.getDefaultName());
        if (keyValue != null) {
            this.outcomes.add((Object)keyValue.getFirst());
        }
    }

    @Override
    protected void editAction(String toEdit, int row) {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.EDIT_OUTCOME, toEdit);
        if (keyValue != null) {
            this.getTableModel().updateModel(keyValue.getFirst(), row);
        }
    }

    @Override
    protected void removeAction(List<String> toRemove) {
        for (String event : toRemove) {
            this.outcomes.remove((Object)event);
        }
    }

    @Override
    protected int actions() {
        return 7;
    }

    private static class OutcomeTableModel
    extends ProviderTableModel<String> {
        private Outcomes outcomes;
        private static final int COLUMN_NAME = 0;

        public OutcomeTableModel(Outcomes outcomes) {
            super(MsgList.create(CoreMsg.NAME));
            this.outcomes = outcomes;
            this.populate(outcomes);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.updateModel((String)value, row);
        }

        public void updateModel(String value, int row) {
            this.getData().set(row, value);
            this.outcomes.set(row, (Object)value);
        }

        @Override
        public Class getColumnClass(int column) {
            return String.class;
        }

        @Override
        public String getValueAt(int row, int column) {
            return (String)this.getRow(row);
        }

        private void populate(Outcomes outcomes) {
            this.removeAllElements();
            for (String value : outcomes) {
                this.addRow(value);
            }
        }
    }
}

