/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Milestone;
import oracle.bpm.casemgmt.model.cm.Milestones;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.I18nTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;

class MilestonePanelBuilder
extends TableHeaderPanelBuilder<Milestone>
implements EntityEvents {
    private Milestones milestones;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return MilestonePanelBuilder.this.milestones;
        }
    };
    private TranslationService translationService;

    public MilestonePanelBuilder(Milestones milestones, TranslationService translationService) {
        super(CaseUiMsg.MILESTONES);
        this.milestones = milestones;
        this.translationService = translationService;
    }

    @Override
    public ProviderTableModel<Milestone> createTableModel() {
        return new MilestoneTableModel(this.milestones);
    }

    @Override
    public int actions() {
        return 7;
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] milestonesEvents;
        block5: for (Event event : milestonesEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    this.addToModel((Milestone)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    this.getTableModel().removeRow((Milestone)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.tableModelChanged();
                }
            }
        }
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(I18nTableCellRenderer.create(this.translationService.getDefaultPropertyBundle()));
    }

    @Override
    protected void addAction() {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.CREATE_MILESTONE, this.milestones.getDefaultName());
        if (keyValue != null) {
            Milestone milestone = CaseFactory.createMilestone();
            milestone.setName(keyValue.getFirst());
            this.milestones.add((Object)milestone);
        }
    }

    @Override
    protected void editAction(Milestone toEdit, int row) {
        String key = toEdit.getName();
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.EDIT_MILESTONE, key);
        if (keyValue != null) {
            toEdit.setName(keyValue.getFirst());
        }
    }

    @Override
    protected void removeAction(List<Milestone> toRemove) {
        for (Milestone milestone : toRemove) {
            this.milestones.remove((Object)milestone);
        }
    }

    protected MilestoneTableModel getTableModel() {
        return (MilestoneTableModel)super.getTableModel();
    }

    private static class MilestoneTableModel
    extends ProviderTableModel<Milestone> {
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_REQUIRED = 1;

        public MilestoneTableModel(Milestones milestones) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.CAN_BE_REVOKED));
            this.populate(milestones);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Milestone milestone = (Milestone)this.getRow(row);
            switch (column) {
                case 0: {
                    milestone.setName((String)value);
                    break;
                }
                case 1: {
                    milestone.setRequired(((Boolean)value).booleanValue());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            return column == 0 ? String.class : Boolean.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Milestone milestone = (Milestone)this.getRow(row);
            return column == 0 ? milestone.getName() : Boolean.valueOf(milestone.isRequired());
        }

        private void populate(Milestones milestones) {
            this.removeAllElements();
            for (Milestone milestone : milestones) {
                this.addRow(milestone);
            }
        }
    }
}

