/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.cm.editor.MilestonePanelBuilder;
import oracle.bpm.casemgmt.ui.cm.editor.OutcomesPanelBuilder;
import oracle.bpm.casemgmt.ui.cm.editor.PriorityComboBox;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.TranslatablePanel;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

class GeneralTabPanel
extends AbstractEntityPanel<Case> {
    private MilestonePanelBuilder milestonePanel;
    private OutcomesPanelBuilder outcomesPanel;
    private static final Image HEADER_ICON = Image.create(CaseUiMsg.CASE_HEADER_DESCRIPTION);

    public GeneralTabPanel(UiContainer parent, Case casemgmt, TranslationService translationService, String name) {
        super(parent, casemgmt);
        this.init(translationService, name);
    }

    @Override
    public void modelChanged(Event ... events) {
        this.milestonePanel.modelChanged(events);
        this.outcomesPanel.modelChanged(events);
    }

    private void init(TranslationService translationService, String name) {
        final Case casemgmt = (Case)this.getEntityModel();
        this.setLayout(FormBuilder.createLayoutWithMargin());
        UiComponent header = FormBuilder.createHeader(this, HEADER_ICON, CaseUiMsg.CASE_HEADER(name), CaseUiMsg.CASE_HEADER_DESCRIPTION);
        TranslatablePanel titlePanel = new TranslatablePanel(this, translationService, casemgmt.getTitle());
        final PriorityComboBox priorityCombo = new PriorityComboBox(this);
        priorityCombo.setSelectedItem(casemgmt.getPriority());
        priorityCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                casemgmt.setPriority(((Integer)priorityCombo.getSelectedItem()).intValue());
            }
        });
        TranslatablePanel categoryPanel = new TranslatablePanel(this, translationService, casemgmt.getCategory().getName());
        this.milestonePanel = new MilestonePanelBuilder(casemgmt.getMilestones(), translationService);
        this.outcomesPanel = new OutcomesPanelBuilder(casemgmt.getOutcomes(), translationService);
        FormBuilder.addExpandX(this, header);
        FormBuilder.add((UiContainer)this, CaseModelMsg.TITLE, titlePanel);
        FormBuilder.add((UiContainer)this, CaseModelMsg.PRIORITY, priorityCombo);
        FormBuilder.add((UiContainer)this, CaseModelMsg.CATEGORY, categoryPanel);
        FormBuilder.addExpandX(this, this.milestonePanel.build(this));
        FormBuilder.addExpandX(this, this.outcomesPanel.build(this));
    }
}

