/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.Events;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.I18nTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.draw.Color;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;

class EventsTabPanel
extends AbstractEntityPanel<Case> {
    private EventsPanelBuilder eventsPanel;

    public EventsTabPanel(UiContainer parent, Case casemgmt, TranslationService translationService) {
        super(parent, casemgmt);
        this.init(translationService);
    }

    @Override
    public void modelChanged(Event ... events) {
        this.eventsPanel.modelChanged(events);
    }

    private void init(TranslationService translationService) {
        final Case casemgmt = (Case)this.getEntityModel();
        this.setLayout(new MigLayout("fillx, width max(100,50%), gapx 8, gapy 6, ins 8"));
        Events events = casemgmt.getEvents();
        this.eventsPanel = new EventsPanelBuilder(events, translationService);
        Label publishEventsLabel = Label.createWithNoColon((UiContainer)this, CaseUiMsg.PUBLISH_CASE_EVENTS_DESCRIPTION);
        publishEventsLabel.setForeground(Color.GRAY);
        CheckBox publishEventsCheckBox = CheckBox.create(this, CaseUiMsg.PUBLISH_CASE_EVENTS, casemgmt.isPublishEvents());
        publishEventsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                casemgmt.setPublishEvents(e.isStateSelected());
            }
        });
        this.add(this.eventsPanel.build(this), "growx, wrap");
        this.add(publishEventsLabel, "growx, gapy 12, wrap");
        this.add(publishEventsCheckBox);
    }

    private static class EventsPanelBuilder
    extends TableHeaderPanelBuilder<String>
    implements EntityEvents {
        private Events events;
        private final EventFilter FILTER = new EventFilter.Default(){

            protected Entity validInstance() {
                return EventsPanelBuilder.this.events;
            }
        };
        private TranslationService translationService;

        public EventsPanelBuilder(Events events, TranslationService translationService) {
            super(CaseUiMsg.USER_EVENTS, CaseUiMsg.USER_EVENTS_DESCRIPTION);
            this.events = events;
            this.translationService = translationService;
        }

        public EventTableModel createTableModel() {
            return new EventTableModel(this.events);
        }

        public EventTableModel getTableModel() {
            return (EventTableModel)super.getTableModel();
        }

        @Override
        public void modelChanged(Event ... events) {
            Event[] filteredEvents;
            block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
                Event childEvent = event.getChildEvent();
                if (childEvent == null) continue;
                EventType type = childEvent.getType();
                switch (type) {
                    case ATTR_ADDED: {
                        this.addToModel((String)childEvent.getNewValue());
                        continue block5;
                    }
                    case ATTR_REMOVED: {
                        this.getTableModel().removeRow((String)childEvent.getOldValue());
                        continue block5;
                    }
                    case ATTR_CHANGED: {
                        this.tableModelChanged();
                    }
                }
            }
        }

        @Override
        protected UiComponent buildEditor(UiContainer parent) {
            Case casemgmt = this.translationService.getCase();
            Panel result = new Panel(parent);
            result.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
            result.add(super.buildEditor(result), "grow, wrap");
            return result;
        }

        @Override
        protected void customizeTable(GenericTable table) {
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn column0 = columnModel.getColumn(EventTableModel.COLUMN_NAME);
            column0.setCellRenderer(I18nTableCellRenderer.create(this.translationService.getDefaultPropertyBundle()));
        }

        @Override
        protected void addAction() {
            Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.CREATE_USER_EVENT, this.events.getDefaultName());
            if (keyValue != null) {
                this.events.add((Object)keyValue.getFirst());
            }
        }

        @Override
        protected void editAction(String toEdit, int row) {
            Tuple<String, String> keyValue = this.translationService.showDialog(this.getOwnerWindow(), CaseUiMsg.EDIT_USER_EVENT, toEdit);
            if (keyValue != null) {
                this.getTableModel().updateModel(keyValue.getFirst(), row);
            }
        }

        @Override
        protected void removeAction(List<String> toRemove) {
            for (String event : toRemove) {
                this.events.remove((Object)event);
            }
        }

        @Override
        protected int actions() {
            return 7;
        }

        private static class EventTableModel
        extends ProviderTableModel<String> {
            private Events events;
            private static int COLUMN_NAME = 0;

            public EventTableModel(Events events) {
                super(MsgList.create(CoreMsg.NAME));
                this.events = events;
                this.populate(events);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                this.updateModel((String)value, row);
            }

            public void updateModel(String value, int row) {
                this.getData().set(row, value);
                this.events.set(row, (Object)value);
            }

            @Override
            public Class getColumnClass(int column) {
                return String.class;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return this.getRow(row);
            }

            private void populate(Events events) {
                this.removeAllElements();
                for (String value : events) {
                    this.addRow(value);
                }
            }
        }
    }
}

