/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.EcmFolder;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.components.CaseContext;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.ValuePanel;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import org.jetbrains.annotations.NotNull;

class DocumentPanelBuilder
extends HeaderPanelBuilder
implements EntityEvents {
    private CaseContext caseContext;
    private EcmFolder ecmFolder;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return DocumentPanelBuilder.this.ecmFolder;
        }
    };

    public DocumentPanelBuilder(@NotNull CaseContext caseContext, EcmFolder folder) {
        super(CaseUiMsg.DOCUMENTS, CaseUiMsg.DOCUMENTS_DESCRIPTION);
        this.caseContext = caseContext;
        this.ecmFolder = folder;
    }

    @Override
    public void modelChanged(Event ... events) {
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout(FormBuilder.createLayoutWithoutMargin());
        ValuePanel parentFolderPanel = new ValuePanel(result, this.caseContext, this.ecmFolder.getParentFolder());
        ValuePanel instanceFolderPanel = new ValuePanel(result, this.caseContext, this.ecmFolder.getCaseInstanceFolder());
        CheckBox subFolderCheckbox = CheckBox.create(result, CaseUiMsg.CREATE_CASE_INSTANCE_FOLDER, this.ecmFolder.isCreateSubFolder());
        subFolderCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.isStateSelected();
                DocumentPanelBuilder.this.ecmFolder.setCreateSubFolder(selected);
            }
        });
        FormBuilder.add((UiContainer)result, CaseUiMsg.PARENT_FOLDER, parentFolderPanel);
        FormBuilder.add((UiContainer)result, CaseUiMsg.CASE_INSTANCE_FOLDER, instanceFolderPanel);
        FormBuilder.add(result, subFolderCheckbox);
        return result;
    }
}

