/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.namespace.QName;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.cm.editor.CaseDataDialog;
import oracle.bpm.casemgmt.ui.cm.form.FormGenerator;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.ErrorTableCellRenderer;
import oracle.bpm.casemgmt.ui.common.I18nTableCellRenderer;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.common.model.transactions.ModelTransaction;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeToXsdMapping;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.table.GenericTable;
import org.jetbrains.annotations.NotNull;

class DataPanelBuilder
extends TableHeaderPanelBuilder<Data>
implements EntityEvents {
    private CaseData caseData;
    private URL caseUrl;
    private Action createFormAction;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return DataPanelBuilder.this.caseData;
        }
    };
    private oracle.bpm.project.model.Project project;
    private TranslationService translationService;
    private static final Icon XML_ICON = Image.create(CaseUiMsg.XML_SCHEMA_ELEMENT).asSwingIcon();
    private static final Icon CASE_FORM_ICON = Image.create(CaseUiMsg.CASE_FORM_ICON).asSwingIcon();

    public DataPanelBuilder(CaseData caseData, @NotNull TranslationService translationService) {
        super(CaseUiMsg.DATA, CaseUiMsg.DATA_DESCRIPTION);
        this.caseData = caseData;
        this.translationService = translationService;
        this.project = translationService.getCaseContext().getBpmProject();
    }

    @Override
    public ProviderTableModel<Data> createTableModel() {
        return new DataTableModel(this.caseData);
    }

    public DataTableModel getTableModel() {
        return (DataTableModel)super.getTableModel();
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] caseDataEvents;
        block5: for (Event event : caseDataEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    this.addToModel((Data)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    this.getTableModel().removeRow((Data)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.tableModelChanged();
                }
            }
        }
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(I18nTableCellRenderer.create(this.translationService.getDefaultPropertyBundle()));
        DataPanelBuilder.setColumnSize(column0, 250);
        TableColumn column1 = columnModel.getColumn(1);
        column1.setCellRenderer(new TypeTableCellRenderer());
        column1.setCellEditor(new TypeTableCellEditor());
        TableColumn column2 = columnModel.getColumn(2);
        DataPanelBuilder.setColumnSize(column2, 70);
    }

    @Override
    protected void addAction() {
        CaseDataDialog dialog = CaseDataDialog.createForCreation(this.getOwnerWindow(), this.translationService, this.caseData.getDefaultName());
        if (dialog.showDialog()) {
            Data data = dialog.getData();
            this.translationService.getDefaultPropertyBundle().put((Object)data.getName(), (Object)dialog.getDisplayName());
            this.caseData.add((Object)data);
        }
    }

    @Override
    protected void removeAction(List<Data> toRemove) {
        for (Data data : toRemove) {
            this.caseData.remove((Object)data);
        }
    }

    @Override
    protected void editAction(Data toEdit, int row) {
        CaseDataDialog dialog = CaseDataDialog.createForEdition(this.getOwnerWindow(), this.translationService, toEdit);
        if (dialog.showDialog()) {
            Data newData = dialog.getData();
            this.translationService.getDefaultPropertyBundle().put((Object)newData.getName(), (Object)dialog.getDisplayName());
            DataPanelBuilder.copyData(newData, toEdit);
        }
    }

    @Override
    protected int actions() {
        return 7;
    }

    @Override
    protected Action[] customActions() {
        this.createFormAction = new AbstractAction("", CASE_FORM_ICON){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int selectedRow = DataPanelBuilder.this.getTable().getSelectedRow();
                    Data data = (Data)DataPanelBuilder.this.getTableModel().getRow(selectedRow);
                    String dataObjName = data.getName();
                    String schemaRelPath = data.getSchema();
                    String elementQNameVal = data.getType();
                    QName elementQName = QName.valueOf(elementQNameVal);
                    String elementNamespace = elementQName.getNamespaceURI();
                    String elementName = elementQName.getLocalPart();
                    Project bpmProj = DataPanelBuilder.this.translationService.getCaseContext().getProject();
                    Workspace ws = Ide.getActiveWorkspace();
                    Case caseObj = DataPanelBuilder.this.translationService.getCaseContext().getCase();
                    FormGenContext formGenCtx = new FormGenContext(ws, caseObj);
                    formGenCtx.setBpmProject(bpmProj);
                    formGenCtx.setDataObjectName(dataObjName);
                    formGenCtx.setSchemaUrl(schemaRelPath);
                    formGenCtx.setElementNamespace(elementNamespace);
                    formGenCtx.setElementName(elementName);
                    formGenCtx.setCaseUrl(DataPanelBuilder.this.caseUrl);
                    formGenCtx.setCompositeName(DataPanelBuilder.this.translationService.getCaseContext().getBpmProject().getName());
                    FormGenerator formGen = new FormGenerator(formGenCtx);
                    Component formButton = (Component)event.getSource();
                    formGen.handleCaseFormButton(formButton);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                }
            }
        };
        this.createFormAction.setEnabled(false);
        String toolTip = CaseUiMsg.CASE_FORM.getString();
        this.createFormAction.putValue("ShortDescription", toolTip);
        return new Action[]{this.createFormAction};
    }

    @Override
    protected void selectionChanged(int[] selectedRows) {
        super.selectionChanged(selectedRows);
        if (this.createFormAction != null) {
            String toolTip = CaseUiMsg.CASE_FORM.getString();
            this.createFormAction.putValue("ShortDescription", toolTip);
            this.createFormAction.setEnabled(false);
            if (selectedRows.length == 1) {
                int selectedRow = this.getTable().getSelectedRow();
                Data data = (Data)this.getTableModel().getRow(selectedRow);
                DataType dt = data.getDataType();
                String unsupportedToolTip = CaseUiMsg.CASE_FORM_SIMPLE_TYPE_MSG.getString();
                String schemaRelPath = data.getSchema();
                String elementQNameVal = data.getType();
                QName elementQName = QName.valueOf(elementQNameVal);
                String elementNamespace = elementQName.getNamespaceURI();
                String elementName = elementQName.getLocalPart();
                Project bpmProj = this.translationService.getCaseContext().getProject();
                if (schemaRelPath == null || schemaRelPath.trim().equals("")) {
                    this.createFormAction.putValue("ShortDescription", unsupportedToolTip);
                } else if (elementName == null || elementName.trim().equals("")) {
                    this.createFormAction.putValue("ShortDescription", unsupportedToolTip);
                } else if (elementNamespace == null || elementNamespace.trim().equals("")) {
                    this.createFormAction.putValue("ShortDescription", unsupportedToolTip);
                } else {
                    try {
                        URL schemaUrl = FormGenHelper.getSchemaUrl(bpmProj, schemaRelPath);
                        if (FormGenHelper.isSimpleType(schemaUrl, elementNamespace, elementName)) {
                            this.createFormAction.putValue("ShortDescription", unsupportedToolTip);
                        } else {
                            this.createFormAction.setEnabled(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.createFormAction.putValue("ShortDescription", unsupportedToolTip);
                    }
                }
            }
        }
    }

    protected void selectData(String dataObjName) {
        if (dataObjName == null) {
            return;
        }
        DataTableModel tableModel = this.getTableModel();
        if (tableModel == null) {
            return;
        }
        int rowCount = tableModel.getRowCount();
        int row = -1;
        for (int i = 0; i < rowCount; ++i) {
            Data data = (Data)tableModel.getRow(i);
            if (!dataObjName.equals(data.getName())) continue;
            row = i;
            break;
        }
        if (row > -1) {
            GenericTable dataTable = this.getTable();
            dataTable.setRowSelectionInterval(row, row);
        } else {
            String warningTitle = CaseUiMsg.CASE_FORM_WARNING.getString();
            String[] args = new String[]{dataObjName};
            String msg = CaseUiMsg.CASE_FORM_DATA_NOT_FOUND.getString();
            MessageFormat msgFormat = new MessageFormat(msg);
            msg = msgFormat.format(args);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, warningTitle, 2);
        }
    }

    protected void setCaseURL(URL url) {
        this.caseUrl = url;
    }

    private static void copyData(Data newData, Data data) {
        ModelTransaction tx = data.beginTransaction();
        data.setName(newData.getName());
        data.setDataType(newData.getDataType());
        data.setType(newData.getType());
        data.setSchema(newData.getSchema());
        data.setEditable(newData.isEditable());
        tx.commit();
    }

    private static String getToolTip(CatalogType catalogType) {
        TypeDescription delegate = catalogType.getDelegate();
        SchemaObject schemaObject = delegate.asSchemaObject();
        return schemaObject.getQName().toString();
    }

    private class TypeTableCellRenderer
    extends ErrorTableCellRenderer<Data> {
        private boolean errorType;

        private TypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Data data = (Data)value;
            CatalogType catalogType = CaseUtils.findCatalogType(DataPanelBuilder.this.project, data);
            this.errorType = false;
            if (catalogType != null) {
                result.setText(this.getText(catalogType));
                result.setIcon(this.getIcon(catalogType));
                result.setToolTipText(DataPanelBuilder.getToolTip(catalogType));
            } else if (!Str.isEmpty(data.getType()) && data.getDataType().isSimpleType()) {
                String sQName = data.getType();
                try {
                    QName qName = QName.valueOf(sQName);
                    result.setText(qName.getLocalPart());
                    result.setIcon(XML_ICON);
                    result.setToolTipText(qName.toString());
                }
                catch (Exception e) {
                    this.errorType = true;
                }
            } else {
                this.errorType = true;
            }
            if (this.errorType) {
                this.setText(data.getType());
                this.setIcon(null);
            }
            return result;
        }

        @Override
        protected String error(Data value) {
            return this.errorType ? CaseUiMsg.ERROR_INVALID_TYPE.getString() : null;
        }

        private Icon getIcon(CatalogType element) {
            return ProjectObjectRenderer.Default.getIcon((ProjectObject)element).asSwingIcon();
        }

        private String getText(CatalogType element) {
            return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
        }
    }

    private class TypeTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private CatalogType basicXmlTypeAdded;
        private Data value;

        public TypeTableCellEditor() {
            super(new JComboBox(){

                @Override
                public void paint(Graphics g) {
                    String error;
                    super.paint(g);
                    Object selectedItem = this.getSelectedItem();
                    String string = error = selectedItem == null ? CaseUiMsg.ERROR_INVALID_TYPE.getString() : null;
                    if (error != null) {
                        CaseUtils.paintHorizontalSquiggleLine(g, this, "");
                    }
                    this.setToolTipText(error);
                }
            });
            this.basicXmlTypeAdded = null;
            this.getComponent().setRenderer(new TypeCellRenderer(new BasicType(){

                @Override
                public boolean isAdded(CatalogType type) {
                    return TypeTableCellEditor.this.basicXmlTypeAdded == type;
                }
            }));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = (Data)value;
            this.populate(this.value);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public JComboBox getComponent() {
            return (JComboBox)super.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            CatalogType type = (CatalogType)super.getCellEditorValue();
            return type != null ? CaseManagementUtils.createData((CatalogType)type) : this.value;
        }

        private void populate(Data value) {
            JComboBox comboBox = this.getComponent();
            comboBox.removeAllItems();
            CatalogType toSelect = null;
            Sequence<CatalogType> catalogTypes = CaseUtils.getTypes(DataPanelBuilder.this.project);
            for (CatalogType type : catalogTypes) {
                comboBox.addItem(type);
                if (toSelect != null || !CaseManagementUtils.isCaseDataTypeEquivalent((Data)value, (CatalogType)type)) continue;
                toSelect = type;
            }
            if (toSelect == null && value.getDataType().isSimpleType()) {
                String sQName = value.getType();
                try {
                    QName qName = QName.valueOf(sQName);
                    String localPart = qName.getLocalPart();
                    TypeDescription typeDescription = (TypeDescription)TypeToXsdMapping.getXsdToType().get(localPart);
                    CatalogType catalogType = CatalogType.Default.get((TypeRef)typeDescription);
                    if (catalogType != null) {
                        comboBox.insertItemAt(catalogType, CaseUtils.getPrimitiveTypes().size());
                        toSelect = catalogType;
                        this.basicXmlTypeAdded = catalogType;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            comboBox.setSelectedItem(toSelect);
        }

        private class TypeCellRenderer
        extends DefaultListCellRenderer {
            private BasicType basicType;

            public TypeCellRenderer(BasicType basicType) {
                this.basicType = basicType;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof CatalogType) {
                    CatalogType type = (CatalogType)value;
                    if (this.basicType.isAdded(type)) {
                        SchemaObject schemaObject = type.getDelegate().asSchemaObject();
                        QName qName = schemaObject.getQName();
                        result.setText(qName.getLocalPart());
                        result.setIcon(XML_ICON);
                        result.setToolTipText(qName.toString());
                    } else {
                        result.setText(this.getText(type));
                        result.setIcon(this.getIcon(type));
                        result.setToolTipText(DataPanelBuilder.getToolTip(type));
                    }
                }
                return result;
            }

            private Icon getIcon(CatalogType element) {
                return ProjectObjectRenderer.Default.getIcon((ProjectObject)element).asSwingIcon();
            }

            private String getText(CatalogType element) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
            }
        }
    }

    private class DataTableModel
    extends ProviderTableModel<Data> {
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_TYPE = 1;
        private static final int COLUMN_EDITABLE = 2;

        public DataTableModel(CaseData caseData) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.TYPE, CaseUiMsg.EDITABLE));
            this.populate(caseData);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Data data = (Data)this.getRow(row);
            switch (column) {
                case 0: {
                    data.setName((String)value);
                    break;
                }
                case 1: {
                    Data newData = (Data)value;
                    ModelTransaction tx = data.beginTransaction();
                    data.setDataType(newData.getDataType());
                    data.setType(newData.getType());
                    data.setSchema(newData.getSchema());
                    tx.commit();
                    break;
                }
                case 2: {
                    data.setEditable(((Boolean)value).booleanValue());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            return column == 0 ? String.class : (column == 1 ? Data.class : Boolean.class);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Data data = (Data)this.getRow(row);
            switch (column) {
                case 0: {
                    return data.getName();
                }
                case 1: {
                    return data;
                }
                case 2: {
                    return data.isEditable();
                }
            }
            return null;
        }

        private void populate(CaseData caseData) {
            this.removeAllElements();
            for (Data data : caseData) {
                this.addRow(data);
            }
        }
    }

    private static interface BasicType {
        public boolean isAdded(CatalogType var1);
    }
}

