/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.net.URL;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.ui.cm.editor.DataPanelBuilder;
import oracle.bpm.casemgmt.ui.cm.editor.DocumentPanelBuilder;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class DataDocumentTabPanel
extends AbstractEntityPanel<Case> {
    private DataPanelBuilder dataPanel;
    private DocumentPanelBuilder documentPanel;

    public DataDocumentTabPanel(UiContainer parent, @NotNull Case casemgmt, @NotNull TranslationService translationService) {
        super(parent, casemgmt);
        this.init(translationService);
    }

    @Override
    public void modelChanged(Event ... events) {
        this.dataPanel.modelChanged(events);
        this.documentPanel.modelChanged(events);
    }

    protected void selectData(String dataObjName) {
        if (this.dataPanel == null) {
            return;
        }
        this.dataPanel.selectData(dataObjName);
    }

    protected void setCaseUrl(URL url) {
        if (this.dataPanel == null) {
            return;
        }
        this.dataPanel.setCaseURL(url);
    }

    private void init(@NotNull TranslationService translationService) {
        CaseData caseData;
        Case casemgmt = (Case)this.getEntityModel();
        this.setLayout(FormBuilder.createLayoutWithMargin());
        if (casemgmt.getCaseData().isEmpty()) {
            caseData = CaseFactory.createCaseData();
            casemgmt.addCaseData(caseData);
        } else {
            caseData = (CaseData)casemgmt.getCaseData().get(0);
        }
        this.dataPanel = new DataPanelBuilder(caseData, translationService);
        this.documentPanel = new DocumentPanelBuilder(translationService.getCaseContext(), casemgmt.getEcmFolder());
        FormBuilder.addExpandX(this, this.dataPanel.build(this));
        FormBuilder.addExpandX(this, this.documentPanel.build(this));
    }
}

