/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.net.URL;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.cm.CaseNode;
import oracle.bpm.casemgmt.ui.cm.editor.DataDocumentTabPanel;
import oracle.bpm.casemgmt.ui.cm.editor.EventsTabPanel;
import oracle.bpm.casemgmt.ui.cm.editor.GeneralTabPanel;
import oracle.bpm.casemgmt.ui.cm.editor.StakeHoldersTabPanel;
import oracle.bpm.casemgmt.ui.cm.editor.TranslationTabPanel;
import oracle.bpm.casemgmt.ui.common.AbstractEntityEditor;
import oracle.bpm.casemgmt.ui.components.CaseContext;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.Context;
import oracle.ide.model.Project;

public class CaseEditor
extends AbstractEntityEditor<Case> {
    DataDocumentTabPanel dataDocPanel;
    TabbedPane tabbedPane;

    public void selectData(String dataObjName) {
        if (this.dataDocPanel == null) {
            return;
        }
        if (this.tabbedPane == null) {
            return;
        }
        this.tabbedPane.setSelectedComponent(this.dataDocPanel);
        this.dataDocPanel.selectData(dataObjName);
    }

    @Override
    protected Case getEntityModel(Context context) {
        CaseNode node = (CaseNode)context.getNode();
        return (Case)node.getEntityModel();
    }

    @Override
    protected void addTabs(TabbedPane tabbedPane) {
        Case casemgmt = (Case)this.getEntityModel();
        Project project = this.getContext().getProject();
        CaseContext caseContext = CaseContext.create(project, casemgmt);
        oracle.bpm.project.model.Project bpmProject = caseContext.getBpmProject();
        TranslationService translationService = TranslationService.create(caseContext);
        CaseNode caseNode = (CaseNode)this.getContext().getNode();
        URL caseUrl = caseNode.getURL();
        this.tabbedPane = tabbedPane;
        tabbedPane.addTab(CaseUiMsg.GENERAL, (UiComponent)new GeneralTabPanel(tabbedPane, casemgmt, translationService, this.getTabDescription()));
        this.dataDocPanel = new DataDocumentTabPanel(tabbedPane, casemgmt, translationService);
        this.dataDocPanel.setCaseUrl(caseUrl);
        tabbedPane.addTab(CaseUiMsg.DATA_AND_DOCUMENTS, (UiComponent)this.dataDocPanel);
        tabbedPane.addTab(CaseUiMsg.USER_EVENTS, (UiComponent)new EventsTabPanel(tabbedPane, casemgmt, translationService));
        Organization organization = bpmProject.getOrganization();
        tabbedPane.addTab(CaseUiMsg.STAKEHOLDERS_AND_PERSMISSIONS, (UiComponent)new StakeHoldersTabPanel(tabbedPane, casemgmt, translationService, organization));
        TranslationTabPanel translationTabPanel = new TranslationTabPanel((UiContainer)tabbedPane, casemgmt);
        tabbedPane.addTab(CaseUiMsg.TRANSLATION, (UiComponent)translationTabPanel);
    }
}

