/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.components.TypeComboBox;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.NewBpmObjectAction;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import org.jetbrains.annotations.Nullable;

class CaseDataDialog
extends JEWTDialog {
    private DataPanel dataPanel;

    private CaseDataDialog(UiWindow parent, TranslationService translationService, Msg msg, Data data) {
        super((Frame)Ide.getMainWindow(), msg.getString(), 7);
        this.init(translationService, data);
        HelpSystem.getHelpSystem().registerTopic(this.dataPanel.asSwing(), "f1_bpm_casemgcreateparamd_html");
    }

    public static CaseDataDialog createForCreation(UiWindow parent, TranslationService translationService, String defaultName) {
        Data data = CaseFactory.createData();
        data.setName(defaultName);
        return new CaseDataDialog(parent, translationService, CaseUiMsg.CREATE_PARAMETER, data);
    }

    public static CaseDataDialog createForEdition(UiWindow parent, TranslationService translationService, @Nullable Data data) {
        return new CaseDataDialog(parent, translationService, CaseUiMsg.EDIT_PARAMETER, data);
    }

    public Data getData() {
        return this.dataPanel.getData();
    }

    public String getDisplayName() {
        return this.dataPanel.getDisplayName();
    }

    public boolean showDialog() {
        return WizardLauncher.runDialog((JDialog)((Object)this));
    }

    private void init(TranslationService translationService, Data data) {
        VetoableChangeListener OkListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    Data parameter = CaseDataDialog.this.getData();
                    if (parameter.getName().trim().isEmpty()) {
                        MessageDialog.showError(CaseUiMsg.INVALID_NAME, CaseUiMsg.INVALID_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                    if (CaseDataDialog.this.getDisplayName().trim().isEmpty()) {
                        MessageDialog.showError(CaseUiMsg.INVALID_DISPLAY_NAME, CaseUiMsg.INVALID_DISPLAY_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                }
            }
        };
        this.addVetoableChangeListener(OkListener);
        this.dataPanel = new DataPanel(UiContainer.NULL, translationService, data);
        this.setContent(this.dataPanel.asSwing());
    }

    private static class DataPanel
    extends Panel {
        private TextField displayNameTextField;
        private CheckBox editableCheckBox;
        private IdentifierTextField nameTextField;
        private TranslationService translationService;
        private TypeComboBox typeComboBox;

        public DataPanel(UiContainer parent, TranslationService translationService, Data data) {
            super(parent);
            this.translationService = translationService;
            this.init(data);
        }

        public Data getData() {
            CatalogType type = (CatalogType)this.typeComboBox.getSelectedItem();
            Data result = CaseManagementUtils.createData((CatalogType)type);
            result.setName(this.nameTextField.getText());
            result.setEditable(this.editableCheckBox.isSelected());
            return result;
        }

        public String getDisplayName() {
            return this.displayNameTextField.getText();
        }

        private void init(Data data) {
            final Project project = this.translationService.getCaseContext().getBpmProject();
            Sequence<CatalogType> types = CaseUtils.getTypes(project);
            String name = data != null ? data.getName() : "";
            this.nameTextField = new IdentifierTextField((UiContainer)this, name, 30, true);
            this.displayNameTextField = new TextField((UiContainer)this, this.getDisplayName(name), 30);
            this.nameTextField.addDocumentListener(new DocumentListener.Default(){

                @Override
                public void anyUpdate(DocumentEvent e) {
                    DataPanel.this.displayNameTextField.setText(DataPanel.this.getDisplayName(DataPanel.this.nameTextField.getText()));
                }
            });
            this.typeComboBox = new TypeComboBox((UiContainer)this, CollectionUtils.toList(types));
            Button addButton = Button.createIconic(this, UIMsg.ADD);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewBpmObjectAction action = new NewBpmObjectAction(project.getCatalogRoot());
                    action.setOpenEditor(false);
                    if (action.doIt()) {
                        CatalogObject businessObject = action.getBusinessObject();
                        DataPanel.this.typeComboBox.addItem(businessObject);
                        DataPanel.this.typeComboBox.setSelectedItem(businessObject);
                    }
                }
            });
            this.editableCheckBox = CheckBox.create(this, CaseUiMsg.EDITABLE, true);
            if (data != null) {
                CatalogType catalogType = CaseUtils.findCatalogType(project, data);
                if (catalogType != null) {
                    this.typeComboBox.setSelectedItem(catalogType);
                }
                this.typeComboBox.requestFocus();
                this.editableCheckBox.setSelected(data.isEditable());
            }
            this.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
            this.add(Label.create((UiContainer)this, CoreMsg.NAME));
            this.add(this.nameTextField, "wrap");
            this.add(Label.create((UiContainer)this, CaseUiMsg.DISPLAY_NAME));
            this.add(this.displayNameTextField, "wrap");
            this.add(Label.create((UiContainer)this, CoreMsg.TYPE));
            this.add(this.typeComboBox, "growx, pushx");
            this.add(addButton, "growx, pushx, wrap");
            this.add(this.editableCheckBox, "skip 1, wrap");
        }

        private String getDisplayName(String key) {
            String value = key != null ? this.translationService.getValue(key) : null;
            return value == null ? key : value;
        }
    }
}

