/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.layout.FieldLayoutBuilder;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.table.GenericTable;

class ActivitiesTabPanel
extends AbstractEntityPanel<Case> {
    public ActivitiesTabPanel(UiContainer parent, Case casemgmt) {
        super(parent, casemgmt);
        this.init();
    }

    @Override
    public void modelChanged(Event ... events) {
    }

    private void init() {
        Case casemgmt = (Case)this.getEntityModel();
        this.setLayout(FormBuilder.createLayoutWithMargin());
        FormBuilder.addExpandX(this, UiComponent.get((Object)new GeneralPage()));
    }

    private static class NiceTable
    extends GenericTable {
        private NiceTable() {
        }
    }

    private static class ActivitiesPanel
    extends HeaderPanelBuilder {
        public ActivitiesPanel(UiContainer parent) {
            super(CaseUiMsg.ACTIVITIES);
        }

        @Override
        protected UiComponent buildEditor(UiContainer parent) {
            return Label.createWithNoColon(parent, Msg.QUOTE("Under Developing..."));
        }

        @Override
        protected int actions() {
            return 5;
        }
    }

    final class GeneralPage
    extends TransparentPanel {
        GeneralPage() {
            this.layoutComponents();
        }

        private void layoutComponents() {
            this.setLayout((LayoutManager)new VerticalFlowLayout());
            this.addPageHeader("General");
            this.addSubPanel("Stuff", "This is an example expandable panel", (JComponent)((Object)new StuffPanel()));
            this.addSubPanel("Nonsense", "This is another example panel", (JComponent)((Object)new StuffPanel()));
            this.addSubPanel("Tables", "Demonstrates multiple tables", (JComponent)((Object)new PanelWithTwoTables()));
        }

        private void addSubPanel(String title, String hint, JComponent component) {
            HeaderPanel stuff = new HeaderPanel();
            stuff.getHeader().setText(title);
            stuff.getHeader().setLevel(Header.Level.SUB);
            stuff.getHeader().addActionControl(this.createIconicAction(OracleIcons.getIcon((String)"add.png")));
            stuff.setStaticHelpText(hint);
            stuff.setHostedComponent(component);
            this.add((Component)stuff);
        }

        private void addPageHeader(String pageTitle) {
            Header pageHeader = new Header();
            pageHeader.setText(pageTitle);
            pageHeader.setLevel(Header.Level.PAGE);
            pageHeader.setRollupStatusText("This is the Help Topic ID\nbla bla bla");
            pageHeader.setIcon(Image.create(CaseUiMsg.CASE_HEADER_DESCRIPTION).asSwingIcon());
            this.add((Component)pageHeader);
        }

        private AbstractButton createBrowseButton() {
            JButton b = new JButton();
            IconicButtonUI.install((AbstractButton)b);
            b.setIcon(OracleIcons.getIcon((String)"lov.png"));
            return b;
        }

        private Action createIconicAction(Icon icon) {
            return new AbstractAction("", icon){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }

        private class StuffPanel
        extends TransparentPanel {
            StuffPanel() {
                FieldLayoutBuilder b = new FieldLayoutBuilder((Container)((Object)this));
                b.add((FieldLayoutBuilder.ComponentTextSetup)b.field().label(new JLabel()).withText("&Name:").component((JComponent)new JTextField()));
                b.add((FieldLayoutBuilder.ComponentTextSetup)b.field().label(new JLabel()).withText("&Email:").component((JComponent)new JTextField()));
                b.add(b.field().label(new JLabel()).withText("&State:").component(new JComboBox()).button(GeneralPage.this.createBrowseButton()).withText(""));
            }
        }

        private class PanelWithTwoTables
        extends TransparentPanel {
            PanelWithTwoTables() {
                this.setLayout((LayoutManager)new VerticalFlowLayout());
                this.add((Component)this.createTable("Things", false));
                this.add((Component)this.createTable("More Things", true));
            }

            private ComponentWithTitlebar createTable(String label, boolean useScrollPane) {
                NiceTable t = new NiceTable();
                ((JTable)((Object)t)).setModel(this.createDummyTableModel());
                JLabel jLabel = new JLabel(label);
                jLabel.setLabelFor((Component)((Object)t));
                ComponentWithTitlebar tbComp = new ComponentWithTitlebar();
                tbComp.setComponent(useScrollPane ? this.createScrollPaneTable((JTable)((Object)t)) : this.createStandaloneTable((JTable)((Object)t)));
                tbComp.setLabel(jLabel);
                ControlBar cb = new ControlBar();
                this.installAddEditRemove(cb);
                tbComp.setControlBar(cb);
                return tbComp;
            }

            private JComponent createScrollPaneTable(JTable table) {
                return new JScrollPane(table);
            }

            private JComponent createStandaloneTable(JTable table) {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)table.getTableHeader(), "North");
                p.add((Component)table, "Center");
                return p;
            }

            private void installAddEditRemove(ControlBar cb) {
                cb.add(this.createTextAction("Foo"));
                cb.add(this.createTextAction("Bar"));
                cb.add(GeneralPage.this.createIconicAction(OracleIcons.getIcon((String)"add.png")));
                cb.add(GeneralPage.this.createIconicAction(OracleIcons.getIcon((String)"edit.png")));
                cb.add(GeneralPage.this.createIconicAction(OracleIcons.getIcon((String)"delete.png")));
            }

            private Action createTextAction(String text) {
                return new AbstractAction(text){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
            }

            private TableModel createDummyTableModel() {
                class DummyTableModel
                extends AbstractTableModel {
                    DummyTableModel() {
                    }

                    @Override
                    public int getRowCount() {
                        return 5;
                    }

                    @Override
                    public int getColumnCount() {
                        return 2;
                    }

                    @Override
                    public String getColumnName(int columnIndex) {
                        return columnIndex == 0 ? "Name" : "Value";
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        return String.valueOf(rowIndex) + ", " + String.valueOf(columnIndex);
                    }
                }
                return new DummyTableModel();
            }
        }
    }
}

