/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.CaseActivityNode;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.wizard.Wizard;
import org.jetbrains.annotations.Nullable;

public class CustomCaseActivityWizard
extends Wizard {
    private boolean openEditor;
    private static final Icon ICON = oracle.bpm.ui.Image.create(CaseUiMsg.CASE_ACTIVITY).asSwingIcon();
    private static final Logger LOGGER = Logger.getLogger(CustomCaseActivityWizard.class.getName());

    public CustomCaseActivityWizard() {
        this(true);
    }

    public CustomCaseActivityWizard(boolean openEditor) {
        this.openEditor = openEditor;
    }

    public boolean isAvailable(Context context) {
        Project project = context.getProject();
        return project != null && CaseUtils.existCase(project) && CaseUtils.getBpmProject(project) != null;
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getShortLabel() {
        return CaseModelMsg.CUSTOM_CASE_ACTIVITY.getString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke(Context context) {
        boolean result = false;
        if (this.isAvailable(context)) {
            CaseActivityInfo caseActivityInfo = CustomCaseActivityDialog.show((Frame)Ide.getMainWindow(), context.getProject());
            if (caseActivityInfo == null) return result;
            try {
                URL url;
                Project project = context.getProject();
                ProjectCaseActivity projectCaseActivity = CaseUtils.createProjectCaseActivity(project, caseActivityInfo);
                result = true;
                if (!this.openEditor || (url = CaseUtils.adaptTo(projectCaseActivity, URL.class)) == null) return result;
                CaseActivityNode node = (CaseActivityNode)NodeFactory.findOrCreate(CaseActivityNode.class, (URL)url);
                EditorUtil.openExplicitDefaultEditorInFrame((Node)node);
                return result;
            }
            catch (Throwable e) {
                String err = "CustomCaseActivityWizard, invoke Failed to create Custom Case Activity";
                LOGGER.log(Level.SEVERE, "CustomCaseActivityWizard, invoke Failed to create Custom Case Activity", e);
                MessageDialog.showError(CaseUiMsg.CREATE_CUSTOM_CASE_ACTIVITY, Msg.QUOTE("CustomCaseActivityWizard, invoke Failed to create Custom Case Activity"), e);
                throw new RuntimeException(e);
            }
        } else {
            MessageDialog.showError(CaseUiMsg.CREATE_CASE_ERROR);
        }
        return result;
    }

    private static class CustomCaseActivityPanel
    extends Panel {
        private Case casemgmt;
        private TextField classTextField;
        private TextField displayNameTextField;
        private IdentifierTextField nameTextField;

        public CustomCaseActivityPanel(UiContainer parent, Case casemgmt) {
            super(parent);
            this.casemgmt = casemgmt;
            this.init();
        }

        public CaseActivityInfo createCaseActivityInfo() {
            CaseActivity caseActivity = this.createCaseActivity();
            return CaseActivityInfo.create(caseActivity, this.displayNameTextField.getText());
        }

        private CaseActivity createCaseActivity() {
            CaseActivity result = CaseActivityFactory.createCaseActivity();
            String name = this.nameTextField.getText();
            result.setName(name);
            String targetNamespace = this.casemgmt.getTargetNamespace();
            result.setTargetNamespace(targetNamespace + "/" + name);
            Activity.Custom activity = CaseActivityFactory.createCustomActivity();
            activity.setClassName(this.classTextField.getText());
            result.setActivity((Activity)activity);
            return result;
        }

        private void init() {
            this.setLayout(new MigLayout("fillx, gapy 6, gapx 8, ins 0"));
            this.nameTextField = new IdentifierTextField((UiContainer)this, 30, true);
            this.nameTextField.setTextLimit(80);
            this.displayNameTextField = new TextField((UiContainer)this, 30);
            this.nameTextField.addDocumentListener(new DocumentListener.Default(){

                @Override
                public void anyUpdate(DocumentEvent e) {
                    CustomCaseActivityPanel.this.displayNameTextField.setText(CustomCaseActivityPanel.this.nameTextField.getText());
                }
            });
            this.classTextField = new TextField((UiContainer)this, 30);
            this.add(Label.create((UiContainer)this, CoreMsg.NAME));
            this.add(this.nameTextField, "wrap");
            this.add(Label.create((UiContainer)this, CaseUiMsg.DISPLAY_NAME));
            this.add(this.displayNameTextField, "wrap");
            this.add(Label.create((UiContainer)this, CaseUiMsg.CLASS_NAME));
            this.add(this.classTextField, "wrap");
        }
    }

    private static class CustomCaseActivityDialog
    extends JEWTDialog {
        private CustomCaseActivityPanel panel;
        private static final Image CUSTOM_IMAGE = oracle.bpm.ui.Image.create(CaseUiMsg.CUSTOM_HEADER_IMAGE40).asAwtImage();

        private CustomCaseActivityDialog(Frame parent, Project project) {
            super(parent, CaseUiMsg.CREATE_CASE_ACTIVITY.getString(), 7);
            this.init(project);
        }

        @Nullable
        public static CaseActivityInfo show(Frame parent, Project project) {
            CustomCaseActivityDialog dialog = new CustomCaseActivityDialog(parent, project);
            boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
            return ok ? dialog.createCaseActivityInfo() : null;
        }

        public CaseActivityInfo createCaseActivityInfo() {
            return this.panel.createCaseActivityInfo();
        }

        private void init(Project project) {
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(CaseUiMsg.CREATE_CUSTOM_CASE_ACTIVITY.getString());
            header.setHeaderImage(CUSTOM_IMAGE);
            this.setDialogHeader((Component)header);
            oracle.bpm.project.model.Project bpmProject = this.getBpmProject(project);
            final ProjectCase projectCase = bpmProject.getCase();
            Case casemgmt = projectCase.getCase();
            this.panel = new CustomCaseActivityPanel(UiContainer.NULL, casemgmt);
            VetoableChangeListener OkListener = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        CaseActivityInfo info = CustomCaseActivityDialog.this.createCaseActivityInfo();
                        CaseActivity caseActivity = info.getCaseActivity();
                        String name = caseActivity.getName();
                        if (Str.isEmpty(name)) {
                            MessageDialog.showError(CaseUiMsg.INVALID_FILE_NAME, CaseUiMsg.INVALID_FILE_NAME_DESCRIPTION);
                            throw new PropertyVetoException("", evt);
                        }
                        Activity.Custom custom = caseActivity.getActivity().toCustom();
                        if (Str.isEmpty(custom.getClassName().trim())) {
                            MessageDialog.showError(CaseUiMsg.INVALID_CLASS_NAME, CaseUiMsg.INVALID_CLASS_NAME_DESCRIPTION);
                            throw new PropertyVetoException("", evt);
                        }
                        ProjectCaseActivity otherCaseActivity = projectCase.findCaseActivity(name);
                        if (otherCaseActivity != null) {
                            MessageDialog.showError(CaseUiMsg.INVALID_FILE_NAME, CaseUiMsg.FILE_NAME_USED);
                            throw new PropertyVetoException("", evt);
                        }
                        if (Str.isEmpty(info.getDisplayName())) {
                            MessageDialog.showError(CaseUiMsg.INVALID_DISPLAY_NAME, CaseUiMsg.INVALID_DISPLAY_NAME_DESCRIPTION);
                            throw new PropertyVetoException("", evt);
                        }
                    }
                }
            };
            this.addVetoableChangeListener(OkListener);
            JComponent component = this.panel.asSwing();
            this.setContent(component);
            HelpSystem.getHelpSystem().registerTopic(component, "f1_bpm_casemgcreatecustcsed_html");
        }

        private oracle.bpm.project.model.Project getBpmProject(Project project) {
            return JdevRepositoryService.getInstance().getProject(project);
        }
    }
}

