/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.cm.CaseNode;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.UrlTextField;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.wizard.Wizard;
import org.jetbrains.annotations.Nullable;

public class CaseWizard
extends Wizard {
    private Case casemgmt;
    private boolean openEditor;
    private static final Icon ICON = oracle.bpm.ui.Image.create(CaseUiMsg.CASE).asSwingIcon();
    private static Logger LOGGER = Logger.getLogger(CaseWizard.class.getName());

    public CaseWizard() {
        this(true);
    }

    public CaseWizard(boolean openEditor) {
        this.openEditor = openEditor;
    }

    public boolean isAvailable(Context context) {
        Project project = context.getProject();
        return project != null && CaseUtils.getBpmProject(project) != null && !CaseUtils.existCase(project);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getShortLabel() {
        return CaseModelMsg.CASE_MANAGEMENT.getString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invoke(Context context) {
        boolean result = false;
        if (this.isAvailable(context)) {
            String defaultName = URLFileSystem.getName((URL)context.getProject().getURL());
            this.casemgmt = CaseDialog.show((Frame)Ide.getMainWindow(), defaultName);
            if (this.casemgmt == null) return result;
            try {
                URL url;
                Project project = context.getProject();
                oracle.bpm.project.model.Project bpmProject = CaseUtils.getBpmProject(project);
                CaseContainer caseContainer = bpmProject.getCaseContainer();
                if (caseContainer == null) {
                    caseContainer = bpmProject.createCaseContainer();
                    bpmProject.addChild((ProjectObject)caseContainer);
                }
                ProjectCase projectCase = caseContainer.createCase(this.casemgmt);
                caseContainer.addChild((ProjectObject)projectCase);
                result = true;
                if (!this.openEditor || (url = CaseUtils.adaptTo(projectCase, URL.class)) == null) return result;
                CaseNode caseNode = (CaseNode)NodeFactory.findOrCreate(CaseNode.class, (URL)url);
                EditorUtil.openExplicitDefaultEditorInFrame((Node)caseNode);
                return result;
            }
            catch (Throwable e) {
                String err = "CaseWizard, invoke Failed to create Case";
                LOGGER.log(Level.SEVERE, err, e);
                MessageDialog.showError(CaseUiMsg.CREATE_CASE_MANAGEMENT, Msg.QUOTE(err), e);
                throw new RuntimeException(e);
            }
        } else {
            MessageDialog.showError(CaseUiMsg.CREATE_CASE_ERROR);
        }
        return result;
    }

    public Case getCase() {
        return this.casemgmt;
    }

    private static class CasePanel
    extends Panel {
        private UrlTextField namespaceTextField;
        private IdentifierTextField nameTextField;
        private static final String NAMESPACE = "http://xmlns.oracle.com/";

        public CasePanel(UiContainer parent, String defaultName) {
            super(parent);
            this.init(defaultName);
        }

        public Case getCase() {
            Case result = CaseFactory.createCase((String)this.nameTextField.getText());
            result.setTargetNamespace(this.namespaceTextField.getText());
            return result;
        }

        private void init(String defaultName) {
            this.setLayout(new MigLayout("fillx, gapx 8, gapy 6, ins 0"));
            this.nameTextField = new IdentifierTextField((UiContainer)this, 30, true);
            this.nameTextField.setTextLimit(80);
            this.namespaceTextField = new UrlTextField((UiContainer)this, 30);
            this.nameTextField.addDocumentListener(new DocumentListener.Default(){

                @Override
                public void anyUpdate(DocumentEvent e) {
                    CasePanel.this.namespaceTextField.setText(CasePanel.NAMESPACE + CasePanel.this.nameTextField.getText());
                }
            });
            this.add(Label.create((UiContainer)this, CoreMsg.NAME));
            this.add(this.nameTextField, "wrap");
            this.add(Label.create((UiContainer)this, CaseUiMsg.NAMESPACE));
            this.add(this.namespaceTextField, "wrap");
            this.nameTextField.setText(defaultName);
        }
    }

    private static class CaseDialog
    extends JEWTDialog {
        private CasePanel casePanel;
        private static final Image CASE_IMAGE = oracle.bpm.ui.Image.create(CaseUiMsg.CASE_HEADER_DESCRIPTION).asAwtImage();

        private CaseDialog(Frame parent, String defaultName) {
            super(parent, CaseUiMsg.CREATE_CASE_MANAGEMENT.getString(), 7);
            this.init(defaultName);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContent(), "f1_bpm_casemgcreatecased_html");
        }

        @Nullable
        public static Case show(Frame parent, String defaultName) {
            CaseDialog dialog = new CaseDialog(parent, defaultName);
            boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
            return ok ? dialog.getCase() : null;
        }

        public Case getCase() {
            return this.casePanel.getCase();
        }

        private void init(String defaultName) {
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(CaseUiMsg.CREATE_CASE_MANAGEMENT.getString());
            header.setHeaderImage(CASE_IMAGE);
            this.setDialogHeader((Component)header);
            this.casePanel = new CasePanel(UiContainer.NULL, defaultName);
            VetoableChangeListener OkListener = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        boolean ok;
                        boolean bl = ok = !CaseDialog.this.casePanel.getCase().getName().trim().isEmpty();
                        if (!ok) {
                            MessageDialog.showError(CaseUiMsg.INVALID_FILE_NAME, CaseUiMsg.INVALID_FILE_NAME_DESCRIPTION);
                            throw new PropertyVetoException("", evt);
                        }
                    }
                }
            };
            this.addVetoableChangeListener(OkListener);
            this.setContent(this.casePanel.asSwing());
        }
    }
}

