/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm;

import java.io.IOException;
import javax.swing.Icon;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.AbstractEntityNode;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.Image;

public class CaseNode
extends AbstractEntityNode<Case> {
    private ProjectCase projectCase;
    public static final Icon ICON = Image.create(CaseUiMsg.CASE).asSwingIcon();

    public Icon getIcon() {
        return ICON;
    }

    @Override
    protected void saveEntityModel() throws IOException {
        try {
            if (this.projectCase != null) {
                this.getBpmProject().getWriter().write(new ProjectObject[]{this.projectCase});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            String error = message != null ? "\n\n" + message : "";
            throw new IOException("Exception saving Case " + this.getLongLabel() + "\n" + error, e);
        }
    }

    @Override
    protected void revertEntityModel() {
        ProjectLoader loader = this.getBpmProject().getLoader();
        if (loader != null) {
            try {
                ProjectObject newProjectCase = loader.replaceProjectObject((ProjectObject)this.projectCase);
                this.projectCase = (ProjectCase)newProjectCase;
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Case loadEntityModel() throws IOException {
        Case result = null;
        try {
            this.projectCase = this.getBpmProject().getCase();
            if (this.projectCase != null) {
                result = this.projectCase.getCase();
            }
        }
        catch (Exception e) {
            throw new IOException("Exception loading " + this.getLongLabel(), e);
        }
        return result;
    }
}

