/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.form;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.controller.adfc.source.gallery.TaskFlowWizard;
import oracle.adfdt.controller.adfc.source.navigator.AdfcConfigNode;
import oracle.adfdt.controller.adfc.source.taskflow.TaskFlow;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorResult;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.common.binding.standalone.WidgetFactory;
import oracle.adfdt.view.rich.ADFFacesDTUtils;
import oracle.adfdt.view.rich.binding.util.ADFDatabindingUtils;
import oracle.adfdtinternal.view.rich.binding.addin.FacesDesignTimeContext;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.bpm.casemgmt.ui.ca.form.CaseTaskFlow;
import oracle.bpm.casemgmt.ui.common.form.CaseFormProject;
import oracle.bpm.casemgmt.ui.common.form.CaseTaskFlowXmlHelper;
import oracle.bpm.casemgmt.ui.common.form.DataControlUiObj;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.bpm.casemgmt.ui.common.form.ProgressDialog;
import oracle.bpm.casemgmt.ui.common.form.SelectProjectDialog;
import oracle.bpm.casemgmt.ui.common.form.WebXmlHelper;
import oracle.bpm.casemgmt.ui.common.form.WeblogicApplicationXmlHelper;
import oracle.bpm.casemgmt.ui.common.form.WeblogicXmlHelper;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.casemgmt.util.CaseActivityMultipleInputWrapper;
import oracle.bpm.datacontrol.util.PayloadObjGenerator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.ear.EarProfile;
import oracle.jdeveloper.deploy.war.WarProfile;
import oracle.jdeveloper.jsp.faces.JsfJspSourceNodeFactory;
import oracle.jdeveloper.jsp.libraries.JspLibrary;
import oracle.jdeveloper.jsp.utils.JSPTagUtils;
import oracle.jdeveloper.model.JspSourceNode;
import oracle.jdevimpl.webapp.jsp.libraries.model.ProjectTagLibraries;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class FormGenerator
implements ActionListener {
    private CaseFormProject cfProject;
    private List<CaseFormProject> cfProjList;
    private String dataControlName;
    private FormGenContext formGenCtx;
    private JMenuItem newProjMenuItem;
    private JMenuItem openTaskFlowMenuItem;
    private JPopupMenu popupMenu;
    private ProgressDialog progressDialog;
    private JMenuItem regenDCMenuItem;
    private JMenuItem selectProjMenuItem;
    private String taskFlowRelativePath;
    private Thread thread;
    private static final int CREATE_DATA_CONTROL_STEP = 0;
    private static final int CREATE_TASK_FLOW_STEP = 1;
    private static final int CREATE_FORM_STEP = 2;
    private static final int CONFIGURATION_STEP = 3;
    private static final String JSTL_CORE = "http://java.sun.com/jsp/jstl/core";
    private static final String TRINIDAD_HTML = "http://myfaces.apache.org/trinidad/html";
    private static final String ACTIVITY = "activity";
    private static final String ACTIVITY_INPUTS = "ActivityInputs";

    public FormGenerator(FormGenContext formGenCtx) {
        this.formGenCtx = formGenCtx;
        this.popupMenu = new JPopupMenu();
        this.newProjMenuItem = new JMenuItem(CaseUiMsg.CASE_FORM_NEW_PROJECT.getString());
        this.regenDCMenuItem = new JMenuItem(CaseUiMsg.CASE_FORM_REGENERATE_DATA_CONTROL.getString());
        this.selectProjMenuItem = new JMenuItem(CaseUiMsg.CASE_FORM_SELECT_EXISTING_PROJECT.getString());
        this.openTaskFlowMenuItem = new JMenuItem(CaseUiMsg.CASE_FORM_OPEN_TASK_FLOW.getString());
        Context jdevContext = Context.newIdeContext();
        formGenCtx.setJdevContext(jdevContext);
        this.addListeners();
    }

    public void handleActivityFormButton(JComponent formButton) {
        if (!this.formGenCtx.caseActivityHasUserInputType()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), CaseUiMsg.CA_FORM_NO_USER_INPUT.getString(), CaseUiMsg.CASE_FORM_ERROR_TITLE.getString(), 0);
            return;
        }
        this.dataControlName = null;
        this.taskFlowRelativePath = null;
        this.cfProjList = this.getCaseFormProjects();
        if (this.cfProjList == null || this.cfProjList.size() < 1) {
            this.popupMenu.add(this.newProjMenuItem);
        } else {
            String pattern = this.formGenCtx.getCaseName() + "_" + this.formGenCtx.getCaseActivityName() + "_" + ACTIVITY;
            this.dataControlName = this.getDataControlName(this.cfProjList, pattern);
            String projectName = this.getProjectName(this.dataControlName, pattern);
            this.cfProject = this.getProject(this.cfProjList, projectName);
            if (this.dataControlName != null) {
                this.popupMenu.add(this.regenDCMenuItem);
                String tfFileName = this.formGenCtx.getTaskFlowFileName();
                this.taskFlowRelativePath = this.getTaskFlowPath(tfFileName);
                if (this.taskFlowRelativePath != null) {
                    this.popupMenu.add(this.openTaskFlowMenuItem);
                }
            } else {
                this.popupMenu.add(this.newProjMenuItem);
                this.popupMenu.add(this.selectProjMenuItem);
            }
        }
        this.popupMenu.show(formButton, formButton.getWidth(), 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newProjMenuItem) {
            this.generateInNewProject();
        } else if (actionEvent.getSource() == this.selectProjMenuItem) {
            this.generateInExistingProject();
        } else if (actionEvent.getSource() == this.regenDCMenuItem) {
            if (this.dataControlName != null && this.cfProject != null) {
                this.regenerateDataControl(this.cfProject.getAdfProject(), this.dataControlName);
            }
        } else if (actionEvent.getSource() == this.openTaskFlowMenuItem) {
            this.openTaskFlowEditor();
        }
    }

    public org.w3c.dom.Node getNode(String name, org.w3c.dom.Node curNode) {
        org.w3c.dom.Node formNode;
        for (formNode = curNode; formNode != null && formNode.getNodeName().indexOf(name) == -1; formNode = formNode.getParentNode()) {
        }
        return formNode;
    }

    private void addListeners() {
        this.newProjMenuItem.addActionListener(this);
        this.selectProjMenuItem.addActionListener(this);
        this.regenDCMenuItem.addActionListener(this);
        this.openTaskFlowMenuItem.addActionListener(this);
    }

    private void removeListeners() {
        this.newProjMenuItem.removeActionListener(this);
        this.selectProjMenuItem.removeActionListener(this);
        this.regenDCMenuItem.removeActionListener(this);
        this.openTaskFlowMenuItem.removeActionListener(this);
    }

    private String getTaskFlowPath(String tfFileName) {
        if (this.cfProjList == null) {
            return null;
        }
        for (int i = 0; i < this.cfProjList.size(); ++i) {
            CaseFormProject cfProj = this.cfProjList.get(i);
            String tfRelPath = cfProj.getTaskFlowPath(tfFileName);
            if (tfRelPath == null) continue;
            return tfRelPath;
        }
        return null;
    }

    private void generateInNewProject() {
        this.createNewAdfProject();
        if (this.formGenCtx == null || this.formGenCtx.getAdfProject() == null) {
            return;
        }
        this.generateAll();
    }

    private void generateInExistingProject() {
        SelectProjectDialog selProjDialog = new SelectProjectDialog((Frame)Ide.getMainWindow(), this.cfProjList);
        if (selProjDialog.runDialog()) {
            CaseFormProject afProj = selProjDialog.getSelectedProject();
            if (afProj == null) {
                return;
            }
            Project adfProj = afProj.getAdfProject();
            this.formGenCtx.setAdfProject(adfProj);
            Context jdevCtx = this.formGenCtx.getJdevContext();
            jdevCtx.setProject(adfProj);
            Ide.setActiveProject((Project)adfProj);
            this.generateAll();
        }
    }

    private void regenerateDataControl(final Project project, final String dataControlName) {
        if (project == null || dataControlName == null) {
            return;
        }
        ArrayList<String> stepList = new ArrayList<String>();
        stepList.add(CaseUiMsg.CASE_FORM_REGENERATING_DATA_CONTROL.getString());
        this.progressDialog = new ProgressDialog((Frame)Ide.getMainWindow(), stepList);
        this.progressDialog.getCancelButton().addActionListener(new ProgressCancelActionListener());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FormGenerator.this.progressDialog.pack();
                            FormGenerator.this.progressDialog.setVisible(true);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FormGenerator.this.progressDialog.highlightStep(0);
                        }
                    });
                    Context jdevCtx = FormGenerator.this.formGenCtx.getJdevContext();
                    jdevCtx.setProject(project);
                    FormGenerator.this.formGenCtx.setAdfProject(project);
                    FormGenerator.this.createWrapperSchema();
                    FormGenerator.this.createDataControl(dataControlName);
                    FormGenerator.this.deleteWrapperSchema();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FormGenerator.this.progressDialog.dispose();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (FormGenerator.this.progressDialog != null) {
                                FormGenerator.this.progressDialog.dispose();
                            }
                            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)CaseUiMsg.CASE_FORM_REGENERATE_DATA_CONTROL_ERROR.getString());
                        }
                    });
                }
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void configure() throws Exception {
        String[] msgVals;
        String msg;
        String relTaskFlowPath = this.formGenCtx.getRelativeTaskFlowPath();
        this.updatePropertiesFile(this.formGenCtx.getCaseName(), this.dataControlName, relTaskFlowPath);
        this.addTagLibraries(this.formGenCtx.getAdfProject());
        EarProfile earProfile = this.createEarDeploymentProfile();
        WarProfile warProfile = this.createWarDeploymentProfile();
        if (earProfile != null && warProfile != null) {
            earProfile.addDependency((Profile)warProfile);
        }
        try {
            WeblogicApplicationXmlHelper wlAppXmlHelper = new WeblogicApplicationXmlHelper(this.formGenCtx.getWorkspace());
            if (wlAppXmlHelper.update()) {
                msg = CaseUiMsg.CASE_FORM_WEBLOGIC_APP_XML_UPDATE.getString();
                LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String[] msgVals2 = new String[]{e.getLocalizedMessage()};
            String errMsg = CaseUiMsg.CASE_FORM_WEBLOGIC_APP_XML_UPDATE_ERROR.getString();
            MessageFormat msgFormat = new MessageFormat(errMsg);
            errMsg = msgFormat.format(msgVals2);
            LogManager.getLogManager().getMsgPage().log((Object)(errMsg + "\n"));
            throw e;
        }
        try {
            WeblogicXmlHelper wlXmlHelper = new WeblogicXmlHelper(this.formGenCtx.getAdfProject());
            if (wlXmlHelper.update()) {
                msg = CaseUiMsg.CASE_FORM_WEBLOGIC_XML_UPDATE.getString();
                LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msgVals = new String[]{e.getLocalizedMessage()};
            String errMsg = CaseUiMsg.CASE_FORM_WEBLOGIC_XML_UPDATE_ERROR.getString();
            MessageFormat msgFormat = new MessageFormat(errMsg);
            errMsg = msgFormat.format(msgVals);
            LogManager.getLogManager().getMsgPage().log((Object)(errMsg + "\n"));
            throw e;
        }
        try {
            WebXmlHelper webXmlHelper = new WebXmlHelper(this.formGenCtx.getAdfProject());
            if (webXmlHelper.update()) {
                msg = CaseUiMsg.CASE_FORM_WEB_XML_UPDATE.getString();
                LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msgVals = new String[]{e.getLocalizedMessage()};
            String errMsg = CaseUiMsg.CASE_FORM_WEB_XML_UPDATE_ERROR.getString();
            MessageFormat msgFormat = new MessageFormat(errMsg);
            errMsg = msgFormat.format(msgVals);
            LogManager.getLogManager().getMsgPage().log((Object)(errMsg + "\n"));
            throw e;
        }
        try {
            CaseTaskFlowXmlHelper ctfXmlHelper = new CaseTaskFlowXmlHelper();
            ctfXmlHelper.createCaseFlowXml(this.formGenCtx);
            msg = CaseUiMsg.CASE_FORM_CASE_TASK_FLOW_XML_UPDATE.getString();
            LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
        }
        catch (Exception e) {
            e.printStackTrace();
            msgVals = new String[]{e.getLocalizedMessage()};
            String errMsg = CaseUiMsg.CASE_FORM_CASE_TASK_FLOW_XML_UPDATE_ERROR.getString();
            MessageFormat msgFormat = new MessageFormat(errMsg);
            errMsg = msgFormat.format(msgVals);
            LogManager.getLogManager().getMsgPage().log((Object)(errMsg + "\n"));
            throw e;
        }
    }

    private void createNewAdfProject() {
        try {
            NewEmptyProjectCommand command = new NewEmptyProjectCommand();
            Context jdevCtx = Context.newIdeContext((Node)this.formGenCtx.getBpmProject());
            command.setContext(jdevCtx);
            if (0 == command.doit()) {
                Project adfProject = command.getContext().getProject();
                jdevCtx.setProject(adfProject);
                this.formGenCtx.setJdevContext(jdevCtx);
                this.formGenCtx.setAdfProject(adfProject);
                TechnologyScopeConfiguration techScopeConfig = TechnologyScopeConfiguration.getInstance((PropertyStorage)adfProject);
                TechnologyScope techScope = techScopeConfig.getTechnologyScope();
                techScope.setTechnologyKeys(new String[]{"ADF_FACES"});
                techScopeConfig.setTechnologyScope(techScope);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMsg = CaseUiMsg.CASE_FORM_PROJECT_CREATE_ERROR.getString();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)errorMsg);
        }
    }

    private List<CaseFormProject> getCaseFormProjects() {
        ArrayList<CaseFormProject> cfProjList = new ArrayList<CaseFormProject>();
        Workspace ws = this.formGenCtx.getJdevContext().getWorkspace();
        Collection projects = ws.projects();
        for (Project proj : projects) {
            if (!this.isCaseFormProject(proj)) continue;
            CaseFormProject cfProj = new CaseFormProject(proj, this.formGenCtx.getCaseName());
            cfProjList.add(cfProj);
        }
        return cfProjList;
    }

    private boolean isCaseFormProject(Project project) {
        if (project == null) {
            return false;
        }
        String caseFormPropFilePath = project.getBaseDirectory() + File.separator + "case_form.properties";
        File caseFormPropFile = new File(caseFormPropFilePath);
        return caseFormPropFile.exists();
    }

    private void createWrapperSchema() throws Exception {
        String caFileLoc = this.formGenCtx.getCaseActivityUrl().getPath();
        String projDir = this.formGenCtx.getBpmProject().getBaseDirectory();
        CaseActivityMultipleInputWrapper camiw = new CaseActivityMultipleInputWrapper();
        Map map = camiw.generateSchemaForCaseActivityInputs(caFileLoc, projDir);
        Set keySet = map.keySet();
        Object[] keyArray = keySet.toArray();
        String serviceName = (String)keyArray[0];
        String wrapperSchemaUrl = (String)map.get(serviceName);
        this.formGenCtx.setCaseActivityServiceName(serviceName);
        this.formGenCtx.setWrapperSchema(wrapperSchemaUrl);
    }

    private String getDataControlName(List<CaseFormProject> cfProjList, String pattern) {
        if (pattern == null) {
            return null;
        }
        if (cfProjList == null || cfProjList.size() < 1) {
            return null;
        }
        for (int i = 0; i < cfProjList.size(); ++i) {
            CaseFormProject cfProj = cfProjList.get(i);
            List<DataControlUiObj> dcNameList = cfProj.getDataControlList();
            for (int j = 0; j < dcNameList.size(); ++j) {
                DataControlUiObj dc = dcNameList.get(j);
                String dcName = dc.getDataControlName();
                if (!dcName.endsWith(pattern)) continue;
                return dcName;
            }
        }
        return null;
    }

    private String getProjectName(String dataControlName, String pattern) {
        if (dataControlName == null || pattern == null) {
            return null;
        }
        int index = dataControlName.indexOf(pattern);
        if (index > 0) {
            return dataControlName.substring(0, index - 1);
        }
        return null;
    }

    private CaseFormProject getProject(List<CaseFormProject> cfProjList, String projectName) {
        if (projectName == null) {
            return null;
        }
        if (cfProjList == null || cfProjList.size() < 1) {
            return null;
        }
        for (int i = 0; i < cfProjList.size(); ++i) {
            CaseFormProject cfProj = cfProjList.get(i);
            if (!projectName.equals(cfProj.getName())) continue;
            return cfProj;
        }
        return null;
    }

    private void generateAll() {
        FormGenContext.IS_CASE_ACTIVITY_EDITOR = true;
        ArrayList<String> stepList = new ArrayList<String>();
        stepList.add(CaseUiMsg.CASE_FORM_CREATING_DATA_CONTROL.getString());
        stepList.add(CaseUiMsg.CASE_FORM_CREATING_TASK_FLOW.getString());
        stepList.add(CaseUiMsg.CASE_FORM_CREATING_FORM.getString());
        stepList.add(CaseUiMsg.CASE_FORM_CONFIGURATION.getString());
        this.progressDialog = new ProgressDialog((Frame)Ide.getMainWindow(), stepList);
        this.progressDialog.getCancelButton().addActionListener(new ProgressCancelActionListener());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormGenerator.this.progressDialog.pack();
                        FormGenerator.this.progressDialog.setVisible(true);
                    }
                });
                CreateDataControlProcess cdcp = new CreateDataControlProcess(FormGenerator.this.progressDialog, FormGenerator.this.thread);
                Thread cdcpThread = new Thread((Runnable)cdcp, "CreateDataControlProcess");
                cdcpThread.start();
            }
        };
        this.thread = new Thread(runnable, "FormGenRootProcess");
        this.thread.start();
    }

    private String generateDataControlName() {
        String adfProjName = FormGenHelper.getProjectName(this.formGenCtx.getAdfProject());
        String dataControlName = adfProjName + "_" + this.formGenCtx.getCaseName() + "_" + this.formGenCtx.getCaseActivityName() + "_" + ACTIVITY;
        return dataControlName;
    }

    private void createDataControl(String dataControlName) throws Exception {
        FormGenHelper.addLibraries(this.formGenCtx.getAdfProject());
        Ide.setActiveProject((Project)this.formGenCtx.getAdfProject());
        String tns = this.getTargetNamespace(this.formGenCtx.getWrapperSchemaUrl());
        PayloadObjGenerator dcGenerator = new PayloadObjGenerator(this.formGenCtx.getWrapperSchemaUrl(), this.formGenCtx.getJdevContext(), dataControlName, ACTIVITY_INPUTS, ACTIVITY_INPUTS, tns, "case", "Activity", this.formGenCtx.getCaseActivityServiceName());
        DataControl dc = dcGenerator.generateDataControl();
        this.formGenCtx.setDataControl(dc);
    }

    private String getTargetNamespace(URL schemaUrl) throws Exception {
        if (schemaUrl == null) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(schemaUrl.toURI()));
        NodeList nList = doc.getElementsByTagName("schema");
        org.w3c.dom.Node schemaNode = nList.item(0);
        NamedNodeMap attrMap = schemaNode.getAttributes();
        org.w3c.dom.Node tnsNode = attrMap.getNamedItem("targetNamespace");
        String tns = tnsNode.getNodeValue();
        return tns;
    }

    private void updatePropertiesFile(String caseName, String dataControlName, String relTaskFlowPath) throws Exception {
        String dcPropVal = null;
        String tfPropVal = null;
        String dcVal = dataControlName + ":" + caseName;
        String tfVal = relTaskFlowPath;
        Project proj = this.formGenCtx.getAdfProject();
        String propFilePath = this.getPropertiesFilePath(proj);
        Properties prop = new Properties();
        File propFile = new File(propFilePath);
        if (propFile.exists()) {
            prop.load(new FileInputStream(propFilePath));
            dcPropVal = prop.getProperty("dc_names");
            tfPropVal = prop.getProperty("tf_paths");
        }
        dcPropVal = dcPropVal == null || dcPropVal.trim().equals("") ? dcVal : dcPropVal + ";" + dcVal;
        prop.setProperty("dc_names", dcPropVal);
        tfPropVal = tfPropVal == null || tfPropVal.trim().equals("") ? tfVal : tfPropVal + ";" + tfVal;
        prop.setProperty("tf_paths", tfPropVal);
        prop.store(new FileOutputStream(propFilePath), null);
    }

    private String getPropertiesFilePath(Project project) {
        if (project == null) {
            return null;
        }
        return project.getBaseDirectory() + File.separator + "case_form.properties";
    }

    private void handleProcessError(final Exception e, final ProgressDialog progressDialog) {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (e == null) {
            return;
        }
        if (progressDialog == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String stepText = progressDialog.getHighlightedStepText();
                progressDialog.dispose();
                FormGenerator.this.formGenCtx;
                FormGenContext.IS_CASE_ACTIVITY_EDITOR = false;
                if (stepText == null || stepText.trim().equals("")) {
                    String errorMsg = CaseUiMsg.CASE_FORM_ERROR.getString();
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)errorMsg);
                } else {
                    String[] args = new String[]{stepText};
                    String errorMsg = CaseUiMsg.CASE_FORM_STEP_ERROR.getString();
                    MessageFormat msgFormat = new MessageFormat(errorMsg);
                    errorMsg = msgFormat.format(args);
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)errorMsg);
                }
            }
        });
    }

    private void createTaskFlow() throws Exception {
        String tfName = this.formGenCtx.getTaskFlowName();
        URL taskFlowUrl = this.formGenCtx.getTaskFlowNameUrl();
        if (taskFlowUrl == null) {
            return;
        }
        TaskFlowWizard tfWiz = new TaskFlowWizard(taskFlowUrl, true, tfName, false, false);
        tfWiz.invokeSilently(this.formGenCtx.getJdevContext());
        Context ctx = this.formGenCtx.getJdevContext();
        ctx.setProject(this.formGenCtx.getAdfProject());
        AdfcConfigNode targetNode = (AdfcConfigNode)ctx.getProperty("new-adfc-config-node");
        Context targetContext = new Context(ctx);
        targetContext.setNode((Node)targetNode);
        JDevXmlContext xmlContext = targetNode.getXmlContext(ctx.getProject());
        XmlView xmlModel = xmlContext.getView(XmlUsage.XML_CODE_EDITOR);
        CaseTaskFlow ctf = new CaseTaskFlow((AbstractModel)xmlModel, (XmlContext)xmlContext, this.formGenCtx);
        ctf.run();
        TaskFlow taskFlow = ctf.getTaskFlow();
    }

    private void createForm() {
        URL jspUrl = this.formGenCtx.getFormUrl();
        Context jdevCtx = this.formGenCtx.getJdevContext();
        JspSourceNode node = JsfJspSourceNodeFactory.createJsfJspSourceNode((Context)jdevCtx, (URL)jspUrl, (boolean)true);
        XMLSourceNode xmlSourceNode = (XMLSourceNode)ModelUtil.as((Object)ADFFacesDTUtils.reallyFindNode((URL)jspUrl), XMLSourceNode.class);
        JDevXmlContext xmlContext = null;
        if (xmlSourceNode != null) {
            this.formGenCtx.getJdevContext().setNode((Node)xmlSourceNode);
            xmlContext = JDevXmlContext.getXmlContext((Context)this.formGenCtx.getJdevContext());
            FacesDesignTimeContext dtContext = ADFDatabindingUtils.createFacesDesignTimeContext((XmlContext)xmlContext);
            XmlModel xmlModel = xmlContext.getRelatedXmlModel(jspUrl);
            boolean jspcreationSuccess = new FixedNameTransactionTask("AutoGenerateJSP", (JDevDesignTimeContext)dtContext){
                final /* synthetic */ JDevDesignTimeContext val$dtContext;
                {
                    this.val$dtContext = jDevDesignTimeContext;
                    super(x0);
                }

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    Widget caseWidget = null;
                    DataControlDefinition nd = FormGenerator.this.formGenCtx.getDataControl().getDataControlDefinition();
                    WidgetFactory.WidgetFactoryContext widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.val$dtContext, (DataControl)FormGenerator.this.formGenCtx.getDataControl(), (NamedDefinition)nd);
                    Map widgets = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryCtx);
                    caseWidget = (Widget)widgets.get("case_activity_form_payload");
                    if (caseWidget != null) {
                        org.w3c.dom.Node insertionSubtreeRoot = model.getDocument().getDocumentElement().getElementsByTagName("form").item(0);
                        CreatorParams creatorParams = caseWidget.createBaseCreatorParams(insertionSubtreeRoot);
                        CreatorResult creatorResult = caseWidget.create(creatorParams);
                        DocumentFragment taskAllFragment = creatorResult.getFragment();
                        org.w3c.dom.Node formNode = FormGenerator.this.getNode("form", insertionSubtreeRoot);
                        formNode.appendChild(taskAllFragment);
                    }
                }
            }.run((AbstractModel)xmlModel);
        }
        this.openFormEditor();
    }

    private void openTaskFlowEditor() {
        if (this.taskFlowRelativePath == null) {
            return;
        }
        URL tfUrl = this.formGenCtx.getTaskFlowAbsolutePath(this.taskFlowRelativePath);
        XMLSourceNode xmlSourceNode = (XMLSourceNode)ModelUtil.as((Object)ADFFacesDTUtils.reallyFindNode((URL)tfUrl), XMLSourceNode.class);
        if (xmlSourceNode != null) {
            Project adfTaskFlowProj = FormGenHelper.getProject(this.formGenCtx.getWorkspace(), xmlSourceNode);
            if (adfTaskFlowProj == null) {
                return;
            }
            Context context = new Context(this.formGenCtx.getWorkspace(), adfTaskFlowProj);
            context.setNode((Node)xmlSourceNode);
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.openDefaultEditorInFrame(context);
        }
    }

    private void openFormEditor() {
        if (this.formGenCtx == null || this.formGenCtx.getFormUrl() == null) {
            return;
        }
        EditorManager editorMgr = EditorManager.getEditorManager();
        editorMgr.openDefaultEditorInFrame(this.formGenCtx.getFormUrl());
    }

    private void addTagLibraries(Project project) {
        if (project == null) {
            return;
        }
        ProjectTagLibraries ptl = ProjectTagLibraries.getInstance((Project)project);
        JspLibrary jstlCoreLib = JSPTagUtils.getJspLibraryByURI((String)JSTL_CORE);
        JSPTagUtils.updateProjectWithTagLibrary((JspLibrary)jstlCoreLib, (Project)project);
        ptl.addLibrary(jstlCoreLib, project);
        JspLibrary trinidadHtmlLib = JSPTagUtils.getJspLibraryByURI((String)TRINIDAD_HTML);
        JSPTagUtils.updateProjectWithTagLibrary((JspLibrary)trinidadHtmlLib, (Project)project);
        ptl.addLibrary(trinidadHtmlLib, project);
    }

    private EarProfile createEarDeploymentProfile() {
        Workspace workspace = this.formGenCtx.getWorkspace();
        if (workspace == null) {
            return null;
        }
        Project adfProj = this.formGenCtx.getAdfProject();
        if (adfProj == null) {
            return null;
        }
        String profileName = FormGenHelper.getProjectName(adfProj);
        DeploymentProfiles appProfiles = DeploymentProfiles.getInstance((DataContainer)workspace);
        EarProfile earProfile = null;
        Profile appProfile = appProfiles.getProfileByName(profileName);
        if (appProfile != null && appProfile instanceof EarProfile) {
            earProfile = (EarProfile)appProfile;
        } else {
            earProfile = (EarProfile)Deployment.createDeploymentProfile((DataContainer)workspace, (String)profileName, EarProfile.class);
            earProfile.setEnterpriseAppName(profileName);
            try {
                appProfiles.addProfile((Profile)earProfile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return earProfile;
    }

    private WarProfile createWarDeploymentProfile() {
        String projectName;
        Project adfProj = this.formGenCtx.getAdfProject();
        if (adfProj == null) {
            return null;
        }
        String profileName = projectName = FormGenHelper.getProjectName(adfProj);
        WarProfile warProfile = null;
        DeploymentProfiles projectProfiles = DeploymentProfiles.getInstance((DataContainer)adfProj);
        Profile projectProfile = projectProfiles.getProfileByName(profileName);
        if (projectProfile != null && projectProfile instanceof WarProfile) {
            warProfile = (WarProfile)projectProfile;
        } else {
            warProfile = (WarProfile)Deployment.createDeploymentProfile((DataContainer)adfProj, (String)profileName, WarProfile.class);
            warProfile.setContextRoot("/case/" + projectName + "/" + this.formGenCtx.getCaseName());
            try {
                projectProfiles.addProfile((Profile)warProfile);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return warProfile;
    }

    private void deleteWrapperSchema() {
        if (this.formGenCtx == null) {
            return;
        }
        if (this.formGenCtx.getWrapperSchemaUrl() == null) {
            return;
        }
        try {
            File wrapperSchemaFile = new File(this.formGenCtx.getWrapperSchemaUrl().toURI());
            wrapperSchemaFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ProgressCancelActionListener
    implements ActionListener {
        private ProgressCancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FormGenerator.this.progressDialog.getCancelButton() && FormGenerator.this.thread != null) {
                FormGenerator.this.thread.interrupt();
            }
        }
    }

    private class CreateTaskFlowProcess
    implements Runnable {
        private Thread parentThread;
        private ProgressDialog progressDialog;
        private Thread thread;

        public CreateTaskFlowProcess(ProgressDialog progressDialog, Thread parentThread) {
            this.progressDialog = progressDialog;
            this.parentThread = parentThread;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateTaskFlowProcess.this.progressDialog.highlightStep(1);
                }
            });
            try {
                FormGenerator.this.createTaskFlow();
                CreateFormProcess cfp = new CreateFormProcess(this.progressDialog, this.parentThread);
                this.thread = new Thread((Runnable)cfp, "CreateFormProcess");
                this.thread.start();
            }
            catch (Exception e) {
                if (this.parentThread != null) {
                    this.parentThread.interrupt();
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                e.printStackTrace();
                FormGenerator.this.handleProcessError(e, this.progressDialog);
            }
        }
    }

    private class CreateFormProcess
    implements Runnable {
        private Thread parentThread;
        private ProgressDialog progressDialog;
        private Thread thread;

        public CreateFormProcess(ProgressDialog progressDialog, Thread parentThread) {
            this.progressDialog = progressDialog;
            this.parentThread = parentThread;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateFormProcess.this.progressDialog.highlightStep(2);
                    FormGenerator.this.createForm();
                }
            });
            ConfigureProcess cp = new ConfigureProcess(this.progressDialog, this.parentThread);
            this.thread = new Thread((Runnable)cp, "ConfigureProcess");
            this.thread.start();
        }
    }

    private class CreateDataControlProcess
    implements Runnable {
        private Thread parentThread;
        private ProgressDialog progressDialog;
        private Thread thread;

        public CreateDataControlProcess(ProgressDialog progressDialog, Thread parentThread) {
            this.progressDialog = progressDialog;
            this.parentThread = parentThread;
        }

        @Override
        public void run() {
            if (this.progressDialog == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateDataControlProcess.this.progressDialog.highlightStep(0);
                }
            });
            try {
                FormGenerator.this.createWrapperSchema();
                FormGenerator.this.dataControlName = FormGenerator.this.generateDataControlName();
                FormGenerator.this.createDataControl(FormGenerator.this.dataControlName);
                FormGenerator.this.deleteWrapperSchema();
                CreateTaskFlowProcess ctfp = new CreateTaskFlowProcess(this.progressDialog, this.parentThread);
                Thread thread = new Thread((Runnable)ctfp, "CreateTaskFlowProcess");
                thread.start();
            }
            catch (Exception e) {
                if (this.parentThread != null) {
                    this.parentThread.interrupt();
                }
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                e.printStackTrace();
                FormGenerator.this.handleProcessError(e, this.progressDialog);
            }
        }
    }

    private class ConfigureProcess
    implements Runnable {
        private Thread parentThread;
        private ProgressDialog progressDialog;

        public ConfigureProcess(ProgressDialog progressDialog, Thread parentThread) {
            this.progressDialog = progressDialog;
            this.parentThread = parentThread;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigureProcess.this.progressDialog.highlightStep(3);
                    try {
                        FormGenerator.this.configure();
                    }
                    catch (Exception e) {
                        if (ConfigureProcess.this.parentThread != null) {
                            ConfigureProcess.this.parentThread.interrupt();
                        }
                        e.printStackTrace();
                        FormGenerator.this.handleProcessError(e, ConfigureProcess.this.progressDialog);
                    }
                    ConfigureProcess.this.progressDialog.dispose();
                    FormGenerator.this.formGenCtx;
                    FormGenContext.IS_CASE_ACTIVITY_EDITOR = false;
                }
            });
        }
    }
}

