/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.form;

import java.net.URL;
import java.util.List;
import oracle.adfdt.controller.adfc.source.activity.Activity;
import oracle.adfdt.controller.adfc.source.activity.ActivityType;
import oracle.adfdt.controller.adfc.source.controlflow.ControlFlowCase;
import oracle.adfdt.controller.adfc.source.controlflow.ControlFlowRule;
import oracle.adfdt.controller.adfc.source.controlflow.FromOutcome;
import oracle.adfdt.controller.adfc.source.controlflow.XxxActivityId;
import oracle.adfdt.controller.adfc.source.facade.InsertManagedBeanTask;
import oracle.adfdt.controller.adfc.source.facade.InsertParameterTask;
import oracle.adfdt.controller.adfc.source.managedbean.ManagedBean;
import oracle.adfdt.controller.adfc.source.model.SimpleEntity;
import oracle.adfdt.controller.adfc.source.model.ValueEntity;
import oracle.adfdt.controller.adfc.source.single.AdfcSingleViewUtils;
import oracle.adfdt.controller.adfc.source.taskflow.BoundedTaskFlow;
import oracle.adfdt.controller.adfc.source.taskflow.DataControlScope;
import oracle.adfdt.controller.adfc.source.taskflow.TaskFlow;
import oracle.adfdt.controller.adfc.source.taskflow.Visibility;
import oracle.adfdt.controller.adfc.source.taskflowreturn.TaskFlowReturn;
import oracle.adfdt.controller.adfc.source.taskflowreturn.TaskFlowReturnOutcome;
import oracle.adfdt.controller.adfc.source.view.Page;
import oracle.adfdt.controller.adfc.source.view.View;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.faces.model.FacesConfig;
import oracle.jdeveloper.faces.model.application.Application;
import oracle.jdeveloper.faces.model.application.Locale;
import oracle.jdeveloper.faces.model.application.LocaleConfig;
import oracle.jdeveloper.faces.model.application.MessageBundle;
import oracle.jdeveloper.faces.model.application.ResourceBundle;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.webapp.faces.config.FacesConfigManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class CaseTaskFlow
extends FixedNameTransactionTask {
    private FormGenContext formGenCtx;
    private AbstractModel targetModel;
    private TaskFlow taskFlow;
    private XmlContext xmlContext;
    protected static final String CASE_REL_PATH_PI = "bpmCaseRelPath";
    protected static final String CASE_NAME_PI = "bpmCaseName";
    protected static final String CASE_ACTIVITY_NAME_PI = "bpmCaseActivityName";
    protected static final String CASE_BPM_PROJECT_PI = "bpmProject";
    private static final String TRANSACTION_NAME = "CaseTaskFlow";
    private static final String CASE_RESOURCE_BUNDLE = "oracle.bpm.datacontrol.resources.CaseFormResourceBundle";

    public CaseTaskFlow(AbstractModel targetModel, XmlContext xmlContext, FormGenContext formGenCtx) {
        super(TRANSACTION_NAME);
        this.targetModel = targetModel;
        this.xmlContext = xmlContext;
        this.formGenCtx = formGenCtx;
    }

    public void run() {
        this.run(this.targetModel);
    }

    public TaskFlow getTaskFlow() {
        return this.taskFlow;
    }

    protected void performTask(AbstractModel abstractModel) {
        TaskFlow targetTaskFlow = AdfcSingleViewUtils.getSingleTaskFlow((AbstractModel)this.targetModel, (boolean)true);
        if (targetTaskFlow instanceof BoundedTaskFlow) {
            this.addParameters(targetTaskFlow.getXmlModel(), (BoundedTaskFlow)targetTaskFlow);
        }
        String viewactId = this.insertViewActivity(targetTaskFlow);
        String initiateRetId = this.insertReturnActivity(targetTaskFlow, "initiate", "initiate");
        this.createControlFlows(targetTaskFlow, "*", initiateRetId, "initiate");
        String resetRetId = this.insertReturnActivity(targetTaskFlow, "reset", "reset");
        this.createControlFlows(targetTaskFlow, "*", resetRetId, "reset");
        this.insertCaseInfo(targetTaskFlow);
        this.addVisibilityUrlProp(targetTaskFlow);
        this.addLocaleAndResource(this.xmlContext);
        DataControlScope dcScope = ((BoundedTaskFlow)targetTaskFlow).createDataControlScope();
        SimpleEntity isolated = dcScope.createIsolated();
        dcScope.setIsolated(isolated);
        ((BoundedTaskFlow)targetTaskFlow).setDataControlScope(dcScope);
        this.addManagedBeans(targetTaskFlow);
        this.taskFlow = targetTaskFlow;
    }

    private void addManagedBeans(TaskFlow tf) {
        ManagedBean caseManagementBean = InsertManagedBeanTask.run((AbstractModel)this.targetModel, (TaskFlow)tf, (String)"caseManagementBean", (String)"oracle.bpm.datacontrol.beans.CaseManagementBean", (String)"pageFlow");
    }

    private void insertCaseInfo(TaskFlow targetTaskFlow) {
        AbstractModel xmlModel = targetTaskFlow.getXmlModel();
        try {
            Document doc = xmlModel.getDocument();
            xmlModel.startTransaction("Case Editor Link Transaction");
            ProcessingInstruction caseRelPathPI = doc.createProcessingInstruction(CASE_REL_PATH_PI, this.formGenCtx.getCaseActivityRelativePath());
            ProcessingInstruction caseNamePI = doc.createProcessingInstruction(CASE_NAME_PI, this.formGenCtx.getCaseName());
            ProcessingInstruction dataObjectPI = doc.createProcessingInstruction(CASE_ACTIVITY_NAME_PI, this.formGenCtx.getCaseActivityName());
            String bpmProjName = FormGenHelper.getProjectName(this.formGenCtx.getBpmProject());
            ProcessingInstruction bpmProjNamePI = doc.createProcessingInstruction(CASE_BPM_PROJECT_PI, bpmProjName);
            Element element = doc.getDocumentElement();
            element.getParentNode().insertBefore(caseRelPathPI, element);
            element.getParentNode().insertBefore(caseNamePI, element);
            element.getParentNode().insertBefore(dataObjectPI, element);
            element.getParentNode().insertBefore(bpmProjNamePI, element);
            xmlModel.commitTransaction();
        }
        catch (Exception e) {
            e.printStackTrace();
            xmlModel.rollbackTransaction();
        }
    }

    private String insertViewActivity(TaskFlow targetTaskFlow) {
        URL htmlDirUrl;
        URL formUrl = this.formGenCtx.getFormUrl();
        String relativeFormPath = URLFileSystem.toRelativeSpec((URL)formUrl, (URL)(htmlDirUrl = J2eeSettings.getInstance((Project)this.formGenCtx.getAdfProject()).getHtmlRootDirectory()));
        if (!relativeFormPath.startsWith("/")) {
            relativeFormPath = "/" + relativeFormPath;
        }
        String pageName = URLFileSystem.getFileName((URL)formUrl);
        String fromViewId = this.deriveViewIdFromPageName(pageName);
        XxxActivityId fromActId = this.createViewIfNecessary(targetTaskFlow, fromViewId, relativeFormPath);
        return fromViewId;
    }

    private String deriveViewIdFromPageName(String pageName) {
        String viewId = null;
        if (pageName != null) {
            viewId = pageName.replace('.', '_');
            if ((viewId = viewId.replace('/', '_')).startsWith("_")) {
                viewId = viewId.substring(1);
            }
        }
        return viewId;
    }

    private XxxActivityId createViewIfNecessary(TaskFlow taskFlow, String viewId, String pageName) {
        if (viewId != null && !viewId.endsWith("*") && taskFlow.getActivity(viewId) == null) {
            BoundedTaskFlow bounded;
            View view = (View)taskFlow.createActivity(ActivityType.VIEW);
            view.setId(viewId);
            Page page = view.createPage();
            page.setValue(pageName);
            view.setPage(page);
            taskFlow.addActivity((Activity)view);
            if (taskFlow instanceof BoundedTaskFlow && (bounded = (BoundedTaskFlow)taskFlow).getDefaultActivity() == null) {
                XxxActivityId activityId = bounded.createDefaultActivity();
                activityId.setValue(viewId);
                bounded.setDefaultActivity(activityId);
                return activityId;
            }
        }
        return null;
    }

    private String insertReturnActivity(TaskFlow targetTaskFlow, String retId, String outcome) {
        this.createReturn(targetTaskFlow, retId, outcome);
        return retId;
    }

    private void createReturn(TaskFlow taskFlow, String retId, String outcome) {
        if (retId != null && !retId.endsWith("*") && taskFlow.getActivity(retId) == null) {
            TaskFlowReturn tfRet = (TaskFlowReturn)taskFlow.createActivity(ActivityType.TASK_FLOW_RETURN);
            tfRet.setId(retId);
            TaskFlowReturnOutcome tfRetOut = tfRet.createOutcome();
            ValueEntity name = tfRetOut.createName();
            name.setValue(outcome);
            tfRetOut.setName(name);
            tfRet.setOutcome(tfRetOut);
            taskFlow.addActivity((Activity)tfRet);
        }
    }

    private void createControlFlows(TaskFlow taskFlow, String fromViewId, String toViewId, String outcome) {
        ControlFlowRule controlFlowRule = taskFlow.createControlFlowRule();
        taskFlow.addControlFlowRule(controlFlowRule);
        if (fromViewId != null && toViewId != null) {
            ControlFlowCase controlFlowCase = controlFlowRule.createControlFlowCase();
            controlFlowRule.addControlFlowCase(controlFlowCase);
            XxxActivityId fromActivityId = controlFlowRule.createFromActivityId();
            fromActivityId.setValue(fromViewId);
            controlFlowRule.setFromActivityId(fromActivityId);
            FromOutcome fromOutcome = controlFlowCase.createFromOutcome();
            fromOutcome.setValue(outcome);
            controlFlowCase.setFromOutcome(fromOutcome);
            XxxActivityId toActivityId = controlFlowCase.createToActivityId();
            toActivityId.setValue(toViewId);
            controlFlowCase.setToActivityId(toActivityId);
        }
    }

    private void addParameters(AbstractModel targetModel, BoundedTaskFlow targetTaskFlow) {
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"bpmWorklistContext", (String)"", (String)"#{pageFlowScope.bpmWorklistContext}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"bpmClientType", (String)"", (String)"#{pageFlowScope.bpmClientType}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"locale", (String)"", (String)"#{pageFlowScope.locale}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"tz", (String)"", (String)"#{pageFlowScope.tz}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"dateTimePattern", (String)"", (String)"#{pageFlowScope.dateTimePattern}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"datePattern", (String)"", (String)"#{pageFlowScope.datePattern}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"timePattern", (String)"", (String)"#{pageFlowScope.timePattern}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"activityDefinitionId", (String)"", (String)"#{pageFlowScope.aName}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"objId", (String)"", (String)"#{pageFlowScope.objId}", (boolean)false);
        InsertParameterTask.run((AbstractModel)targetModel, (BoundedTaskFlow)targetTaskFlow, (String)"caKey", (String)"", (String)"#{pageFlowScope.caKey}", (boolean)false);
    }

    private void addVisibilityUrlProp(TaskFlow targetTaskFlow) {
        if (targetTaskFlow instanceof BoundedTaskFlow) {
            Visibility vis = ((BoundedTaskFlow)targetTaskFlow).getVisibility();
            if (vis == null) {
                vis = ((BoundedTaskFlow)targetTaskFlow).createVisibility();
            }
            if (vis != null) {
                SimpleEntity se = vis.getUrlInvokeAllowed();
                if (se == null) {
                    se = vis.createUrlInvokeAllowed();
                }
                vis.setUrlInvokeAllowed(se);
                ((BoundedTaskFlow)targetTaskFlow).setVisibility(vis);
            }
        }
    }

    private boolean addLocaleAndResource(XmlContext context) {
        Context ideContext = ((JDevXmlContext)context).createContext();
        FacesConfig facesConfig = FacesConfigManager.findFacesConfig((Context)ideContext);
        if (facesConfig == null) {
            return false;
        }
        List apps = facesConfig.getApplications();
        Application app = null;
        boolean addApp = false;
        if (apps.isEmpty()) {
            app = facesConfig.createApplication();
            addApp = true;
        } else {
            app = (Application)apps.get(0);
        }
        facesConfig.startTransaction("Adding Faces-ADFm Phase Listener");
        try {
            if (addApp) {
                facesConfig.getApplications().add(app);
            }
            facesConfig.commitTransaction();
        }
        catch (ThreadDeath td) {
            facesConfig.rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            facesConfig.rollbackTransaction();
            System.out.println("[CaseTaskFlow] Cannot find faces-config app.");
        }
        facesConfig.startTransaction("ADFm create locale and bundle ");
        try {
            ResourceBundle resourceBundle;
            List apps2 = facesConfig.getApplications();
            Application app2 = (Application)apps2.get(0);
            List configs = app2.getLocaleConfigs();
            LocaleConfig config = null;
            config = app2.createLocaleConfig();
            if (config != null) {
                Locale locale = config.createLocale("en");
                config.setDefaultLocale(locale);
                configs.add(config);
            }
            List bundles = app2.getMessageBundles();
            MessageBundle bundle = null;
            bundle = app2.createMessageBundle(CASE_RESOURCE_BUNDLE);
            if (bundle != null) {
                bundles.add(bundle);
            }
            if ((resourceBundle = app2.createResourceBundle("resources", CASE_RESOURCE_BUNDLE)) != null) {
                List resourceBundles = app2.getResourceBundles();
                resourceBundles.add(resourceBundle);
            }
            facesConfig.commitTransaction();
        }
        catch (ThreadDeath td) {
            facesConfig.rollbackTransaction();
            throw td;
        }
        catch (Throwable t) {
            facesConfig.rollbackTransaction();
            return false;
        }
        return true;
    }
}

