/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import org.jetbrains.annotations.Nullable;

class ParameterDialog
extends JEWTDialog {
    private ParameterPanel componentPanel;

    private ParameterDialog(UiWindow parent, Msg msg, String name) {
        super((Frame)Ide.getMainWindow(), msg.getString(), 3);
        this.init(name);
    }

    @Nullable
    public static String showForCreation(UiWindow parent) {
        return ParameterDialog.show(parent, CaseUiMsg.CREATE_PARAMETER, null);
    }

    @Nullable
    public static String showForEdition(UiWindow parent, @Nullable String name) {
        return ParameterDialog.show(parent, CaseUiMsg.EDIT_PARAMETER, name);
    }

    public String getParameter() {
        return this.componentPanel.getParameter();
    }

    @Nullable
    private static String show(UiWindow parent, Msg msg, @Nullable String name) {
        ParameterDialog dialog = new ParameterDialog(parent, msg, name);
        return WizardLauncher.runDialog((JDialog)((Object)dialog)) ? dialog.getParameter() : null;
    }

    private void init(String name) {
        VetoableChangeListener OkListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                String parameter;
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && (parameter = ParameterDialog.this.getParameter()).isEmpty()) {
                    MessageDialog.showError(CaseUiMsg.INVALID_NAME, CaseUiMsg.INVALID_NAME_DESCRIPTION);
                    throw new PropertyVetoException("", evt);
                }
            }
        };
        this.addVetoableChangeListener(OkListener);
        this.componentPanel = new ParameterPanel(UiContainer.NULL, name);
        this.setContent(this.componentPanel.asSwing());
    }

    private static class ParameterPanel
    extends Panel {
        private TextField textField;

        public ParameterPanel(UiContainer parent, String defaultValue) {
            super(parent);
            this.init(defaultValue);
        }

        public String getParameter() {
            return this.textField.getText().trim();
        }

        private void init(String defaultValue) {
            this.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
            this.textField = new IdentifierTextField((UiContainer)this, 30, true);
            if (defaultValue != null) {
                this.textField.setText(defaultValue);
            }
            this.add(Label.create((UiContainer)this, CoreMsg.NAME));
            this.add(this.textField, "wrap");
        }
    }
}

