/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import javax.swing.JOptionPane;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellRenderer;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.ca.editor.ComponentOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.ProviderTableModel;

class HumantaskOutputParametersPanelBuilder
extends ComponentOutputParametersPanelBuilder<OutputParameter.NormalizedMessage> {
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return HumantaskOutputParametersPanelBuilder.this.getParameters();
        }
    };

    private HumantaskOutputParametersPanelBuilder(CaseActivity caseActivity, Project project) {
        super(caseActivity, project);
    }

    public static HumantaskOutputParametersPanelBuilder create(CaseActivity caseActivity, Project project) {
        return new HumantaskOutputParametersPanelBuilder(caseActivity, project);
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] filteredEvents;
        block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    Object newValue = childEvent.getNewValue();
                    if (!(newValue instanceof Output)) continue block5;
                    this.getTableModel().populate(this.getParameters());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    Object oldValue = childEvent.getOldValue();
                    if (!(oldValue instanceof Output)) continue block5;
                    this.getTableModel().populate(this.getParameters());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.getTableModel().populate(this.getParameters());
                }
            }
        }
    }

    public NMParametersTableModel createTableModel() {
        return new NMParametersTableModel(this.getProject(), this.getCaseActivity(), this.getParameters());
    }

    public NMParametersTableModel getTableModel() {
        return (NMParametersTableModel)super.getTableModel();
    }

    @Override
    protected CaseDataNameCellRenderer.Info getRenderInfo() {
        return new CaseDataNameCellRenderer.Info(){

            @Override
            public boolean validateCaseDataName(int row) {
                OutputParameter.NormalizedMessage parameter = (OutputParameter.NormalizedMessage)HumantaskOutputParametersPanelBuilder.this.getTableModel().getRow(row);
                return parameter.isStoreData();
            }
        };
    }

    @Override
    protected Msg getRefreshMsg() {
        return CaseUiMsg.SYNC_HUMANTASK_OUTPUT_PARAMETERS;
    }

    @Override
    protected OutputParameters createOutputParameters() {
        OutputParameters result = null;
        CaseActivity caseActivity = this.getCaseActivity();
        Activity activity = caseActivity.getActivity();
        Activity.Component component = activity.asComponent();
        ComponentInfo componentInfo = component.getComponentInfo();
        String referenceId = componentInfo.getReferenceId();
        Project project = this.getProject();
        HumanTask task = CaseManagementUtils.getHumanTask((Project)project, (String)referenceId);
        if (task != null) {
            Case casemgmt = CaseUtils.getCase(project);
            result = CaseActivityUtils.createOutputParameters((HumanTask)task, (Case)casemgmt);
        } else {
            String error = CaseModelMsg.INVALID_HUMANTASK((String)referenceId, (String)caseActivity.getName()).getString();
            JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_OUTPUT.getString(), 0);
        }
        return result;
    }

    private static class NMParametersTableModel
    extends ProviderTableModel<OutputParameter.NormalizedMessage> {
        private final CaseActivity caseActivity;
        private final Project project;
        private CaseDataNameType.TypeResolver typeResolver;
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_STORE_DATA = 1;

        public NMParametersTableModel(Project project, CaseActivity caseActivity, OutputParameters outputParameters) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.SAVE_OUTPUT_AS_CASE_DATA, CaseUiMsg.CASE_DATA_NAME));
            this.project = project;
            this.caseActivity = caseActivity;
            this.populate(outputParameters);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            OutputParameter.NormalizedMessage parameter = (OutputParameter.NormalizedMessage)this.getRow(row);
            return column == 1 || column == 2 && parameter.isStoreData();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            OutputParameter.NormalizedMessage parameter = (OutputParameter.NormalizedMessage)this.getRow(row);
            switch (column) {
                case 0: {
                    parameter.setParamName((String)value);
                    break;
                }
                case 1: {
                    parameter.setStoreData(((Boolean)value).booleanValue());
                    break;
                }
                case 2: {
                    CaseDataNameType dataNameType = (CaseDataNameType)value;
                    parameter.setDataName(dataNameType.getName());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            Class result;
            switch (column) {
                case 1: {
                    result = Boolean.class;
                    break;
                }
                case 2: {
                    result = CaseDataNameType.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            OutputParameter.NormalizedMessage parameter = (OutputParameter.NormalizedMessage)this.getRow(row);
            Object result = "";
            switch (column) {
                case 0: {
                    result = parameter.getParamName();
                    break;
                }
                case 1: {
                    result = parameter.isStoreData();
                    break;
                }
                case 2: {
                    result = CaseDataNameType.create(parameter.getDataName(), this.getTypeResolver());
                }
            }
            return result;
        }

        private CaseDataNameType.TypeResolver getTypeResolver() {
            if (this.typeResolver == null) {
                this.typeResolver = new CaseDataNameType.TypeResolver(){

                    @Override
                    public CatalogType getType(int row) {
                        CatalogType result = null;
                        ComponentInfo componentInfo = NMParametersTableModel.this.caseActivity.getActivity().toHumanTask().getComponentInfo();
                        String referenceId = componentInfo.getReferenceId();
                        HumanTask task = CaseManagementUtils.getHumanTask((Project)NMParametersTableModel.this.project, (String)referenceId);
                        if (task != null) {
                            OutputParameter.NormalizedMessage parameter = (OutputParameter.NormalizedMessage)NMParametersTableModel.this.getRow(row);
                            String paramName = parameter.getParamName();
                            Sequence declarations = CaseActivityUtils.getOutputDeclarations((HumanTask)task);
                            result = CaseActivityUtils.getCatalogTypeByName((Sequence)declarations, (String)paramName);
                        }
                        return result;
                    }
                };
            }
            return this.typeResolver;
        }

        private void populate(OutputParameters outputParameters) {
            this.removeAllElements();
            if (!outputParameters.isEmpty()) {
                Output output = (Output)outputParameters.get(0);
                for (OutputParameter value : output) {
                    if (!value.getType().isNormalizedMessage()) continue;
                    this.addRow(value.asNormalizedMessage());
                }
            }
        }
    }
}

