/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import javax.swing.JOptionPane;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.Permissions;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractInputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.BpmnOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.ComponentInputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.CustomInputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.CustomOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.HumantaskOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.form.FormGenerator;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.TextFieldButtonPanel;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiError;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

class GeneralTabPanel
extends AbstractEntityPanel<CaseActivity> {
    private ItemListener checkBoxListener;
    private FormGenContext formGenCtx;
    private AbstractInputParametersPanelBuilder inputPanel;
    private AbstractOutputParametersPanelBuilder outputPanel;
    private PermissionPanel permissionPanel;
    private static final Image BPM_HEADER_ICON = Image.create(CaseUiMsg.BPMN_HEADER_IMAGE40);
    private static final Image HUMANTASK_HEADER_ICON = Image.create(CaseUiMsg.HUMANTASK_HEADER_IMAGE40);
    private static final Image CUSTOM_HEADER_ICON = Image.create(CaseUiMsg.CUSTOM_HEADER_IMAGE40);
    private static final Image HEADER_ICON = Image.create(CaseUiMsg.CASE_ACTIVITY_HEADER_DESCRIPTION);
    private static final int REQUIRED = 1;
    private static final int REPEATABLE = 2;
    private static final int CONDITIONAL = 3;
    private static final String CHECKBOX_ID = "CHECKBOX_ID";

    public GeneralTabPanel(UiContainer parent, Project project, CaseActivity caseActivity, String name) {
        super(parent, caseActivity);
        this.init(project, name);
    }

    @Override
    public void modelChanged(Event ... events) {
        this.permissionPanel.modelChanged(events);
        this.inputPanel.modelChanged(events);
        this.outputPanel.modelChanged(events);
    }

    public void setFormGenContext(FormGenContext formGenCtx) {
        this.formGenCtx = formGenCtx;
    }

    public FormGenContext getFormGenCtx() {
        return this.formGenCtx;
    }

    private static Image getImageHeader(Activity.Type type) {
        Image result;
        switch (type) {
            case BPMN: {
                result = BPM_HEADER_ICON;
                break;
            }
            case HUMANTASK: {
                result = HUMANTASK_HEADER_ICON;
                break;
            }
            case CUSTOM: {
                result = CUSTOM_HEADER_ICON;
                break;
            }
            default: {
                result = HEADER_ICON;
            }
        }
        return result;
    }

    private void init(Project project, String name) {
        CaseActivity caseActivity = (CaseActivity)this.getEntityModel();
        Activity activity = caseActivity.getActivity();
        this.setLayout(FormBuilder.createLayoutWithMargin());
        UiComponent header = FormBuilder.createHeader(this, GeneralTabPanel.getImageHeader(activity.getType()), CaseUiMsg.CASE_ACTIVITY_HEADER(name), CaseUiMsg.CASE_ACTIVITY_HEADER_DESCRIPTION);
        Panel radioPanel = this.buildRadioPanel();
        CheckBox requiredCheckBox = this.createCheckBox(this, CaseUiMsg.REQUIRED, caseActivity.isRequired(), 1);
        CheckBox repeatableCheckBox = this.createCheckBox(this, CaseUiMsg.REPEATABLE, caseActivity.isRepeatable(), 2);
        CheckBox conditionalCheckBox = this.createCheckBox(this, CaseUiMsg.CONDITIONALLY_AVAILABLE, caseActivity.isConditional(), 3);
        FormBuilder.addExpandX(this, header);
        FormBuilder.addIndent(this, radioPanel);
        FormBuilder.addIndent(this, requiredCheckBox);
        FormBuilder.addIndent(this, repeatableCheckBox);
        FormBuilder.addIndent(this, conditionalCheckBox);
        this.permissionPanel = new PermissionPanel(this, caseActivity, CaseUtils.getCase(project));
        FormBuilder.addIndent(this, this.permissionPanel);
        Activity.Type type = activity.getType();
        if (type.isBpmn()) {
            this.inputPanel = ComponentInputParametersPanelBuilder.create(caseActivity, project);
            this.outputPanel = BpmnOutputParametersPanelBuilder.create(caseActivity, project);
        } else if (type.isHumantask()) {
            this.inputPanel = ComponentInputParametersPanelBuilder.create(caseActivity, project);
            this.outputPanel = HumantaskOutputParametersPanelBuilder.create(caseActivity, project);
        } else {
            InputParameters input = activity.getInputParameters();
            OutputParameters output = activity.getOutputParameters();
            this.inputPanel = CustomInputParametersPanelBuilder.create(input, project);
            this.outputPanel = CustomOutputParametersPanelBuilder.create(output, project);
        }
        FormBuilder.addExpandX(this, this.inputPanel.build(this));
        FormBuilder.addExpandX(this, this.outputPanel.build(this));
    }

    private CheckBox createCheckBox(UiContainer parent, Msg msg, boolean value, int id) {
        CheckBox result = CheckBox.create(parent, msg, value);
        result.addItemListener(this.getCheckBoxListener());
        result.putClientProperty(CHECKBOX_ID, id);
        return result;
    }

    private Panel buildRadioPanel() {
        final CaseActivity caseActivity = (CaseActivity)this.getEntityModel();
        BaseAction manualAction = new BaseAction(CaseUiMsg.MANUALLY_ACTIVATED){

            @Override
            public void run() {
                caseActivity.setManual(true);
            }
        };
        BaseAction automaticAction = new BaseAction(CaseUiMsg.AUTOMATICALLY_ACTIVATED){

            @Override
            public void run() {
                caseActivity.setManual(false);
            }
        };
        Panel radioPanel = new Panel(this);
        radioPanel.setLayout(new MigLayout("gapx 8, gapy 6, ins 0"));
        RadioButton manualRadio = new RadioButton((UiContainer)radioPanel, manualAction);
        manualRadio.setSelected(caseActivity.isManual());
        RadioButton automaticRadio = new RadioButton((UiContainer)radioPanel, automaticAction);
        automaticRadio.setSelected(!caseActivity.isManual());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(manualRadio);
        buttonGroup.add(automaticRadio);
        radioPanel.add(manualRadio);
        radioPanel.add(automaticRadio);
        BaseAction formGenAction = new BaseAction(CaseUiMsg.CA_FORM_ICON){

            @Override
            public void actionPerformed(ActionEvent event) {
                super.actionPerformed(event);
                UiComponent formButton = event.getSource();
                FormGenerator formGen = new FormGenerator(GeneralTabPanel.this.formGenCtx);
                formGen.handleActivityFormButton(formButton.asSwing());
            }
        };
        Button formGenButton = Button.createIconic(radioPanel, CaseUiMsg.CA_FORM_ICON);
        formGenButton.setAction(formGenAction);
        radioPanel.add(formGenButton);
        return radioPanel;
    }

    private ItemListener getCheckBoxListener() {
        if (this.checkBoxListener == null) {
            this.checkBoxListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CaseActivity caseActivity = (CaseActivity)GeneralTabPanel.this.getEntityModel();
                    boolean selected = e.isStateSelected();
                    CheckBox checkBox = (CheckBox)e.getSource();
                    int id = (Integer)checkBox.getClientProperty(GeneralTabPanel.CHECKBOX_ID);
                    switch (id) {
                        case 1: {
                            caseActivity.setRequired(selected);
                            break;
                        }
                        case 2: {
                            caseActivity.setRepeatable(selected);
                            break;
                        }
                        case 3: {
                            caseActivity.setConditional(selected);
                        }
                    }
                }
            };
        }
        return this.checkBoxListener;
    }

    private static class PermissionPanel
    extends AbstractEntityPanel<CaseActivity> {
        private PermissionTextFieldPanel permissionFieldPanel;

        public PermissionPanel(UiContainer parent, CaseActivity caseActivity, Case casemgmt) {
            super(parent, caseActivity);
            this.init(casemgmt.getPermissions());
        }

        @Override
        public void modelChanged(Event ... events) {
            this.permissionFieldPanel.modelChanged(events);
        }

        private void init(Permissions permissions) {
            this.permissionFieldPanel = new PermissionTextFieldPanel(this, permissions){

                @Override
                protected void change(String value) {
                    ((CaseActivity)PermissionPanel.this.getEntityModel()).setPermission(value);
                }
            };
            this.permissionFieldPanel.setComponentValue(((CaseActivity)this.getEntityModel()).getPermission());
            this.setLayout(new MigLayout("gapx 8, gapy 6, ins 0"));
            this.add(Label.create((UiContainer)this, CaseModelMsg.PERMISSION));
            this.add(this.permissionFieldPanel);
        }

        private static class PermissionTextFieldPanel
        extends TextFieldButtonPanel {
            private Permissions permissions;
            private final EventFilter FILTER = new EventFilter.Default(){

                protected Entity validInstance() {
                    return PermissionTextFieldPanel.this.permissions;
                }
            };
            private IdentifierTextField textField;
            private static final UiError NO_ERROR = null;

            public PermissionTextFieldPanel(UiContainer parent, Permissions permissions) {
                super(parent);
                this.permissions = permissions;
            }

            public void modelChanged(Event ... events) {
                Event[] eventsFiltered = this.FILTER.apply(events);
                if (eventsFiltered.length > 0) {
                    this.validatePermission();
                }
            }

            @Override
            protected TextField createTextField(UiContainer parent) {
                this.textField = new IdentifierTextField(parent, 30, true);
                this.textField.addDocumentListener(new DocumentListener.Default(){

                    @Override
                    public void anyUpdate(DocumentEvent e) {
                        PermissionTextFieldPanel.this.validatePermission();
                    }
                });
                return this.textField;
            }

            @Override
            protected Msg getMsg() {
                return UIMsg.BROWSE;
            }

            @Override
            protected void onButtonClick() {
                Object selection = JOptionPane.showInputDialog(this.asSwing(), CaseModelMsg.PERMISSION.getString(), CaseUiMsg.PERMISSIONS.getString(), -1, null, this.permissions.toArray(), null);
                if (selection != null) {
                    String value = (String)selection;
                    this.change(value);
                    this.setComponentValue(value);
                }
            }

            private void validatePermission() {
                String text = this.textField.getText();
                UiError error = Str.isEmpty(text) || this.permissions.contains((Object)text) ? NO_ERROR : UiError.createError(CaseUiMsg.ERROR_INVALID_PERMISSION.getString());
                this.textField.setError(error);
            }
        }
    }
}

