/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellEditor;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellRenderer;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.ca.editor.ParameterDialog;
import oracle.bpm.casemgmt.ui.common.NoEmptyStringTableCellRenderer;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;

class CustomOutputParametersPanelBuilder
extends AbstractOutputParametersPanelBuilder<OutputParameter> {
    private Output output;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return CustomOutputParametersPanelBuilder.this.output;
        }
    };
    private OutputParameters parameters;
    private Project project;

    private CustomOutputParametersPanelBuilder(OutputParameters parameters, Project project) {
        this.parameters = parameters;
        this.project = project;
        this.output = parameters.isEmpty() ? CaseActivityFactory.createOutput() : (Output)parameters.get(0);
    }

    public static CustomOutputParametersPanelBuilder create(OutputParameters parameters, Project project) {
        return new CustomOutputParametersPanelBuilder(parameters, project);
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] filteredEvents;
        block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    Object newValue = childEvent.getNewValue();
                    if (!(newValue instanceof OutputParameter)) continue block5;
                    this.addToModel((OutputParameter)newValue);
                    continue block5;
                }
                case ATTR_REMOVED: {
                    Object oldValue = childEvent.getOldValue();
                    if (!(oldValue instanceof OutputParameter)) continue block5;
                    this.getTableModel().removeRow((OutputParameter)oldValue);
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.getTableModel().fireTableDataChanged();
                }
            }
        }
    }

    public ParametersTableModel createTableModel() {
        return new ParametersTableModel(this.output);
    }

    public ParametersTableModel getTableModel() {
        return (ParametersTableModel)super.getTableModel();
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(NoEmptyStringTableCellRenderer.INSTANCE);
        TableColumn column1 = columnModel.getColumn(1);
        CustomOutputParametersPanelBuilder.setColumnSize(column1, 170);
        TableColumn column2 = columnModel.getColumn(2);
        Case casemgmt = CaseUtils.getCase(this.project);
        column2.setCellEditor(CaseDataNameCellEditor.create(casemgmt));
        column2.setCellRenderer(CaseDataNameCellRenderer.create(casemgmt, this.getRenderInfo()));
        CustomOutputParametersPanelBuilder.setColumnSize(column2, 250);
    }

    protected CaseDataNameCellRenderer.Info getRenderInfo() {
        return new CaseDataNameCellRenderer.Info(){

            @Override
            public boolean validateCaseDataName(int row) {
                OutputParameter parameter = (OutputParameter)CustomOutputParametersPanelBuilder.this.getTableModel().getRow(row);
                return parameter.isStoreData();
            }
        };
    }

    @Override
    protected void addAction() {
        String name = ParameterDialog.showForCreation(this.getEditor().getOwnerWindow());
        if (name != null) {
            OutputParameter outputParameter = CaseActivityFactory.createOutputParameter();
            outputParameter.setParamName(name);
            if (this.parameters.isEmpty()) {
                this.parameters.add((Object)this.output);
            }
            this.output.add((Object)outputParameter);
        }
    }

    @Override
    protected void removeAction(List<OutputParameter> toRemove) {
        for (OutputParameter parameter : toRemove) {
            this.output.remove((Object)parameter);
            if (this.output.size() != 0) continue;
            this.parameters.remove((Object)this.output);
        }
    }

    @Override
    protected int actions() {
        return 5;
    }

    private static class ParametersTableModel
    extends ProviderTableModel<OutputParameter> {
        private static final int COLUMN_NAME = 0;
        private static final int COLUMN_STORE_DATA = 1;
        private static final int COLUMN_CASE_DATA_NAME = 2;

        public ParametersTableModel(Output output) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.STORE_DATA, CaseUiMsg.CASE_DATA_NAME));
            this.populate(output);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            OutputParameter parameter = (OutputParameter)this.getRow(row);
            return column != 2 || parameter.isStoreData();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            OutputParameter parameter = (OutputParameter)this.getRow(row);
            switch (column) {
                case 0: {
                    parameter.setParamName((String)value);
                    break;
                }
                case 1: {
                    parameter.setStoreData(((Boolean)value).booleanValue());
                    break;
                }
                case 2: {
                    CaseDataNameType dataNameType = (CaseDataNameType)value;
                    parameter.setDataName(dataNameType.getName());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            Class result;
            switch (column) {
                case 1: {
                    result = Boolean.class;
                    break;
                }
                case 2: {
                    result = CaseDataNameType.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            OutputParameter parameter = (OutputParameter)this.getRow(row);
            Object result = "";
            switch (column) {
                case 0: {
                    result = parameter.getParamName();
                    break;
                }
                case 1: {
                    result = parameter.isStoreData();
                    break;
                }
                case 2: {
                    result = CaseDataNameType.create(parameter.getDataName(), null);
                }
            }
            return result;
        }

        private void populate(Output output) {
            this.removeAllElements();
            for (OutputParameter value : output) {
                if (!value.getType().isPayload()) continue;
                this.addRow(value);
            }
        }
    }
}

