/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractInputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.ParameterDialog;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.project.model.Project;

class CustomInputParametersPanelBuilder
extends AbstractInputParametersPanelBuilder {
    private CustomInputParametersPanelBuilder(InputParameters parameters, Project project) {
        super(parameters, project);
    }

    public static CustomInputParametersPanelBuilder create(InputParameters parameters, Project project) {
        return new CustomInputParametersPanelBuilder(parameters, project);
    }

    public AbstractInputParametersPanelBuilder.ParametersTableModel createTableModel() {
        return new AbstractInputParametersPanelBuilder.ParametersTableModel(Activity.Type.CUSTOM, this.getParameters(), null);
    }

    @Override
    protected int actions() {
        return 5;
    }

    @Override
    protected Action[] addActions() {
        AbstractAction caseDataAction = new AbstractAction(CaseUiMsg.ADD_CASE_DATA.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                String parameter = ParameterDialog.showForCreation(CustomInputParametersPanelBuilder.this.getEditor().getOwnerWindow());
                if (parameter != null) {
                    InputParameter.CaseData caseData = CustomInputParametersPanelBuilder.this.createCaseData(parameter);
                    InputParameters parameters = CustomInputParametersPanelBuilder.this.getParameters();
                    parameters.add((Object)caseData);
                }
            }
        };
        AbstractAction payloadAction = new AbstractAction(CaseUiMsg.ADD_USER_INPUT.getString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                String parameter = ParameterDialog.showForCreation(CustomInputParametersPanelBuilder.this.getEditor().getOwnerWindow());
                if (parameter != null) {
                    InputParameter.Payload payload = CaseActivityFactory.createPayloadInputParameter();
                    payload.setParamName(parameter);
                    CustomInputParametersPanelBuilder.this.getParameters().add((Object)payload);
                }
            }
        };
        return new Action[]{caseDataAction, payloadAction};
    }

    @Override
    protected void removeAction(List<InputParameter> toRemove) {
        InputParameters parameters = this.getParameters();
        for (InputParameter parameter : toRemove) {
            parameters.remove((Object)parameter);
        }
    }

    private InputParameter.CaseData createCaseData(String parameter) {
        InputParameter.CaseData result = CaseActivityFactory.createCaseDataInputParameter();
        result.setParamName(parameter);
        return result;
    }
}

