/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellEditor;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellRenderer;
import oracle.bpm.casemgmt.ui.common.NoEmptyStringTableCellRenderer;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import oracle.javatools.ui.table.GenericTable;

abstract class ComponentOutputParametersPanelBuilder<E>
extends AbstractOutputParametersPanelBuilder<E> {
    private CaseActivity caseActivity;
    private OutputParameters parameters;
    private Project project;
    protected static final int COLUMN_NAME = 0;
    protected static final int COLUMN_STORE_DATA = 1;
    protected static final int COLUMN_CASE_DATA_NAME = 2;

    protected ComponentOutputParametersPanelBuilder(CaseActivity caseActivity, Project project) {
        this.project = project;
        this.caseActivity = caseActivity;
        this.parameters = caseActivity.getActivity().getOutputParameters();
    }

    protected abstract CaseDataNameCellRenderer.Info getRenderInfo();

    protected abstract Msg getRefreshMsg();

    protected abstract OutputParameters createOutputParameters();

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(NoEmptyStringTableCellRenderer.INSTANCE);
        TableColumn column1 = columnModel.getColumn(1);
        ComponentOutputParametersPanelBuilder.setColumnSize(column1, 170);
        TableColumn column2 = columnModel.getColumn(2);
        Case casemgmt = CaseUtils.getCase(this.project);
        column2.setCellEditor(CaseDataNameCellEditor.create(casemgmt));
        column2.setCellRenderer(CaseDataNameCellRenderer.create(casemgmt, this.getRenderInfo()));
        ComponentOutputParametersPanelBuilder.setColumnSize(column2, 250);
    }

    @Override
    protected Action[] customActions() {
        AbstractAction refreshAction = new AbstractAction("", Image.create(UIMsg.REFRESH).asSwingIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputParameters newOutputParameters;
                int rc;
                ProjectCase projectCase = ComponentOutputParametersPanelBuilder.this.project.getCase();
                if (projectCase != null && (rc = JOptionPane.showConfirmDialog(ComponentOutputParametersPanelBuilder.this.getEditor().asSwing(), ComponentOutputParametersPanelBuilder.this.getRefreshMsg().getString(), CaseUiMsg.CASE_ACTIVITY_OUTPUT.getString(), 0)) == 0 && (newOutputParameters = ComponentOutputParametersPanelBuilder.this.createOutputParameters()) != null) {
                    ComponentOutputParametersPanelBuilder.this.parameters.clear();
                    ComponentOutputParametersPanelBuilder.this.parameters.addAll((Collection)newOutputParameters);
                }
            }
        };
        return new Action[]{refreshAction};
    }

    protected Project getProject() {
        return this.project;
    }

    protected CaseActivity getCaseActivity() {
        return this.caseActivity;
    }

    protected OutputParameters getParameters() {
        return this.parameters;
    }
}

