/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.AbstractInputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComponentInputParametersPanelBuilder
extends AbstractInputParametersPanelBuilder {
    private CaseActivity caseActivity;

    private ComponentInputParametersPanelBuilder(CaseActivity caseActivity, Project project) {
        super(caseActivity.getActivity().getInputParameters(), project);
        this.caseActivity = caseActivity;
    }

    public static ComponentInputParametersPanelBuilder create(CaseActivity caseActivity, Project project) {
        return new ComponentInputParametersPanelBuilder(caseActivity, project);
    }

    public AbstractInputParametersPanelBuilder.ParametersTableModel createTableModel() {
        return new ComponentInputParametersTableModel(this.caseActivity.getActivity().getType(), this.getParameters(), this.createTypeResolver());
    }

    @Override
    protected Action[] customActions() {
        AbstractAction refreshAction = new AbstractAction("", Image.create(UIMsg.REFRESH).asSwingIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ComponentInputParametersPanelBuilder.this.getProject();
                ProjectCase projectCase = project.getCase();
                if (projectCase != null) {
                    InputParameters newInputParameters;
                    Activity activity = ComponentInputParametersPanelBuilder.this.caseActivity.getActivity();
                    Msg msg = activity.getType().isBpmn() ? CaseUiMsg.SYNC_BPMN_INPUT_PARAMETERS : CaseUiMsg.SYNC_HUMANTASK_INPUT_PARAMETERS;
                    int rc = JOptionPane.showConfirmDialog(ComponentInputParametersPanelBuilder.this.getEditor().asSwing(), msg.getString(), CaseUiMsg.CASE_ACTIVITY_INPUT.getString(), 0);
                    if (rc == 0 && (newInputParameters = ComponentInputParametersPanelBuilder.this.createInputParameters(CaseUtils.getCase(ComponentInputParametersPanelBuilder.this.getProject()))) != null) {
                        InputParameters inputParameters = ComponentInputParametersPanelBuilder.this.getParameters();
                        inputParameters.clear();
                        inputParameters.addAll((Collection)newInputParameters);
                    }
                }
            }
        };
        return new Action[]{refreshAction};
    }

    protected InputParameters createInputParameters(@Nullable Case casemgmt) {
        InputParameters result = null;
        Activity activity = this.caseActivity.getActivity();
        Activity.Component component = activity.asComponent();
        ComponentInfo componentInfo = component.getComponentInfo();
        String referenceId = componentInfo.getReferenceId();
        String operation = componentInfo.getOperation();
        Project project = this.getProject();
        if (activity.getType().isBpmn()) {
            Process process = project.findProcess(referenceId);
            if (process != null) {
                CatchEvent catchEvent = CaseActivityUtils.getOperationByName((Process)process, (String)operation);
                if (catchEvent != null) {
                    result = CaseActivityUtils.createInputParameters((CatchEvent)catchEvent, (Case)casemgmt);
                } else {
                    String error = CaseModelMsg.INVALID_BPMN_OPERATION((String)referenceId, (String)process.getId(), (String)this.caseActivity.getName()).getString();
                    JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_INPUT.getString(), 0);
                }
            } else {
                String error = CaseModelMsg.INVALID_BPMN_PROCESS((String)referenceId, (String)this.caseActivity.getName()).getString();
                JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_INPUT.getString(), 0);
            }
        } else {
            HumanTask task = CaseManagementUtils.getHumanTask((Project)this.getProject(), (String)referenceId);
            if (task != null) {
                result = CaseActivityUtils.createInputParameters((HumanTask)task, (Case)casemgmt);
            } else {
                String error = CaseModelMsg.INVALID_HUMANTASK((String)referenceId, (String)this.caseActivity.getName()).getString();
                JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_INPUT.getString(), 0);
            }
        }
        return result;
    }

    private CaseDataNameType.TypeResolver createTypeResolver() {
        return new CaseDataNameType.TypeResolver(){

            @Override
            public CatalogType getType(int row) {
                InputParameter inputParameter = (InputParameter)ComponentInputParametersPanelBuilder.this.getTableModel().getRow(row);
                String paramName = inputParameter.getParamName();
                Sequence declarations = CaseActivityUtils.getInputDeclarations((Project)ComponentInputParametersPanelBuilder.this.getProject(), (CaseActivity)ComponentInputParametersPanelBuilder.this.caseActivity);
                return CaseActivityUtils.getCatalogTypeByName((Sequence)declarations, (String)paramName);
            }
        };
    }

    private class ComponentInputParametersTableModel
    extends AbstractInputParametersPanelBuilder.ParametersTableModel {
        public ComponentInputParametersTableModel(Activity.Type type, @Nullable InputParameters events, CaseDataNameType.TypeResolver typeResolver) {
            super(type, events, typeResolver);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column != 1) {
                super.setValueAt(value, row, column);
                return;
            }
            InputParameterType newType = (InputParameterType)value;
            InputParameter parameter = (InputParameter)this.getRow(row);
            this.changeParameterType(parameter, newType);
        }

        private void changeParameterType(@NotNull InputParameter inputParameter, @NotNull InputParameterType newType) {
            if (newType.isPayload()) {
                InputParameter.Payload inputFromActivity = this.findInputFromActivity(inputParameter);
                if (inputFromActivity != null) {
                    InputParameter.Payload payload = inputParameter.toPayload();
                    payload.setElementType(inputFromActivity.getElementType());
                    payload.setElementDataType(inputFromActivity.getElementDataType());
                    payload.setElementDataType(inputFromActivity.getElementDataType());
                } else {
                    JOptionPane.showMessageDialog(ComponentInputParametersPanelBuilder.this.getEditor().asSwing(), CaseUiMsg.UNABLE_TO_CHANGE_TYPE.toString(), CaseUiMsg.CASE_ACTIVITY_INPUT.getString(), 0);
                }
            } else {
                inputParameter.toCaseData();
            }
        }

        private InputParameter.Payload findInputFromActivity(@NotNull InputParameter parameter) {
            InputParameter.Payload result = null;
            InputParameters inputParameters = ComponentInputParametersPanelBuilder.this.createInputParameters(null);
            for (InputParameter inputParameter : inputParameters) {
                InputParameter.Payload payload = inputParameter.toPayload();
                if (!inputParameter.getParamName().equals(parameter.getParamName()) || !inputParameter.getElementName().equals(inputParameter.getElementName())) continue;
                result = payload;
                break;
            }
            return result;
        }
    }
}

