/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.ide.editor.EditorUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

class ComponentInfoPanelBuilder
extends HeaderPanelBuilder
implements EntityEvents {
    private Activity.Component activity;
    private Project project;
    private static final int COLUMNS = 40;

    private ComponentInfoPanelBuilder(Project project, Activity.Component activity) {
        super(CaseUiMsg.COMPONENT_INFO, CaseUiMsg.COMPONENT_INFO_DESCRIPTION, !COLLAPSED);
        this.project = project;
        this.activity = activity;
    }

    public static ComponentInfoPanelBuilder create(Project project, Activity.Component activity) {
        return new ComponentInfoPanelBuilder(project, activity);
    }

    @Override
    public void modelChanged(Event ... events) {
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        Panel result = new Panel(parent);
        final ComponentInfo componentInfo = this.activity.getComponentInfo();
        Activity.Type type = this.activity.getType();
        BaseAction action = new BaseAction(){

            @Override
            public void run() {
                ComponentInfoPanelBuilder.this.openEditor();
            }
        };
        Link referenceLink = new Link(result, action);
        referenceLink.setText(componentInfo.getReferenceId());
        Msg msg = type.getMsg();
        referenceLink.setIcon(Image.create(msg));
        final TextField namespaceTextField = new TextField((UiContainer)result, componentInfo.getNamespace(), 40);
        namespaceTextField.addDocumentListener(new DocumentListener.Default(){

            @Override
            public void anyUpdate(DocumentEvent e) {
                componentInfo.setNamespace(namespaceTextField.getText());
            }
        });
        namespaceTextField.setEnabled(false);
        final TextField operationTextField = new TextField(result, componentInfo.getOperation(), 40, true);
        operationTextField.setEnabled(false);
        result.setLayout(new MigLayout("gapy 6, gapx 8, ins 0"));
        result.add(Label.create((UiContainer)result, CaseUiMsg.SERVICE_REFERENCE));
        result.add(referenceLink, "wrap");
        result.add(Label.create((UiContainer)result, CaseUiMsg.NAMESPACE));
        result.add(namespaceTextField, "wrap");
        result.add(Label.create((UiContainer)result, CaseUiMsg.OPERATION_NAME));
        result.add(operationTextField, type.isHumantask() ? "wrap" : null);
        if (type.isBpmn()) {
            final Button button = Button.createIconic(result, UIMsg.REFRESH);
            final CheckBox synchronousCheckBox = CheckBox.create(result, CaseUiMsg.SYNCHRONOUS, componentInfo.isSynchronous());
            synchronousCheckBox.setEnabled(false);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection operations;
                    Process process = ComponentInfoPanelBuilder.this.project.findProcess(componentInfo.getReferenceId());
                    if (process != null && !(operations = CaseActivityUtils.getOperations((Process)process)).isEmpty()) {
                        String newOperation;
                        if (operations.size() > 1) {
                            ArrayList<String> list = new ArrayList<String>();
                            for (CatchEvent operation : operations) {
                                list.add(CaseActivityUtils.getOperationName((CatchEvent)operation));
                            }
                            newOperation = (String)JOptionPane.showInputDialog(button.asSwing(), CaseUiMsg.OPERATION_NAME.getString(), CaseUiMsg.OPERATION_NAME.getString(), -1, null, list.toArray(), list.get(0));
                        } else {
                            CatchEvent next = (CatchEvent)operations.iterator().next();
                            newOperation = CaseActivityUtils.getOperationName((CatchEvent)next);
                        }
                        if (newOperation != null) {
                            componentInfo.setOperation(newOperation);
                            operationTextField.setText(newOperation);
                            for (CatchEvent operation : operations) {
                                boolean isSynchronous;
                                if (!newOperation.equals(CaseActivityUtils.getOperationName((CatchEvent)operation)) || (isSynchronous = CaseActivityUtils.isSynchronous((CatchEvent)operation)) == componentInfo.isSynchronous()) continue;
                                componentInfo.setSynchronous(isSynchronous);
                                synchronousCheckBox.setSelected(isSynchronous);
                            }
                        }
                    }
                }
            });
            result.add(button, "wrap");
            result.add(synchronousCheckBox, "skip");
        }
        return result;
    }

    protected void openEditor() {
        ComponentInfo componentInfo = this.activity.getComponentInfo();
        String name = componentInfo.getReferenceId();
        if (this.activity.getType().isBpmn()) {
            Process process = this.project.findProcess(name);
            if (process != null) {
                URL url = CaseUtils.adaptTo(process, URL.class);
                EditorUtil.openDefaultEditorInFrame((URL)url);
            } else {
                MessageDialog.showError(CaseUiMsg.PROCESS_CASE_ACTIVITY_ERROR);
            }
        } else {
            URL urlProject = CaseUtils.adaptTo(this.project, URL.class);
            if (urlProject != null) {
                URL url = URLFactory.newURL((URL)urlProject, (String)(name + ".task"));
                if (URLFileSystem.exists((URL)url)) {
                    EditorUtil.openDefaultEditorInFrame((URL)url);
                } else {
                    MessageDialog.showError(CaseUiMsg.HUMANTASK_CASE_ACTIVITY_ERROR);
                }
            }
        }
    }
}

