/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.ca.editor.NoApplicableCellRenderer;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.lang.Str;

class CaseDataNameCellRenderer
extends DefaultTableCellRenderer {
    private Case casemgmt;
    private String dataName;
    private Info info;
    private boolean validateCaseDataName;

    private CaseDataNameCellRenderer(Case casemgmt, Info info) {
        this.casemgmt = casemgmt;
        this.info = info;
    }

    public static CaseDataNameCellRenderer create(Case casemgmt, Info info) {
        return new CaseDataNameCellRenderer(casemgmt, info);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result;
        this.validateCaseDataName = this.info.validateCaseDataName(row);
        if (this.validateCaseDataName) {
            CaseDataNameType dataNameType = (CaseDataNameType)value;
            this.dataName = dataNameType.getName();
            if (!Str.isEmpty(this.dataName)) {
                PropertyBundle bundle = this.casemgmt.getPropertyBundles().getDefault();
                String name = bundle.containsKey((Object)this.dataName) ? (String)bundle.get((Object)this.dataName) : "[" + this.dataName + "]";
                result = super.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, column);
                ((JLabel)result).setToolTipText(this.dataName);
            } else {
                result = super.getTableCellRendererComponent(table, this.dataName, isSelected, hasFocus, row, column);
            }
        } else {
            result = NoApplicableCellRenderer.INSTANCE.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return result;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.validateCaseDataName) {
            String error = this.error(this.dataName);
            if (error != null) {
                CaseUtils.paintHorizontalSquiggleLine(g, this, this.getText());
            }
            this.setToolTipText(error);
        }
    }

    private String error(String value) {
        return Str.isEmpty(value) ? CaseUiMsg.ERROR_EMPTY_VALUE.getString() : (!this.existNameInCaseData(value) ? CaseUiMsg.ERROR_INVALID_DATA_NAME.getString() : null);
    }

    private boolean existNameInCaseData(String value) {
        boolean result = false;
        List dataList = this.casemgmt.getCaseData();
        if (!dataList.isEmpty()) {
            CaseData caseData = (CaseData)dataList.get(0);
            for (Data data : caseData) {
                if (Str.isEmpty(value) || !value.equals(data.getName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static interface Info {
        public boolean validateCaseDataName(int var1);
    }
}

