/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.catalog.CatalogType;

class CaseDataNameCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private Case casemgmt;
    private CaseDataNameType dataNameType;
    private NameCellRenderer nameCellRenderer;

    private CaseDataNameCellEditor(Case casemgmt) {
        super(new JComboBox());
        this.casemgmt = casemgmt;
        this.nameCellRenderer = new NameCellRenderer(casemgmt);
        this.getComponent().setRenderer(this.nameCellRenderer);
    }

    public static CaseDataNameCellEditor create(Case casemgmt) {
        return new CaseDataNameCellEditor(casemgmt);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.dataNameType = (CaseDataNameType)value;
        CaseDataNameType.TypeResolver typeResolver = this.dataNameType.getTypeResolver();
        CatalogType type = typeResolver != null ? typeResolver.getType(row) : null;
        this.nameCellRenderer.setType(type);
        this.populate(this.getComponent());
        return super.getTableCellEditorComponent(table, this.dataNameType.getName(), isSelected, row, column);
    }

    @Override
    public JComboBox getComponent() {
        return (JComboBox)super.getComponent();
    }

    @Override
    public Object getCellEditorValue() {
        String newName = (String)super.getCellEditorValue();
        this.dataNameType.setName(newName);
        return this.dataNameType;
    }

    private static CaseData getCaseData(Case casemgmt) {
        List caseDataList = casemgmt.getCaseData();
        return !caseDataList.isEmpty() ? (CaseData)caseDataList.get(0) : CaseFactory.createCaseData();
    }

    private void populate(JComboBox combo) {
        combo.removeAllItems();
        combo.addItem("");
        CaseData caseData = CaseDataNameCellEditor.getCaseData(this.casemgmt);
        for (Data data : caseData) {
            String name = data.getName();
            if (Str.isEmpty(name)) continue;
            combo.addItem(name);
        }
    }

    private static class NameCellRenderer
    extends DefaultListCellRenderer {
        private CaseData caseData;
        private Case casemgmt;
        private CatalogType type;
        public static final String EMPTY = " ";
        private static final Color DARK_GREEN = new Color(0, 192, 0);

        public NameCellRenderer(Case casemgmt) {
            this.casemgmt = casemgmt;
            this.caseData = CaseDataNameCellEditor.getCaseData(casemgmt);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = EMPTY;
            String name = (String)value;
            if (!Str.isEmpty(name)) {
                PropertyBundle bundle = this.casemgmt.getPropertyBundles().getDefault();
                String string = text = bundle.containsKey((Object)name) ? (String)bundle.get((Object)name) : "[" + name + "]";
                if (this.isValidData(name)) {
                    result.setForeground(DARK_GREEN);
                }
            }
            result.setText(text);
            return result;
        }

        public void setType(CatalogType type) {
            this.type = type;
        }

        private boolean isValidData(String name) {
            Data data;
            boolean result = false;
            if (this.type != null && (data = this.findData(name)) != null) {
                result = CaseManagementUtils.isCaseDataTypeAssignable((Data)data, (CatalogType)this.type);
            }
            return result;
        }

        private Data findData(String name) {
            for (Data data : this.caseData) {
                if (!Any.equals(data.getName(), name)) continue;
                return data;
            }
            return null;
        }
    }
}

