/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.CaseActivityNode;
import oracle.bpm.casemgmt.ui.ca.editor.AdvancedTabPanel;
import oracle.bpm.casemgmt.ui.ca.editor.GeneralTabPanel;
import oracle.bpm.casemgmt.ui.common.AbstractEntityEditor;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventListener;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.ide.Context;
import oracle.ide.Ide;

public class CaseActivityEditor
extends AbstractEntityEditor<CaseActivity> {
    private EventListener caseListener;
    private Case casemgmt;

    @Override
    public void open() {
        this.casemgmt = CaseUtils.getCase(this.getBpmProject());
        this.caseListener = new EventListener(){

            public void onEvent(Event ... events) {
                CaseActivityEditor.this.fireModelChanged(events);
            }
        };
        this.casemgmt.addListener(this.caseListener, new Attr[0]);
    }

    @Override
    public void close() {
        super.close();
        if (this.casemgmt != null && this.caseListener != null) {
            this.casemgmt.removeListener(this.caseListener, new Attr[0]);
        }
    }

    @Override
    protected CaseActivity getEntityModel(Context context) {
        CaseActivityNode node = (CaseActivityNode)context.getNode();
        return (CaseActivity)node.getEntityModel();
    }

    @Override
    protected boolean isValidModels() {
        boolean result = super.isValidModels();
        if (result) {
            Case casemgmt = CaseUtils.getCase(this.getBpmProject());
            result = casemgmt != null;
        }
        return result;
    }

    @Override
    protected void addTabs(TabbedPane tabbedPane) {
        CaseActivity caseActivity = (CaseActivity)this.getEntityModel();
        Project bpmProject = this.getBpmProject();
        String name = this.getName(bpmProject, caseActivity);
        FormGenContext formGenCtx = new FormGenContext(Ide.getActiveWorkspace(), this.casemgmt);
        Context jdevCtx = this.getContext();
        CaseActivityNode caNode = (CaseActivityNode)jdevCtx.getNode();
        formGenCtx.setBpmProject(jdevCtx.getProject());
        formGenCtx.setCaseActivityUrl(caNode.getURL());
        formGenCtx.setCaseActivity(caseActivity);
        formGenCtx.setCompositeName(bpmProject.getName());
        GeneralTabPanel generalTabPanel = new GeneralTabPanel(tabbedPane, bpmProject, caseActivity, name);
        generalTabPanel.setFormGenContext(formGenCtx);
        tabbedPane.addTab(CaseUiMsg.GENERAL, (UiComponent)generalTabPanel);
        tabbedPane.addTab(CaseUiMsg.ADVANCED, (UiComponent)AdvancedTabPanel.create(tabbedPane, bpmProject, caseActivity));
    }

    private String getName(Project bpmProject, CaseActivity caseActivity) {
        String result;
        Case casemgmt = CaseUtils.getCase(bpmProject);
        if (casemgmt != null) {
            PropertyBundle propertyBundle = casemgmt.getPropertyBundles().getDefault();
            result = (String)propertyBundle.get((Object)caseActivity.getName());
        } else {
            result = this.getHeaderName();
        }
        return result;
    }
}

