/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.Output;
import oracle.bpm.casemgmt.model.ca.OutputParameter;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellRenderer;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.ca.editor.ComponentOutputParametersPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.ProviderTableModel;

class BpmnOutputParametersPanelBuilder
extends ComponentOutputParametersPanelBuilder<NMEntry> {
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return BpmnOutputParametersPanelBuilder.this.getParameters();
        }
    };

    private BpmnOutputParametersPanelBuilder(CaseActivity caseActivity, Project project) {
        super(caseActivity, project);
    }

    public static BpmnOutputParametersPanelBuilder create(CaseActivity caseActivity, Project project) {
        return new BpmnOutputParametersPanelBuilder(caseActivity, project);
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] filteredEvents;
        block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    Object newValue = childEvent.getNewValue();
                    if (!(newValue instanceof Output)) continue block5;
                    Output output = (Output)newValue;
                    this.getTableModel().add(output);
                    continue block5;
                }
                case ATTR_REMOVED: {
                    Object oldValue = childEvent.getOldValue();
                    if (!(oldValue instanceof Output)) continue block5;
                    Output output = (Output)oldValue;
                    this.getTableModel().remove(output);
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.getTableModel().fireTableDataChanged();
                }
            }
        }
    }

    public NMParametersTableModel createTableModel() {
        return new NMParametersTableModel(this.getProject(), this.getCaseActivity(), this.getParameters());
    }

    public NMParametersTableModel getTableModel() {
        return (NMParametersTableModel)super.getTableModel();
    }

    @Override
    protected CaseDataNameCellRenderer.Info getRenderInfo() {
        return new CaseDataNameCellRenderer.Info(){

            @Override
            public boolean validateCaseDataName(int row) {
                NMEntry entry = (NMEntry)BpmnOutputParametersPanelBuilder.this.getTableModel().getRow(row);
                OutputParameter.NormalizedMessage parameter = entry.getOutputParameter();
                return parameter.isStoreData();
            }
        };
    }

    @Override
    protected Msg getRefreshMsg() {
        return CaseUiMsg.SYNC_BPMN_OUTPUT_PARAMETERS;
    }

    @Override
    protected OutputParameters createOutputParameters() {
        OutputParameters result = null;
        CaseActivity caseActivity = this.getCaseActivity();
        Activity activity = caseActivity.getActivity();
        Activity.Component component = activity.asComponent();
        ComponentInfo componentInfo = component.getComponentInfo();
        String referenceId = componentInfo.getReferenceId();
        String operation = componentInfo.getOperation();
        Project project = this.getProject();
        Process process = project.findProcess(referenceId);
        if (process != null) {
            CatchEvent catchEvent = CaseActivityUtils.getOperationByName((Process)process, (String)operation);
            if (catchEvent != null) {
                Case casemgmt = CaseUtils.getCase(project);
                result = CaseActivityUtils.createOutputParameters((Conversational)catchEvent, (Case)casemgmt);
            } else {
                String error = CaseModelMsg.INVALID_BPMN_OPERATION((String)referenceId, (String)process.getId(), (String)caseActivity.getName()).getString();
                JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_OUTPUT.getString(), 0);
            }
        } else {
            String error = CaseModelMsg.INVALID_BPMN_PROCESS((String)referenceId, (String)caseActivity.getName()).getString();
            JOptionPane.showMessageDialog(this.getEditor().asSwing(), error, CaseUiMsg.CASE_ACTIVITY_OUTPUT.getString(), 0);
        }
        return result;
    }

    private static class NMParametersTableModel
    extends ProviderTableModel<NMEntry> {
        private final CaseActivity caseActivity;
        private final Project project;
        private CaseDataNameType.TypeResolver typeResolver;

        public NMParametersTableModel(Project project, CaseActivity caseActivity, OutputParameters parameters) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.SAVE_OUTPUT_AS_CASE_DATA, CaseUiMsg.CASE_DATA_NAME));
            this.project = project;
            this.caseActivity = caseActivity;
            this.populate(parameters);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            NMEntry entry = (NMEntry)this.getRow(row);
            OutputParameter.NormalizedMessage parameter = entry.getOutputParameter();
            return column == 1 || column == 2 && parameter.isStoreData();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            NMEntry entry = (NMEntry)this.getRow(row);
            OutputParameter.NormalizedMessage parameter = entry.getOutputParameter();
            switch (column) {
                case 0: {
                    parameter.setParamName((String)value);
                    break;
                }
                case 1: {
                    parameter.setStoreData(((Boolean)value).booleanValue());
                    break;
                }
                case 2: {
                    CaseDataNameType dataNameType = (CaseDataNameType)value;
                    parameter.setDataName(dataNameType.getName());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            Class result;
            switch (column) {
                case 1: {
                    result = Boolean.class;
                    break;
                }
                case 2: {
                    result = CaseDataNameType.class;
                    break;
                }
                default: {
                    result = String.class;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            NMEntry entry = (NMEntry)this.getRow(row);
            OutputParameter.NormalizedMessage parameter = entry.getOutputParameter();
            Object result = "";
            switch (column) {
                case 0: {
                    result = parameter.getParamName();
                    break;
                }
                case 1: {
                    result = parameter.isStoreData();
                    break;
                }
                case 2: {
                    result = CaseDataNameType.create(parameter.getDataName(), this.getTypeResolver());
                }
            }
            return result;
        }

        public void add(Output output) {
            for (OutputParameter value : output) {
                if (!value.getType().isNormalizedMessage()) continue;
                NMEntry entry = NMEntry.create(output, value.asNormalizedMessage());
                this.addRow(entry);
            }
        }

        public void remove(Output output) {
            List<NMEntry> entries = this.getEntriesFor(output);
            for (NMEntry entry : entries) {
                this.removeRow(entry);
            }
        }

        private CaseDataNameType.TypeResolver getTypeResolver() {
            if (this.typeResolver == null) {
                this.typeResolver = new CaseDataNameType.TypeResolver(){

                    @Override
                    public CatalogType getType(int row) {
                        CatalogType result = null;
                        ComponentInfo componentInfo = NMParametersTableModel.this.caseActivity.getActivity().toBpmn().getComponentInfo();
                        CatchEvent conversational = CaseActivityUtils.getOperationByName((Project)NMParametersTableModel.this.project, (ComponentInfo)componentInfo);
                        if (conversational != null) {
                            NMEntry entry = (NMEntry)NMParametersTableModel.this.getRow(row);
                            Output output = entry.getOutput();
                            String endPoint = output.getEndPoint();
                            String operationName = output.getOperationName();
                            CaseActivityUtils.OutputDeclarations outputDeclarations = CaseActivityUtils.getOutputDeclarations((Conversational)conversational);
                            Sequence declarations = outputDeclarations.getDeclarations(operationName, endPoint);
                            OutputParameter.NormalizedMessage parameter = entry.getOutputParameter();
                            String paramName = parameter.getParamName();
                            result = CaseActivityUtils.getCatalogTypeByName((Sequence)declarations, (String)paramName);
                        }
                        return result;
                    }
                };
            }
            return this.typeResolver;
        }

        private void populate(OutputParameters parameters) {
            this.removeAllElements();
            for (Output output : parameters) {
                this.add(output);
            }
        }

        private List<NMEntry> getEntriesFor(Output output) {
            ArrayList<NMEntry> result = new ArrayList<NMEntry>();
            List data = this.getData();
            for (NMEntry entry : data) {
                if (output != entry.getOutput()) continue;
                result.add(entry);
            }
            return result;
        }
    }

    public static class NMEntry {
        private final Output output;
        private final OutputParameter.NormalizedMessage outputParameter;

        public NMEntry(Output output, OutputParameter.NormalizedMessage outputParameter) {
            this.output = output;
            this.outputParameter = outputParameter;
        }

        public static NMEntry create(Output output, OutputParameter.NormalizedMessage outputParameter) {
            return new NMEntry(output, outputParameter);
        }

        public Output getOutput() {
            return this.output;
        }

        public OutputParameter.NormalizedMessage getOutputParameter() {
            return this.outputParameter;
        }
    }
}

