/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.ui.ca.editor.ComponentInfoPanelBuilder;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiError;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;

class AdvancedTabPanel {
    private AdvancedTabPanel() {
    }

    public static AbstractEntityPanel create(UiContainer parent, Project project, CaseActivity caseActivity) {
        return caseActivity.getActivity().getType().isComponent() ? new ComponentAdvancedTabPanel(parent, project, caseActivity) : new CustomAdvancedTabPanel(parent, caseActivity);
    }

    private static class CustomAdvancedTabPanel
    extends AbstractEntityPanel<CaseActivity> {
        private CustomInfoPanelBuilder infoPanel;

        public CustomAdvancedTabPanel(UiContainer parent, CaseActivity caseActivity) {
            super(parent, caseActivity);
            this.init();
        }

        @Override
        public void modelChanged(Event ... events) {
            this.infoPanel.modelChanged(events);
        }

        private void init() {
            CaseActivity caseActivity = (CaseActivity)this.getEntityModel();
            Activity activity = caseActivity.getActivity();
            this.setLayout(new MigLayout("fillx, width max(100,50%), gapx 8, gapy 6, ins 8"));
            this.infoPanel = CustomInfoPanelBuilder.create(activity.toCustom());
            this.add(this.infoPanel.build(this), "growx");
        }

        private static class CustomInfoPanelBuilder
        extends HeaderPanelBuilder
        implements EntityEvents {
            private Activity.Custom activity;
            private static final int COLUMNS = 40;
            private static final UiError NO_ERROR = null;

            private CustomInfoPanelBuilder(Activity.Custom activity) {
                super(CaseUiMsg.CUSTOM_ACTIVITY_INFO, CaseUiMsg.CUSTOM_ACTIVITY_INFO_DESCRIPTION);
                this.activity = activity;
            }

            public static CustomInfoPanelBuilder create(Activity.Custom activity) {
                return new CustomInfoPanelBuilder(activity);
            }

            @Override
            public void modelChanged(Event ... events) {
            }

            @Override
            protected UiComponent buildEditor(UiContainer parent) {
                Panel result = new Panel(parent);
                String className = this.activity.getClassName();
                final TextField classNameTextField = new TextField((UiContainer)result, className, 40);
                classNameTextField.addDocumentListener(new DocumentListener.Default(){

                    @Override
                    public void anyUpdate(DocumentEvent e) {
                        String text = classNameTextField.getText();
                        CustomInfoPanelBuilder.this.activity.setClassName(text);
                        UiError error = !Str.isEmpty(text) ? NO_ERROR : UiError.createError(CaseUiMsg.INVALID_CLASS_NAME.getString());
                        classNameTextField.setError(error);
                    }
                });
                result.setLayout(new MigLayout("gapy 6, gapx 8, ins 0"));
                result.add(Label.create((UiContainer)result, CaseUiMsg.CLASS_NAME));
                result.add(classNameTextField, "wrap");
                return result;
            }
        }
    }

    private static class ComponentAdvancedTabPanel
    extends AbstractEntityPanel<CaseActivity> {
        private ComponentInfoPanelBuilder infoPanel;

        public ComponentAdvancedTabPanel(UiContainer parent, Project project, CaseActivity caseActivity) {
            super(parent, caseActivity);
            this.init(project);
        }

        @Override
        public void modelChanged(Event ... events) {
            this.infoPanel.modelChanged(events);
        }

        private void init(Project project) {
            CaseActivity caseActivity = (CaseActivity)this.getEntityModel();
            Activity activity = caseActivity.getActivity();
            this.setLayout(new MigLayout("fillx, width max(100,50%), gapx 8, gapy 6, ins 8"));
            this.infoPanel = ComponentInfoPanelBuilder.create(project, activity.asComponent());
            this.add(this.infoPanel.build(this), "growx");
        }
    }
}

