/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca.editor;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellEditor;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameCellRenderer;
import oracle.bpm.casemgmt.ui.ca.editor.CaseDataNameType;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.common.NoEmptyStringTableCellRenderer;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.peer.swing.SwingTable;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;
import org.jetbrains.annotations.Nullable;

abstract class AbstractInputParametersPanelBuilder
extends TableHeaderPanelBuilder<InputParameter>
implements EntityEvents {
    private InputParameters parameters;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return AbstractInputParametersPanelBuilder.this.parameters;
        }
    };
    private Project project;

    protected AbstractInputParametersPanelBuilder(InputParameters parameters, Project project) {
        super(CaseUiMsg.CASE_ACTIVITY_INPUT);
        this.parameters = parameters;
        this.project = project;
    }

    public ParametersTableModel getTableModel() {
        return (ParametersTableModel)super.getTableModel();
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] filteredEvents;
        block5: for (Event event : filteredEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    this.addToModel((InputParameter)childEvent.getNewValue());
                    continue block5;
                }
                case ATTR_REMOVED: {
                    this.getTableModel().removeRow((InputParameter)childEvent.getOldValue());
                    continue block5;
                }
                case ATTR_CHANGED: {
                    this.tableModelChanged();
                }
            }
        }
    }

    protected Project getProject() {
        return this.project;
    }

    protected InputParameters getParameters() {
        return this.parameters;
    }

    @Override
    protected void customizeTable(GenericTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column0 = columnModel.getColumn(0);
        column0.setCellRenderer(NoEmptyStringTableCellRenderer.INSTANCE);
        TableColumn column1 = columnModel.getColumn(1);
        column1.setCellEditor(InputParameterTypeTableCellEditor.INSTANCE);
        column1.setCellRenderer(InputParameterTypeTableCellRenderer.INSTANCE);
        AbstractInputParametersPanelBuilder.setColumnSize(column1, 100);
        TableColumn column2 = columnModel.getColumn(2);
        column2.setCellRenderer(StoreDataCellRenderer.create());
        AbstractInputParametersPanelBuilder.setColumnSize(column2, 170);
        TableColumn column3 = columnModel.getColumn(3);
        Case casemgmt = CaseUtils.getCase(this.project);
        column3.setCellEditor(CaseDataNameCellEditor.create(casemgmt));
        column3.setCellRenderer(CaseDataNameCellRenderer.create(casemgmt, this.getRenderInfo()));
        AbstractInputParametersPanelBuilder.setColumnSize(column3, 250);
    }

    protected CaseDataNameCellRenderer.Info getRenderInfo() {
        return new CaseDataNameCellRenderer.Info(){

            @Override
            public boolean validateCaseDataName(int row) {
                InputParameter parameter = (InputParameter)AbstractInputParametersPanelBuilder.this.getTableModel().getRow(row);
                InputParameterType type = parameter.getType();
                return type.isCaseData() || parameter.toPayload().isStoreData();
            }
        };
    }

    private static class StoreDataCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer emptyCellRenderer = new DefaultTableCellRenderer();

        private StoreDataCellRenderer() {
        }

        public static StoreDataCellRenderer create() {
            return new StoreDataCellRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result;
            SwingTable.SwingTableModel swingModel = (SwingTable.SwingTableModel)table.getModel();
            ParametersTableModel model = (ParametersTableModel)swingModel.getTableModel();
            InputParameter parameter = (InputParameter)model.getRow(row);
            if (parameter.getType().isCaseData()) {
                result = this.emptyCellRenderer.getTableCellRendererComponent(table, CaseUiMsg.NO_VALID.getString(), isSelected, hasFocus, row, column);
                result.setForeground(Color.LIGHT_GRAY);
                ((JLabel)result).setHorizontalAlignment(0);
            } else {
                TableCellRenderer render = table.getDefaultRenderer(Boolean.class);
                result = render.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return result;
        }
    }

    private static class InputParameterTypeTableCellRenderer
    extends DefaultTableCellRenderer {
        public static InputParameterTypeTableCellRenderer INSTANCE = new InputParameterTypeTableCellRenderer();

        private InputParameterTypeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setText(((InputParameterType)value).getString());
            return result;
        }
    }

    private static class InputParameterTypeTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public static InputParameterTypeTableCellEditor INSTANCE = new InputParameterTypeTableCellEditor();

        private InputParameterTypeTableCellEditor() {
            super(new JComboBox<InputParameterType>(InputParameterType.values()));
            this.getComponent().setRenderer(new IdentityTypeCellRenderer());
        }

        @Override
        public JComboBox getComponent() {
            return (JComboBox)super.getComponent();
        }

        private static class IdentityTypeCellRenderer
        extends DefaultListCellRenderer {
            private IdentityTypeCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                result.setText(((InputParameterType)value).getString());
                return result;
            }
        }
    }

    protected static class ParametersTableModel
    extends ProviderTableModel<InputParameter> {
        private Activity.Type activityType;
        private CaseDataNameType.TypeResolver typeResolver;
        private static final int COLUMN_NAME = 0;
        protected static final int COLUMN_TYPE = 1;
        private static final int COLUMN_STORE_DATA = 2;
        private static final int COLUMN_CASE_DATA_NAME = 3;

        public ParametersTableModel(Activity.Type type, InputParameters events, @Nullable CaseDataNameType.TypeResolver typeResolver) {
            super(MsgList.create(CoreMsg.NAME, CaseUiMsg.SOURCE, CaseUiMsg.SAVE_INPUT_IN_CASE, CaseUiMsg.CASE_DATA_NAME));
            this.activityType = type;
            this.typeResolver = typeResolver;
            this.populate(events);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            InputParameter parameter = (InputParameter)this.getRow(row);
            InputParameterType type = parameter.getType();
            boolean column0 = column == 0 && this.activityType.isCustom();
            boolean column1 = column == 1;
            boolean column2 = column == 2 && type.isPayload();
            boolean column3 = column == 3 && (type.isCaseData() || type.isPayload() && parameter.toPayload().isStoreData());
            return column0 || column1 || column2 || column3;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            InputParameter parameter = (InputParameter)this.getRow(row);
            switch (column) {
                case 0: {
                    parameter.setParamName((String)value);
                    break;
                }
                case 1: {
                    InputParameterType newType = (InputParameterType)value;
                    if (newType.isCaseData()) {
                        parameter.toCaseData();
                        break;
                    }
                    parameter.toPayload();
                    break;
                }
                case 2: {
                    if (!parameter.getType().isPayload()) break;
                    InputParameter.Payload payloadData = parameter.toPayload();
                    payloadData.setStoreData(((Boolean)value).booleanValue());
                    break;
                }
                case 3: {
                    CaseDataNameType dataNameType = (CaseDataNameType)value;
                    parameter.setDataName(dataNameType.getName());
                }
            }
        }

        @Override
        public Class getColumnClass(int column) {
            Class result = null;
            switch (column) {
                case 0: {
                    result = String.class;
                    break;
                }
                case 1: {
                    result = InputParameterType.class;
                    break;
                }
                case 2: {
                    result = Boolean.class;
                    break;
                }
                case 3: {
                    result = CaseDataNameType.class;
                }
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = null;
            InputParameter parameter = (InputParameter)this.getRow(row);
            switch (column) {
                case 0: {
                    result = parameter.getParamName();
                    break;
                }
                case 1: {
                    result = parameter.getType();
                    break;
                }
                case 2: {
                    result = false;
                    if (!parameter.getType().isPayload()) break;
                    InputParameter.Payload payloadData = parameter.toPayload();
                    result = payloadData.isStoreData();
                    break;
                }
                case 3: {
                    result = CaseDataNameType.create(parameter.getDataName(), this.typeResolver);
                }
            }
            return result;
        }

        private void populate(InputParameters parameters) {
            this.removeAllElements();
            for (InputParameter parameter : parameters) {
                this.addRow(parameter);
            }
        }
    }
}

