/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.ca;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.ui.common.AbstractEntityNode;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.Image;
import oracle.ide.net.URLFileSystem;

public class CaseActivityNode
extends AbstractEntityNode<CaseActivity> {
    private ProjectCaseActivity projectCaseActivity;
    public static final Icon ICON = Image.create(CaseUiMsg.CASE_ACTIVITY).asSwingIcon();

    public Icon getIcon() {
        return ICON;
    }

    @Override
    protected void saveEntityModel() throws IOException {
        try {
            if (this.projectCaseActivity != null) {
                this.getBpmProject().getWriter().write(new ProjectObject[]{this.projectCaseActivity});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            String error = message != null ? "\n\n" + message : "";
            throw new IOException("Exception saving Case Activity " + this.getLongLabel() + "\n" + error, e);
        }
    }

    @Override
    protected void revertEntityModel() {
        ProjectLoader loader = this.getBpmProject().getLoader();
        if (loader != null) {
            try {
                ProjectObject newProjectCase = loader.replaceProjectObject((ProjectObject)this.projectCaseActivity);
                this.projectCaseActivity = (ProjectCaseActivity)newProjectCase;
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected CaseActivity loadEntityModel() throws IOException {
        CaseActivity result = null;
        try {
            URL url = this.getURL();
            String name = URLFileSystem.getName((URL)url);
            ProjectCase projectCase = this.getBpmProject().getCase();
            if (projectCase != null) {
                this.projectCaseActivity = projectCase.findCaseActivity(name);
                result = this.projectCaseActivity.getCaseActivity();
            }
        }
        catch (Exception e) {
            throw new IOException("Exception loading " + this.getLongLabel(), e);
        }
        return result;
    }
}

