/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.ui.cm.CaseNode;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.casemgmt.CaseActivityContainer;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import org.jetbrains.annotations.Nullable;

public class CaseUtils {
    public static final int SCA_COMPONENT_NAME_SIZE = 80;
    private static final URLFilter CASE_FILTER = new URLFilter(){

        public boolean accept(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            return ".case".equals(suffix);
        }
    };

    private CaseUtils() {
    }

    public static oracle.bpm.project.model.Project getBpmProject(Project project) {
        JdevRepositoryService service = JdevRepositoryService.getInstance();
        return service.getProject(project);
    }

    public static boolean existCase(Project project) {
        return CaseUtils.getCaseUrl(project) != null;
    }

    @Nullable
    public static URL getCaseUrl(Project project) {
        URL projectUrl;
        URL result = null;
        if (project != null && (result = CaseUtils.getCaseUrlInFolder(projectUrl = URLFileSystem.getParent((URL)project.getURL()))) == null) {
            URL caseFolderUrl = URLFactory.newURL((URL)projectUrl, (String)"case");
            result = CaseUtils.getCaseUrlInFolder(caseFolderUrl);
        }
        return result;
    }

    public static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }

    @Nullable
    public static Case getCase(oracle.bpm.project.model.Project bpmProject) {
        ProjectCase projectCase = bpmProject.getCase();
        return projectCase != null ? projectCase.getCase() : null;
    }

    public static ProjectCaseActivity createProjectCaseActivity(Project project, CaseActivityInfo caseActivityInfo) throws ProjectException {
        CaseActivityContainer caseActivityContainer;
        oracle.bpm.project.model.Project bpmProject = CaseUtils.getBpmProject(project);
        CaseContainer caseContainer = bpmProject.getCaseContainer();
        if (caseContainer == null) {
            caseContainer = bpmProject.createCaseContainer();
            bpmProject.addChild((ProjectObject)caseContainer);
        }
        if ((caseActivityContainer = caseContainer.getCaseActivityContainer()) == null) {
            caseActivityContainer = caseContainer.createCaseActivityContainer();
            caseContainer.addChild((ProjectObject)caseActivityContainer);
        }
        CaseActivity caseActivity = caseActivityInfo.getCaseActivity();
        ProjectCaseActivity projectCaseActivity = caseActivityContainer.createProjectCaseActivity(caseActivity);
        caseActivityContainer.addChild((ProjectObject)projectCaseActivity);
        ProjectCase projectCase = bpmProject.getCase();
        if (projectCase != null) {
            Case casemgmt = projectCase.getCase();
            PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
            String key = caseActivity.getName();
            String value = caseActivityInfo.getDisplayName();
            bundle.put((Object)key, (Object)value);
        }
        URL url = CaseUtils.adaptTo(projectCase, URL.class);
        try {
            Node node = NodeFactory.findOrCreate(CaseNode.class, (URL)url);
            node.markDirty(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectCaseActivity;
    }

    public static void paintHorizontalSquiggleLine(Graphics g, Component component, String text) {
        int xStart;
        Font f = component.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(f);
        int descent = fontMetrics.getDescent();
        int strWidth = fontMetrics.stringWidth(text == null ? "" : text);
        Rectangle b = component.getBounds();
        int squiggleWidth = strWidth > 0 ? strWidth : 50;
        Rectangle r = new Rectangle(0, b.height - descent, squiggleWidth, 2);
        g.setColor(Color.RED);
        int x = r.x;
        while ((double)x < r.getX() + r.getWidth() && !((double)(xStart = x + 2) > r.getX() + r.getWidth())) {
            g.drawLine(x, r.y + r.height, xStart, r.y);
            int xEnd = x + 4;
            if ((double)xEnd > r.getX() + r.getWidth()) {
                xEnd = r.x + r.width;
            }
            g.drawLine(x + 2, r.y, xEnd, r.y + r.height);
            x += 4;
        }
    }

    public static List<CatalogType> getPrimitiveTypes() {
        ArrayList<CatalogType> primitiveTypes = new ArrayList<CatalogType>();
        primitiveTypes.add(CatalogType.Default.getString());
        primitiveTypes.add(CatalogType.Default.getInt((int)64));
        primitiveTypes.add(CatalogType.Default.getBool());
        primitiveTypes.add(CatalogType.Default.getDecimal());
        primitiveTypes.add(CatalogType.Default.getReal());
        primitiveTypes.add(CatalogType.Default.getTime());
        primitiveTypes.add(CatalogType.Default.getInterval());
        primitiveTypes.add(CatalogType.Default.getBinary());
        return primitiveTypes;
    }

    public static Sequence<CatalogType> getTypes(oracle.bpm.project.model.Project project) {
        List<CatalogType> primitiveTypes = CaseUtils.getPrimitiveTypes();
        Sequence catalogTypes = (Sequence)Cast.force(ProjectFilters.BPM_OBJECTS_ONLY.getChildren((ProjectObjectContainer)project.getCatalogRoot()));
        return CollectionUtils.concat(primitiveTypes, catalogTypes);
    }

    @Nullable
    public static CatalogType findCatalogType(oracle.bpm.project.model.Project project, Data value) {
        CatalogType result = null;
        Sequence<CatalogType> catalogTypes = CaseUtils.getTypes(project);
        for (CatalogType type : catalogTypes) {
            if (!CaseManagementUtils.isCaseDataTypeEquivalent((Data)value, (CatalogType)type)) continue;
            result = type;
            break;
        }
        return result;
    }

    @Nullable
    private static URL getCaseUrlInFolder(URL url) {
        URL[] list;
        URL result = null;
        if (URLFileSystem.exists((URL)url) && (list = URLFileSystem.list((URL)url, (URLFilter)CASE_FILTER)) != null && list.length > 0) {
            result = list[0];
        }
        return result;
    }
}

