/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.util.swing;

import oracle.bpm.connector.msg.ConnectorMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.ui.monitor.ProgressMonitorGUI;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.ui.wizards.ui.WorkerListener;

public abstract class ProgressStepPanel
extends WizardStepPanel
implements WorkerListener {
    private ProgressMonitorGUI monitor_d;
    private boolean nextWasEnabled = true;

    public ProgressStepPanel(UiContainer parent, WizardStep wizardStep) {
        super(parent, wizardStep);
    }

    public ProgressMonitorGUI getMonitor() {
        ProgramException.assertNotNull((Object)this.monitor_d, (String)("Cannot access ProgressMonitor before it's created through WizardStepPanel.createProgressPage()\nSee " + WizardStepPanel.class.getName() + ".build()"));
        return this.monitor_d;
    }

    @Override
    public void finished(Throwable throwable) {
        ProgressMonitorGUI monitor = this.getMonitor();
        monitor.progress(-2);
        this.removeMonitorGUI();
        Button nextButton = this.getWizardStep().getNextButton();
        if (throwable != null) {
            nextButton.setEnabled(false);
            System.out.println("Error ..." + throwable);
            throwable.printStackTrace();
            this.setPageTitle(CoreMsg.ERROR);
            this.setPageDesc(ConnectorMsg.ERROR_DETAIL);
            this.showError(throwable);
        } else {
            nextButton.setEnabled(this.nextWasEnabled);
        }
    }

    public void started(Msg phaseName) {
        this.showProgress();
        ProgressMonitorGUI monitor = this.getMonitor();
        monitor.phase(phaseName);
        monitor.progress(-1);
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Button nextButton = ProgressStepPanel.this.getWizardSupport().getNextButton();
                ProgressStepPanel.this.nextWasEnabled = nextButton.isEnabled();
                nextButton.setEnabled(false);
            }
        });
    }

    @Override
    protected UiComponent createProgressPage(UiContainer container) {
        this.monitor_d = ProgressMonitorBuilder.createSimpleBuilder(container).buildProgressMonitor(container);
        this.monitor_d.progress(this.isProgressDeterminable() ? 0 : -1);
        return this.monitor_d;
    }

    protected boolean isProgressDeterminable() {
        return false;
    }

    private void removeMonitorGUI() {
        int index;
        int componentCount = this.getComponentCount();
        boolean found = false;
        for (index = 0; index < componentCount; ++index) {
            UiComponent component = this.getComponent(index);
            if (!(component instanceof ProgressMonitorGUI)) continue;
            found = true;
            break;
        }
        if (found) {
            this.remove(index);
        }
    }
}

