/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.connector.impl.UddiRegistryConfiguration;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;

public class UddiRegistryConfigurationEditor
extends AbstractConfigurationEditor {
    private TextField inquiryPathField;
    private PasswordField passwordField;
    private TextField publishPathField;
    private TextField securityPathField;
    private ComboBox serverConnectorComboBox;
    private TextField userField;

    public UddiRegistryConfigurationEditor(UiContainer parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        Panel fieldsPanel = new Panel(this);
        fieldsPanel.setLayout(new GridBagLayout());
        this.serverConnectorComboBox = UiFactory.createComboBox(fieldsPanel);
        this.inquiryPathField = new TextField(fieldsPanel);
        this.inquiryPathField.addDocumentListener(this.createDocumentListener());
        this.publishPathField = new TextField(fieldsPanel);
        this.publishPathField.addDocumentListener(this.createDocumentListener());
        this.securityPathField = new TextField(fieldsPanel);
        this.securityPathField.addDocumentListener(this.createDocumentListener());
        this.userField = new TextField(fieldsPanel);
        this.userField.addDocumentListener(this.createDocumentListener());
        this.passwordField = new PasswordField(fieldsPanel);
        this.passwordField.addDocumentListener(this.createDocumentListener());
        this.layoutComponents(fieldsPanel);
        this.add(fieldsPanel, "North");
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        UddiRegistryConfiguration bean = (UddiRegistryConfiguration)configurationEditorBean;
        this.serverConnectorComboBox.setSelectedItem(bean.getServerConnector());
        this.serverConnectorComboBox.addItemListener(this.createItemListener());
        this.inquiryPathField.setText(bean.getInquiryPath());
        this.publishPathField.setText(bean.getPublishPath());
        this.securityPathField.setText(bean.getSecurityPath());
        this.userField.setText(bean.getUser());
        this.passwordField.setText(bean.getPassword());
    }

    public void synchronizeBean() {
        UddiRegistryConfiguration bean = (UddiRegistryConfiguration)this.getEditorBean();
        String serverConnectorName = (String)this.serverConnectorComboBox.getSelectedItem();
        bean.setServerConnector(serverConnectorName);
        bean.setInquiryPath(this.inquiryPathField.getText());
        bean.setPublishPath(this.publishPathField.getText());
        bean.setSecurityPath(this.securityPathField.getText());
        bean.setUser(this.userField.getText());
        bean.setPassword(this.passwordField.getText());
    }

    @Override
    protected ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UddiRegistryConfigurationEditor.this.firePropertiesChanged();
            }
        };
    }

    private void layoutComponents(Panel fieldsPanel) {
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.SERVER_CONNECTOR), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.serverConnectorComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.UDDI_INQUIRY_PATH), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.inquiryPathField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.UDDI_PUBLISH_PATH), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.publishPathField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.UDDI_SECURITY_PATH), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.securityPathField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.USER), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.userField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.PASSWORD), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.passwordField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
    }
}

