/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.connector.SecureMailConnectionType;
import oracle.bpm.connector.impl.MailConfigurationBean;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;

public abstract class MailConfigurationEditorPanel
extends AbstractConfigurationEditor {
    private final Panel fieldsPanel;
    private PasswordField passwordField;
    private ComboBox secureConnectionTypeCombo;
    private TextField serverHostField;
    private NumericField<Integer> serverPortField;
    private TextField usernameField;

    protected MailConfigurationEditorPanel(UiContainer parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.fieldsPanel = new Panel(this);
        this.getFieldsPanel().setLayout(new GridBagLayout());
        DocumentListener documentListener = this.createDocumentListener();
        this.serverHostField = new TextField(this.fieldsPanel);
        this.serverHostField.addDocumentListener(documentListener);
        NumericField<Integer> portField = NumericField.createIntegerNumericField(this.fieldsPanel, false);
        portField.setGroupingUsed(false);
        portField.setRange(1, Integer.MAX_VALUE);
        portField.setColumns(6);
        portField.addDocumentListener(documentListener);
        this.setServerPortField(portField);
        this.usernameField = new TextField(this.fieldsPanel);
        this.usernameField.addDocumentListener(documentListener);
        this.passwordField = new PasswordField(this.fieldsPanel);
        this.passwordField.addDocumentListener(documentListener);
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        MailConfigurationBean bean = (MailConfigurationBean)configurationEditorBean;
        this.serverHostField.setText(bean.getServerHost());
        this.getServerPortField().setText(bean.getServerPort());
        this.usernameField.setText(bean.getUserName());
        this.passwordField.setText(bean.getPassword());
        this.getSecureConnectionTypeCombo().setSelectedItem(SecureMailConnectionType.valueOf((String)bean.getSecureConnectionType()));
    }

    public void synchronizeBean() {
        MailConfigurationBean bean = (MailConfigurationBean)this.getEditorBean();
        bean.setServerHost(this.serverHostField.getText());
        bean.setServerPort(this.getServerPortField().getText());
        bean.setUserName(this.usernameField.getText());
        bean.setPassword(this.passwordField.getText());
        bean.setSecureConnectionType(this.getSecureConnectionTypeCombo().getSelectedItem().toString());
    }

    public TextField getServerPortField() {
        return this.serverPortField;
    }

    public void setServerPortField(NumericField<Integer> serverPortField) {
        this.serverPortField = serverPortField;
    }

    public ComboBox getSecureConnectionTypeCombo() {
        return this.secureConnectionTypeCombo;
    }

    public void setSecureConnectionTypeCombo(ComboBox secureConnectionTypeCombo) {
        this.secureConnectionTypeCombo = secureConnectionTypeCombo;
    }

    public final Panel getFieldsPanel() {
        return this.fieldsPanel;
    }

    protected void layoutComponents() {
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.MAIL_SERVER_HOST), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.serverHostField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.MAIL_SERVER_PORT), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.getServerPortField(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.USER), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.usernameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.PASSWORD), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.MAIL_SECURE_CONNECTION_TYPE), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.getSecureConnectionTypeCombo(), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
    }
}

