/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.connector.impl.LocalJ2EEConfiguration;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;

public class LocalJ2EEConfigurationEditor
extends AbstractConfigurationEditor {
    private TextField transactionField;

    public LocalJ2EEConfigurationEditor(UiContainer parent) {
        super(parent);
        RelativeLayout layout = new RelativeLayout();
        Panel panel = new Panel(this);
        panel.setLayout(layout);
        this.transactionField = new TextField((UiContainer)panel, 30);
        Label label = Label.create((UiContainer)panel, LibMsg.USER_TRANSACTION);
        panel.add(label, "label");
        panel.add(this.transactionField, "transactionField");
        Layout.fixToRoot(layout, "label", AttributeType.TOP, 5);
        Layout.fixToRoot(layout, "label", AttributeType.LEFT, 2);
        Layout.fixToRoot(layout, "transactionField", AttributeType.TOP, 5);
        Layout.fixToComp(layout, "transactionField", AttributeType.LEFT, "label", AttributeType.RIGHT, 2);
        DocumentListener documentListener = this.createDocumentListener();
        this.transactionField.addDocumentListener(documentListener);
        this.add(panel);
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        LocalJ2EEConfiguration bean = (LocalJ2EEConfiguration)configurationEditorBean;
        this.transactionField.setText(bean.getUserTransactionLookupName());
    }

    public void synchronizeBean() {
        LocalJ2EEConfiguration bean = (LocalJ2EEConfiguration)this.getEditorBean();
        bean.setUserTransactionLookupName(this.transactionField.getText());
    }
}

