/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.io.File;
import oracle.bpm.configuration.editor.AbstractPoolConfigurationEditor;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.impl.JNDIConfiguration;
import oracle.bpm.connector.impl.JNDIFactory;
import oracle.bpm.connector.msg.ConnectorMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.FileFilter;

public class JNDIConfigurationEditor
extends AbstractPoolConfigurationEditor {
    private TextField contextField;
    private PasswordField credentialsField;
    private boolean isGenericLDAPConfiguration;
    private TextField principalField;
    private TextField propertiesTextField;
    private ComboBox referralCombo;
    private TextField urlField;

    public JNDIConfigurationEditor(UiContainer parent) {
        this(parent, false);
    }

    public JNDIConfigurationEditor(UiContainer parent, boolean isGenericLdapConfiguration) {
        super(parent);
        this.setGenericLDAPConfiguration(isGenericLdapConfiguration);
        Panel basicPanel = this.getBasicPanel(this.tabbedPane);
        this.addTab(UIMsg.BASIC, basicPanel);
        this.addPropertiesPanel();
        this.addRuntimeTab();
    }

    public void setGenericLDAPConfiguration(boolean genericLDAPConfiguration) {
        this.isGenericLDAPConfiguration = genericLDAPConfiguration;
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        String referral;
        super.setConfigurationEditorBean(configurationEditorBean);
        JNDIConfiguration bean = (JNDIConfiguration)configurationEditorBean;
        this.databasePropertiesPanel.add(bean.getAdditionalProperties());
        this.databasePropertiesPanel.setDefaultProperties(bean.getDefaultConnectionProperties());
        this.contextField.setText(bean.getContextFactory());
        this.urlField.setText(bean.getUrl());
        this.principalField.setText(bean.getPrincipal());
        this.credentialsField.setText(bean.getCredentials());
        if (this.isGenericLDAPConfiguration) {
            this.propertiesTextField.setText(bean.getLdapDirectoryProperty());
        }
        if ((referral = bean.getReferral()) == null || "".equals(referral)) {
            this.referralCombo.setSelectedIndex(0);
        } else {
            this.referralCombo.setSelectedItem(referral);
        }
    }

    @Override
    public void synchronizeBean() {
        super.synchronizeBean();
        JNDIConfiguration bean = (JNDIConfiguration)this.getEditorBean();
        bean.setContextFactory(this.contextField.getText());
        bean.setUrl(this.urlField.getText());
        bean.setPrincipal(this.principalField.getText());
        bean.setCredentials(String.valueOf(this.credentialsField.getPassword()));
        bean.setReferral((String)(this.referralCombo.getSelectedItem() == null ? this.referralCombo.getItemAt(0) : this.referralCombo.getSelectedItem()));
        bean.getAdditionalProperties().clear();
        bean.setAdditionalProperties(this.databasePropertiesPanel.getVisualProperties());
        if (this.isGenericLDAPConfiguration) {
            bean.setLdapDirectoryProperty(this.propertiesTextField.getText());
        }
    }

    @Override
    public void validateInput() throws InvalidConfigurationException {
        if ("".equals(this.contextField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed((Msg)LibMsg.INITIAL_CONTEXT_FACTORY_EMPTY);
        }
        if ("".equals(this.urlField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed((Msg)LibMsg.URL_EMPTY);
        }
        if (this.isGenericLDAPConfiguration && "".equals(this.propertiesTextField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed((Msg)ConnectorMsg.PROPERTIES_URL_EMPTY);
        }
    }

    private Panel getBasicPanel(UiContainer parent) {
        String colSpecs = "5dlu,100dlu,5dlu,110dlu,5dlu,50dlu,5dlu";
        String rowSpecs = "5dlu,pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 20dlu, pref";
        Panel panel = new Panel(parent);
        FormLayout layout = new FormLayout("5dlu,100dlu,5dlu,110dlu,5dlu,50dlu,5dlu", "5dlu,pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 20dlu, pref");
        PanelBuilder builder = layout.createBuilder(panel);
        Label factoryLabel = Label.create((UiContainer)panel, LibMsg.JNDI_CTX_FACTORY);
        Label urlLabel = Label.create((UiContainer)panel, LibMsg.JNDI_URL);
        Label principalLabel = Label.create((UiContainer)panel, LibMsg.JNDI_PRINCIPAL);
        Label credentialsLabel = Label.create((UiContainer)panel, LibMsg.JNDI_CREDENTIALS);
        Label referralLabel = Label.create((UiContainer)panel, LibMsg.JNDI_REFERRAL);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)factoryLabel, cc.xy(2, 2));
        builder.add((UiComponent)urlLabel, cc.xy(2, 4));
        builder.add((UiComponent)principalLabel, cc.xy(2, 6));
        builder.add((UiComponent)credentialsLabel, cc.xy(2, 8));
        builder.add((UiComponent)referralLabel, cc.xy(2, 10));
        this.contextField = new TextField((UiContainer)panel, "com.sun.jndi.ldap.LdapCtxFactory");
        this.urlField = new TextField(panel);
        this.principalField = new TextField(panel);
        this.credentialsField = new PasswordField(panel);
        this.referralCombo = this.createReferralsComboBox(panel);
        DocumentListener documentListener = this.createDocumentListener();
        this.contextField.addDocumentListener(documentListener);
        this.urlField.addDocumentListener(documentListener);
        this.principalField.addDocumentListener(documentListener);
        this.credentialsField.addDocumentListener(documentListener);
        builder.add((UiComponent)this.contextField, cc.xyw(4, 2, 3));
        builder.add((UiComponent)this.urlField, cc.xyw(4, 4, 3));
        builder.add((UiComponent)this.principalField, cc.xyw(4, 6, 3));
        builder.add((UiComponent)this.credentialsField, cc.xyw(4, 8, 3));
        builder.add((UiComponent)this.referralCombo, cc.xyw(4, 10, 3));
        if (this.isGenericLDAPConfiguration) {
            Label propertiesLabel = Label.create((UiContainer)panel, ConnectorMsg.PROPERTIES_URL);
            this.propertiesTextField = new TextField(panel);
            BrowseButton propertiesButton = new BrowseButton(panel, this.propertiesTextField);
            builder.add((UiComponent)propertiesLabel, cc.xy(2, 12));
            builder.add((UiComponent)this.propertiesTextField, cc.xy(4, 12));
            builder.add((UiComponent)propertiesButton, cc.xy(6, 12));
        }
        return panel;
    }

    private ComboBox createReferralsComboBox(UiContainer parent) {
        ComboBox<Object> comboBox = UiFactory.createComboBox(parent, JNDIFactory.getReferralOptions().toArray());
        comboBox.setSelectedIndex(0);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JNDIConfigurationEditor.this.firePropertiesChanged();
            }
        });
        return comboBox;
    }

    public class BrowseButton
    extends Button {
        private TextField textField_d;

        public BrowseButton(UiContainer parent, final TextField textField) {
            super(parent, LibMsg.BROWSE);
            this.textField_d = textField;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser chooser = new FileChooser();
                    chooser.addChoosableFileFilter(FileFilter.create((Msg)ConnectorMsg.PROPERTIES_FILE_FILTER, (String[])new String[]{".conf"}));
                    chooser.setCurrentDirectory(new File(textField.getText()));
                    int result = chooser.showOpenDialog(Ui.getRoot());
                    if (chooser.getSelectedFile() == null) {
                        return;
                    }
                    switch (result) {
                        case 0: {
                            BrowseButton.this.textField_d.setText(chooser.getSelectedFile().getAbsolutePath());
                            break;
                        }
                    }
                }
            });
        }
    }
}

