/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.editor.MailConfigurationEditorPanel;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.SecureMailConnectionType;
import oracle.bpm.connector.impl.IncomingMailConfigurationBean;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridBagConstraints;

public class IncomingMailConfigurationEditorPanel
extends MailConfigurationEditorPanel {
    private CheckBox secureAuthenticationCheckBox;

    public IncomingMailConfigurationEditorPanel(UiContainer parent) {
        super(parent);
        ItemListener itemListener = this.createItemListener();
        this.setSecureConnectionTypeCombo(this.createSecureConnectionTypeCombo(this.getFieldsPanel()));
        this.getSecureConnectionTypeCombo().addItemListener(itemListener);
        this.secureAuthenticationCheckBox = new CheckBox(this.getFieldsPanel());
        this.secureAuthenticationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IncomingMailConfigurationEditorPanel.this.firePropertiesChanged();
            }
        });
        this.layoutComponents();
        this.add(this.getFieldsPanel(), "North");
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        IncomingMailConfigurationBean bean = (IncomingMailConfigurationBean)configurationEditorBean;
        this.secureAuthenticationCheckBox.setSelected(bean.isSecureAuthentication());
    }

    @Override
    public void synchronizeBean() {
        super.synchronizeBean();
        IncomingMailConfigurationBean bean = (IncomingMailConfigurationBean)this.getEditorBean();
        bean.setSecureAuthentication(this.secureAuthenticationCheckBox.isSelected());
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        this.getFieldsPanel().add(Label.create((UiContainer)this.getFieldsPanel(), LibMsg.MAIL_SECURE_AUTHENTICATION), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.getFieldsPanel().add(this.secureAuthenticationCheckBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private ComboBox createSecureConnectionTypeCombo(UiContainer parent) {
        ComboBox<SecureMailConnectionType> comboBox = UiFactory.createComboBox(parent);
        comboBox.addItem(SecureMailConnectionType.SSL);
        comboBox.addItem(SecureMailConnectionType.NO);
        comboBox.setSelectedItem(SecureMailConnectionType.SSL);
        return comboBox;
    }
}

