/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.util.Properties;
import oracle.bpm.configuration.editor.AbstractPoolConfigurationEditor;
import oracle.bpm.configuration.editor.PoolAttribute;
import oracle.bpm.configuration.impl.DatabaseConfiguration;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;

public abstract class AbstractDatabaseConfigurationEditor
extends AbstractPoolConfigurationEditor {
    protected TextField urlTextField;
    private ChangeListener changeListener;
    private DocumentListener documentListener = this.createDocumentListenerURL();
    private NumericField<Integer> maxOpenCursors;

    protected AbstractDatabaseConfigurationEditor(UiContainer parent) {
        super(parent);
        this.changeListener = this.createChangeListenerURL();
    }

    public DocumentListener getDocumentListener() {
        return this.documentListener;
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        DatabaseConfiguration bean = (DatabaseConfiguration)configurationEditorBean;
        this.maxOpenCursors.setValue(bean.getMaxOpenCursors());
        this.databasePropertiesPanel.add(bean.getAdditionalProperties());
        this.databasePropertiesPanel.setDefaultProperties(bean.getDefaultConnectionProperties());
    }

    @Override
    public void synchronizeBean() {
        super.synchronizeBean();
        DatabaseConfiguration bean = (DatabaseConfiguration)this.getEditorBean();
        bean.setMaxOpenCursors(this.maxOpenCursors.getValue().intValue());
        bean.getAdditionalProperties().clear();
        bean.setAdditionalProperties(this.databasePropertiesPanel.getVisualProperties());
    }

    protected abstract void updateURL();

    protected abstract Properties getPanelProperties();

    @Override
    protected void createFields(Panel panel) {
        super.createFields(panel);
        this.maxOpenCursors = NumericField.createIntegerNumericField(panel);
        this.maxOpenCursors.setValue(Integer.valueOf("100"));
        this.maxOpenCursors.setColumns(5);
        this.maxOpenCursors.setGroupingUsed(false);
        this.maxOpenCursors.setRange(0, Integer.MAX_VALUE);
        DocumentListener documentListener = this.createDocumentListener();
        this.maxOpenCursors.addDocumentListener(documentListener);
        this.addPoolAttribute(new PoolAttribute(Label.create((UiContainer)panel, LibMsg.MAX_OPEN_CURSORS), this.maxOpenCursors));
    }

    protected String getURL() {
        DatabaseConfiguration bean = (DatabaseConfiguration)this.getEditorBean();
        return bean == null ? null : bean.getURL(this.getPanelProperties());
    }

    protected ChangeListener createChangeListenerURL() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractDatabaseConfigurationEditor.this.updateURL();
                AbstractDatabaseConfigurationEditor.this.firePropertiesChanged();
            }
        };
    }

    protected DocumentListener createDocumentListenerURL() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractDatabaseConfigurationEditor.this.updateURL();
                AbstractDatabaseConfigurationEditor.this.firePropertiesChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractDatabaseConfigurationEditor.this.updateURL();
                AbstractDatabaseConfigurationEditor.this.firePropertiesChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractDatabaseConfigurationEditor.this.updateURL();
                AbstractDatabaseConfigurationEditor.this.firePropertiesChanged();
            }
        };
    }

    protected NumericField<Integer> createPortField(Panel fieldsPanel, Integer defaultValue) {
        NumericField<Integer> field = NumericField.createIntegerNumericField(fieldsPanel);
        field.setGroupingUsed(false);
        field.setColumns(5);
        field.setValue(defaultValue);
        field.setRange(0, 65535);
        return field;
    }

    protected Panel createUrlPanel(UiContainer parent) {
        Panel urlPanel = new Panel(parent);
        urlPanel.setLayout(new BorderLayout());
        this.urlTextField = new TextField((UiContainer)urlPanel, this.getURL(), 30);
        this.urlTextField.setEditable(false);
        this.urlTextField.setOpaque(true);
        String colSpecs = "pref,10dlu,pref:grow";
        String rowSpecs = "10dlu,pref";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(urlPanel);
        CellConstraints cc = new CellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)urlPanel, LibMsg.URL), cc.xy(1, 2));
        builder.add((UiComponent)this.urlTextField, cc.xy(3, 2));
        return urlPanel;
    }
}

