/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;

public class Subprocess
extends Activity
implements Cloneable {
    SubprocessType _subprocessType = SubprocessType.EMBEDDED;
    Boolean _adHoc = false;
    protected Map<String, FlowObject> _allNodes = new HashMap<String, FlowObject>();
    protected Collection<FlowObject> _startNodes = new LinkedList<FlowObject>();
    Boolean _expanded = false;
    String _modelReference;
    Subprocess _subprocessReference;
    Boolean _transaction = false;
    Boolean _triggeredByEvent = false;
    double _expandedWidth = 0.0;
    double _expandedHeight = 0.0;

    public Subprocess() {
    }

    public Subprocess(String id, String name) {
        super(id, name);
    }

    public Subprocess(String id, String name, Lane lane) {
        super(id, name, lane);
    }

    public Subprocess(String id, String name, Pool pool) {
        super(id, name, pool);
    }

    @Override
    public Subprocess clone() throws CloneNotSupportedException {
        Subprocess copy = (Subprocess)super.clone();
        copy.setAllNodes(new HashMap<String, FlowObject>());
        copy.setStartNodes(new LinkedList<FlowObject>());
        return copy;
    }

    @Override
    public Subprocess clone(String newID) throws CloneNotSupportedException {
        return (Subprocess)super.clone(newID);
    }

    public void setSubprocessType(SubprocessType subprocessType) {
        if (subprocessType.equals((Object)SubprocessType.EMBEDDED)) {
            this.setModelReference(null);
            this.setSubprocessReference(null);
        }
        this._subprocessType = subprocessType;
    }

    public SubprocessType getSubprocessType() {
        if (this._subprocessType == null) {
            this._subprocessType = SubprocessType.EMBEDDED;
        }
        return this._subprocessType;
    }

    public void setAdHoc(Boolean adHoc) {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            this.getSubprocessReference().setAdHoc(adHoc);
        } else {
            this._adHoc = adHoc;
        }
    }

    public Boolean isAdHoc() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().isAdHoc();
        }
        if (this._adHoc == null) {
            this._adHoc = false;
        }
        return this._adHoc;
    }

    public void setStartNodes(Collection<FlowObject> startNodes) {
        if (!this.getSubprocessType().equals((Object)SubprocessType.EMBEDDED)) {
            throw new RuntimeException("Subprocess '" + this.getName() + "': Invalid call to setStartNodes() when subprocessType is " + (Object)((Object)this._subprocessType));
        }
        this._startNodes = startNodes;
    }

    public Collection<FlowObject> getStartNodes() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().getStartNodes();
        }
        if (this._startNodes == null) {
            this._startNodes = new LinkedList<FlowObject>();
        }
        return this._startNodes;
    }

    public void setAllNodes(Map<String, FlowObject> allNodes) {
        if (!this.getSubprocessType().equals((Object)SubprocessType.EMBEDDED)) {
            throw new RuntimeException("Subprocess '" + this.getName() + "': Invalid call to setAllNodes() when subprocessType is " + (Object)((Object)this._subprocessType));
        }
        this._allNodes = allNodes;
    }

    public Map<String, FlowObject> getAllNodes() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().getAllNodes();
        }
        if (this._allNodes == null) {
            this._allNodes = new HashMap<String, FlowObject>();
        }
        return this._allNodes;
    }

    public void setExpanded(Boolean expanded) {
        this._expanded = expanded;
    }

    public Boolean isExpanded() {
        if (this._expanded == null) {
            this._expanded = false;
        }
        return this._expanded;
    }

    public void setModelReference(String modelReference) {
        if (modelReference == null) {
            this._modelReference = null;
            this._subprocessType = SubprocessType.EMBEDDED;
        } else {
            if (this.getSubprocessType().equals((Object)SubprocessType.EMBEDDED) && !this.getAllNodes().isEmpty()) {
                throw new RuntimeException("Unable to set model reference for subprocess '" + this.getName() + "' because subprocess contains sub-nodes.");
            }
            this._modelReference = modelReference;
            this.setSubprocessType(SubprocessType.REUSABLE);
        }
    }

    public String getModelReference() {
        return this._modelReference;
    }

    public void setSubprocessReference(Subprocess subprocessReference) {
        if (subprocessReference == null) {
            this._subprocessReference = null;
            this._subprocessType = SubprocessType.EMBEDDED;
        } else {
            if (this.getSubprocessType().equals((Object)SubprocessType.EMBEDDED) && !this.getAllNodes().isEmpty()) {
                throw new RuntimeException("Unable to set subprocess reference for subprocess '" + this.getName() + "' because subprocess contains sub-nodes.");
            }
            this._subprocessReference = subprocessReference;
            this.setSubprocessType(SubprocessType.REFERENCE);
        }
    }

    public Subprocess getSubprocessReference() {
        return this._subprocessReference;
    }

    public void setTransaction(Boolean transaction) {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            this.getSubprocessReference().setTransaction(transaction);
        } else {
            this._transaction = transaction;
        }
    }

    public Boolean isTransaction() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().isTransaction();
        }
        if (this._transaction == null) {
            this._transaction = false;
        }
        return this._transaction;
    }

    public void setTriggeredByEvent(Boolean triggeredByEvent) {
        this._triggeredByEvent = triggeredByEvent;
    }

    public Boolean isTriggeredByEvent() {
        if (this._triggeredByEvent == null) {
            this._triggeredByEvent = false;
        }
        return this._triggeredByEvent;
    }

    public void setExpandedWidth(double expandedWidth) {
        this._expandedWidth = expandedWidth;
    }

    public double getExpandedWidth() {
        return this._expandedWidth;
    }

    public void setExpandedHeight(double expandedHeight) {
        this._expandedHeight = expandedHeight;
    }

    public double getExpandedHeight() {
        return this._expandedHeight;
    }

    @Override
    public void setLoopType(Activity.LoopType loopType) {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            this.getSubprocessReference().setLoopType(loopType);
        } else {
            super.setLoopType(loopType);
        }
    }

    @Override
    public Activity.LoopType getLoopType() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().getLoopType();
        }
        return super.getLoopType();
    }

    @Override
    public void setDocumentation(String documentation) {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            this.getSubprocessReference().setDocumentation(documentation);
        } else {
            super.setDocumentation(documentation);
        }
    }

    @Override
    public String getDocumentation() {
        if (this.getSubprocessType().equals((Object)SubprocessType.REFERENCE) && this.getSubprocessReference() != null) {
            return this.getSubprocessReference().getDocumentation();
        }
        return super.getDocumentation();
    }

    @Override
    public void remove() {
        LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
        if (this.getSubprocessType().equals((Object)SubprocessType.EMBEDDED)) {
            for (FlowObject n : tmpNodes) {
                n.setParentSubProcess(null);
            }
        }
        super.remove();
    }

    public static enum SubprocessType {
        EMBEDDED,
        REUSABLE,
        REFERENCE;

    }
}

