/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Swimlane;

public class Lane
extends Swimlane
implements Cloneable {
    protected Pool mPool;
    protected Lane mParentLane;
    protected Map<String, Lane> mLanes = new HashMap<String, Lane>();

    public Lane() {
    }

    public Lane(String id, String name) {
        super(id, name);
    }

    public Lane(String id, String name, Pool pool) {
        this(id, name);
        this.setPool(pool);
    }

    public Lane(String id, String name, Lane lane) {
        this(id, name);
        this.setParentLane(lane);
    }

    @Override
    public Lane clone() throws CloneNotSupportedException {
        Lane copy = (Lane)super.clone();
        copy.setLanes(new HashMap<String, Lane>());
        return copy;
    }

    @Override
    public Lane clone(String newID) throws CloneNotSupportedException {
        return (Lane)super.clone(newID);
    }

    public void setPool(Pool pool) {
        if (this.mPool != null) {
            this.mPool.getLanes().remove(this.getID());
        }
        if (pool != null) {
            if (pool.getLane(this.getID()) == null) {
                pool.getLanes().put(this.getID(), this);
            }
            this.setModel(pool.getModel());
        }
        this.mPool = pool;
    }

    @Override
    public Pool getPool() {
        return this.mPool;
    }

    public void setLanes(Map<String, Lane> lanes) {
        this.mLanes = lanes;
    }

    public Map<String, Lane> getLanes() {
        if (this.mLanes == null) {
            this.mLanes = new HashMap<String, Lane>();
        }
        return this.mLanes;
    }

    public void setParentLane(Lane parentLane) {
        if (this.mParentLane != null) {
            this.mParentLane.getLanes().remove(this.getID());
        }
        if (parentLane != null) {
            if (parentLane.getLanes().get(this.getID()) == null) {
                parentLane.getLanes().put(this.getID(), this);
            }
            this.setModel(parentLane.getModel());
        }
        this.mParentLane = parentLane;
    }

    public Lane getParentLane() {
        return this.mParentLane;
    }

    public Lane getLane(Object key) {
        return this.getLanes().get(key);
    }

    @Override
    public void remove() {
        this.setParentLane(null);
        this.setPool(null);
        LinkedList<Lane> tmpLanes = new LinkedList<Lane>(this.getLanes().values());
        for (Lane lane : tmpLanes) {
            lane.setPool(null);
        }
        super.remove();
    }
}

