/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;

public class Event
extends FlowObject
implements Cloneable {
    private EventType mEventType = EventType.INTERMEDIATE;
    private Trigger mTrigger = Trigger.NONE;
    private Direction mDirection = Direction.CATCH;
    protected Activity mTarget;
    private Boolean mInterrupting = true;
    private Boolean mCancelActivity = true;

    public Event() {
    }

    public Event(String id, String name) {
        super(id, name);
    }

    public Event(String id, String name, Lane lane) {
        super(id, name, lane);
    }

    public Event(String id, String name, Pool pool) {
        super(id, name, pool);
    }

    @Override
    public Event clone() throws CloneNotSupportedException {
        Event copy = (Event)super.clone();
        copy.setTarget(null);
        return copy;
    }

    @Override
    public Event clone(String newID) throws CloneNotSupportedException {
        return (Event)super.clone(newID);
    }

    public void setEventType(EventType eventType) {
        this.mEventType = eventType;
        if (eventType == EventType.START) {
            this.setDirection(Direction.CATCH);
        } else if (eventType == EventType.END) {
            this.setDirection(Direction.THROW);
        }
    }

    public EventType getEventType() {
        return this.mEventType;
    }

    public void setTrigger(Trigger trigger) {
        this.mTrigger = trigger;
    }

    public Trigger getTrigger() {
        if (this.mTrigger == null) {
            this.mTrigger = Trigger.NONE;
        }
        return this.mTrigger;
    }

    public void setDirection(Direction direction) {
        this.mDirection = direction;
    }

    public Direction getDirection() {
        if (this.mDirection == null) {
            this.mDirection = Direction.CATCH;
        }
        return this.mDirection;
    }

    public void setTarget(Activity target) {
        if (this.mTarget != null) {
            this.mTarget.getAttachedEvents().remove(this);
        }
        if (target != null && !target.getAttachedEvents().contains(this)) {
            target.getAttachedEvents().add(this);
        }
        this.mTarget = target;
    }

    public Activity getTarget() {
        return this.mTarget;
    }

    public void setInterrupting(Boolean interrupting) {
        this.mInterrupting = interrupting;
    }

    public Boolean getInterrupting() {
        if (this.mInterrupting == null) {
            this.mInterrupting = true;
        }
        return this.mInterrupting;
    }

    public void setCancelActivity(Boolean mCancelActivity) {
        this.mCancelActivity = mCancelActivity;
    }

    public Boolean getCancelActivity() {
        if (this.mCancelActivity == null) {
            this.mCancelActivity = true;
        }
        return this.mCancelActivity;
    }

    @Override
    public void remove() {
        this.setTarget(null);
        super.remove();
    }

    public static enum Direction {
        THROW,
        CATCH;

    }

    public static enum Trigger {
        NONE,
        MESSAGE,
        TIMER,
        CONDITIONAL,
        SIGNAL,
        MULTIPLE,
        ERROR,
        CANCEL,
        COMPENSATION,
        LINK,
        TERMINATE,
        ESCALATION;

    }

    public static enum EventType {
        START,
        INTERMEDIATE,
        END;

    }
}

