/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Artifact;
import oracle.tutor.bpmn.Association;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Layout;
import oracle.tutor.bpmn.MessageFlow;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;
import oracle.tutor.bpmn.Task;
import oracle.tutor.bpmn.Version;

public class BusinessProcessDiagram {
    private static Logger mLog = Logger.getLogger(BusinessProcessDiagram.class.getName());
    String mID;
    String mName = "";
    String mDescription = "";
    String mToolID = "";
    String mVersion = "";
    String mAuthor = "";
    String mCreationDate = "";
    CoordinateOrigins mCoordinateOrigin = CoordinateOrigins.UPPERLEFT;
    String mDocumentation = "";
    String mModificationDate = "";
    String mMeasurementUnit;
    boolean mRelativeObjectCoordinates = false;
    protected Map<String, Pool> mPools = new HashMap<String, Pool>();
    protected Collection<FlowObject> mStartNodes = new LinkedList<FlowObject>();
    protected Collection<FlowObject> mSequencedNodes = new LinkedList<FlowObject>();
    protected Map<String, FlowObject> mAllNodes = new HashMap<String, FlowObject>();
    protected Map<String, GraphicalElement> mGraphicalElements = new HashMap<String, GraphicalElement>();
    protected Map<String, ConnectingObject> mAllFlows = new HashMap<String, ConnectingObject>();

    public BusinessProcessDiagram() {
        mLog.info("Build: " + Version.getBuildNumber());
    }

    public BusinessProcessDiagram(String id, String name) {
        this();
        this.mID = id;
        this.mName = name;
    }

    public void setID(String id) {
        this.mID = id;
    }

    public String getID() {
        return this.mID;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        if (this.mName == null) {
            this.mName = "";
        }
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        if (this.mDescription == null) {
            this.mDescription = "";
        }
        return this.mDescription;
    }

    public void setToolID(String toolID) {
        this.mToolID = toolID;
    }

    public String getToolID() {
        if (this.mToolID == null) {
            this.mToolID = "";
        }
        return this.mToolID;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public String getVersion() {
        if (this.mVersion == null) {
            this.mVersion = "";
        }
        return this.mVersion;
    }

    public void setAuthor(String author) {
        this.mAuthor = author;
    }

    public String getAuthor() {
        if (this.mAuthor == null) {
            this.mAuthor = "";
        }
        return this.mAuthor;
    }

    public void setCreationDate(String creationDate) {
        this.mCreationDate = creationDate;
    }

    public String getCreationDate() {
        if (this.mCreationDate == null) {
            this.mCreationDate = "";
        }
        return this.mCreationDate;
    }

    public void setCoordinateOrigin(CoordinateOrigins coordinateOrigin) {
        this.mCoordinateOrigin = coordinateOrigin;
    }

    public CoordinateOrigins getCoordinateOrigin() {
        if (this.mCoordinateOrigin == null) {
            this.mCoordinateOrigin = CoordinateOrigins.UPPERLEFT;
        }
        return this.mCoordinateOrigin;
    }

    public void setDocumentation(String documentation) {
        this.mDocumentation = documentation;
    }

    public String getDocumentation() {
        if (this.mDocumentation == null) {
            this.mDocumentation = "";
        }
        return this.mDocumentation;
    }

    public void setModificationDate(String modificationDate) {
        this.mModificationDate = modificationDate;
    }

    public String getModificationDate() {
        if (this.mModificationDate == null) {
            this.mModificationDate = "";
        }
        return this.mModificationDate;
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.mMeasurementUnit = measurementUnit;
    }

    public String getMeasurementUnit() {
        if (this.mMeasurementUnit == null) {
            this.mMeasurementUnit = "";
        }
        return this.mMeasurementUnit;
    }

    public void setRelativeObjectCoordinates(boolean relativeObjectCoordinates) {
        this.mRelativeObjectCoordinates = relativeObjectCoordinates;
    }

    public boolean isRelativeObjectCoordinates() {
        if (!this.mRelativeObjectCoordinates) {
            this.mRelativeObjectCoordinates = false;
        }
        return this.mRelativeObjectCoordinates;
    }

    public void setPools(Map<String, Pool> pools) {
        this.mPools = pools;
    }

    public Map<String, Pool> getPools() {
        if (this.mPools == null) {
            this.mPools = new HashMap<String, Pool>();
        }
        return this.mPools;
    }

    public void setStartNodes(Collection<FlowObject> startNodes) {
        this.mStartNodes = startNodes;
    }

    public Collection<FlowObject> getStartNodes() {
        if (this.mStartNodes == null) {
            this.mStartNodes = new LinkedList<FlowObject>();
        }
        return this.mStartNodes;
    }

    public void setSequencedNodes(Collection<FlowObject> sequencedNodes) {
        this.mSequencedNodes = sequencedNodes;
    }

    public Collection<FlowObject> getSequencedNodes() {
        if (this.mSequencedNodes == null) {
            this.mSequencedNodes = new LinkedList<FlowObject>();
        }
        return this.mSequencedNodes;
    }

    public void setAllNodes(Map<String, FlowObject> allNodes) {
        this.mAllNodes = allNodes;
    }

    public Map<String, FlowObject> getAllNodes() {
        if (this.mAllNodes == null) {
            this.mAllNodes = new HashMap<String, FlowObject>();
        }
        return this.mAllNodes;
    }

    public void setGraphicalElements(Map<String, GraphicalElement> graphicalElements) {
        this.mGraphicalElements = graphicalElements;
    }

    public Map<String, GraphicalElement> getGraphicalElements() {
        if (this.mGraphicalElements == null) {
            this.mGraphicalElements = new HashMap<String, GraphicalElement>();
        }
        return this.mGraphicalElements;
    }

    public void setAllFlows(Map<String, ConnectingObject> allFlows) {
        this.mAllFlows = allFlows;
    }

    public Map<String, ConnectingObject> getAllFlows() {
        if (this.mAllFlows == null) {
            this.mAllFlows = new HashMap<String, ConnectingObject>();
        }
        return this.mAllFlows;
    }

    public Pool getPool(String key) {
        Pool p = this.getPools().get(key);
        if (p == null) {
            mLog.warning("'" + key + "' is not a valid pool id.");
        }
        return p;
    }

    public Pool getPoolByName(String poolName) {
        Pool foundPool = null;
        for (Pool pool : this.getPools().values()) {
            if (!(pool.getName() + "").equals(poolName + "")) continue;
            foundPool = pool;
            break;
        }
        if (foundPool == null) {
            mLog.warning("'" + poolName + "' is not a valid pool name. Returning null.");
        }
        return foundPool;
    }

    public FlowObject getNode(String key) {
        FlowObject n = this.getAllNodes().get(key);
        if (n == null) {
            mLog.warning("'" + key + "' is not a valid node id. Returning null.");
        }
        return n;
    }

    public void addNode(FlowObject node) {
        if (node != null) {
            node.setModel(this);
            if (this.getAllNodes().get(node.getID()) == null) {
                this.getAllNodes().put(node.getID(), node);
            }
        }
    }

    public ConnectingObject getFlow(String key) {
        ConnectingObject f = this.getAllFlows().get(key);
        if (f == null) {
            mLog.warning("'" + key + "' is not a valid flow id. Returning null.");
        }
        return f;
    }

    public void addFlow(ConnectingObject flow) {
        if (flow != null) {
            flow.setModel(this);
            if (this.getAllFlows().get(flow.getID()) == null) {
                this.getAllFlows().put(flow.getID(), flow);
            }
        }
    }

    public GraphicalElement getElement(Object key) {
        GraphicalElement n = this.getGraphicalElements().get(key);
        if (n == null) {
            mLog.warning("'" + key + "' is not a valid element id. Returning null.");
        }
        return n;
    }

    public void cleanUp() {
        this.cleanUp(false, null);
    }

    public void cleanUp(boolean followMessageFlows) {
        this.cleanUp(followMessageFlows, null);
    }

    public void cleanUp(boolean followMessageFlows, LinkedList<ConversionMessage> messages) {
        mLog.info("Running cleanUp...");
        LinkedList<ConnectingObject> tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
        for (ConnectingObject flow : tmpFlows) {
            if (!(flow instanceof SequenceFlow) || flow.getFrom() != null || flow.getTo() == null) continue;
            if (messages != null) {
                messages.add(new ConversionMessage(flow.getID(), "Flow to '" + flow.getTo().getName() + "' removed because it is not connected on both ends."));
            }
            flow.remove();
        }
        this.getStartNodes().clear();
        for (FlowObject node : this.getAllNodes().values()) {
            if ((followMessageFlows || node.getInflows(SequenceFlow.class).size() != 0) && (!followMessageFlows || node.getInflows(MessageFlow.class).size() != 0 || node.getInflows(SequenceFlow.class).size() != 0) || node instanceof Artifact || node instanceof Event && ((Event)node).getTarget() != null) continue;
            if (node.getParentSubProcess() != null) {
                node.getParentSubProcess().getStartNodes().add(node);
                continue;
            }
            this.getStartNodes().add(node);
        }
        if (this.getStartNodes().isEmpty() && !this.getAllNodes().isEmpty()) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            this.getStartNodes().add(Collections.min(tmpNodes, new byDistanceFromOrigin()));
        }
    }

    public void clearVisited() {
        for (FlowObject node : this.getAllNodes().values()) {
            node.setVisited(false);
        }
    }

    public void serialize(boolean explodeSubprocesses, boolean followMessageFlows) {
        this.serialize(explodeSubprocesses, null, followMessageFlows);
    }

    public void serialize(boolean explodeSubprocesses, Pool pool, boolean followMessageFlows) {
        this.cleanUp(followMessageFlows, null);
        this.getSequencedNodes().clear();
        this.clearVisited();
        Collections.sort((List)this.getStartNodes(), new byPositionY());
        Collections.reverse((List)this.getStartNodes());
        for (FlowObject node : this.getStartNodes()) {
            if (pool != null && (node.getLane() == null || !node.getLane().getPool().equals(pool))) continue;
            this.traverse(node, explodeSubprocesses, followMessageFlows);
        }
        Collections.reverse((List)this.getSequencedNodes());
    }

    private void traverse(FlowObject node, boolean explodeSubprocesses, boolean followMessageFlows) {
        if (!node.isVisited().booleanValue()) {
            node.setVisited(true);
            Collections.sort(node.getOutflows(), new byEndpointY());
            Collections.reverse(node.getOutflows());
            for (ConnectingObject branch : node.getOutflows()) {
                if (!(branch instanceof SequenceFlow) && (!(branch instanceof MessageFlow) || !followMessageFlows) || branch.getTo() == null || !(branch.getTo() instanceof FlowObject)) continue;
                this.traverse((FlowObject)branch.getTo(), explodeSubprocesses, followMessageFlows);
            }
            Collections.reverse(node.getOutflows());
            if (node instanceof Activity) {
                Activity act = (Activity)node;
                Collections.sort((List)act.getAttachedEvents(), new byDistanceFromOrigin());
                Collections.reverse((List)act.getAttachedEvents());
                for (Event e : act.getAttachedEvents()) {
                    this.traverse(e, explodeSubprocesses, followMessageFlows);
                }
            }
            if (node instanceof Subprocess && ((Subprocess)node).getSubprocessType() != Subprocess.SubprocessType.REUSABLE && ((Subprocess)node).isExpanded().booleanValue()) {
                Subprocess sub = (Subprocess)node;
                Collections.sort((List)sub.getStartNodes(), new byDistanceFromParentOrigin());
                Collections.reverse((List)sub.getStartNodes());
                for (FlowObject o : sub.getStartNodes()) {
                    this.traverse(o, explodeSubprocesses, followMessageFlows);
                }
                Collections.reverse((List)sub.getStartNodes());
            } else {
                this.getSequencedNodes().add(node);
            }
        }
    }

    public void transform(CoordinateOrigins newOrigin, GraphicalElement.ObjectPin newObjectPin) {
        GraphicalElement.ObjectPin LOWERLEFT = GraphicalElement.ObjectPin.LOWERLEFT;
        GraphicalElement.ObjectPin UPPERLEFT = GraphicalElement.ObjectPin.UPPERLEFT;
        GraphicalElement.ObjectPin MIDDLE = GraphicalElement.ObjectPin.MIDDLE;
        if (this.getCoordinateOrigin() != newOrigin && newOrigin != null) {
            double minY = Double.MAX_VALUE;
            double maxY = 0.0;
            for (GraphicalElement e : this.getGraphicalElements().values()) {
                double objMaxY;
                double objMinY;
                if (e instanceof ConnectingObject) continue;
                if (e.getObjectPin() == MIDDLE) {
                    objMinY = e.getYd() - e.getHeightd() / 2.0;
                    objMaxY = e.getYd() + e.getHeightd() / 2.0;
                } else if (e.getObjectPin() == UPPERLEFT && this.getCoordinateOrigin() == CoordinateOrigins.UPPERLEFT || e.getObjectPin() == LOWERLEFT && this.getCoordinateOrigin() == CoordinateOrigins.LOWERLEFT) {
                    objMinY = e.getYd();
                    objMaxY = e.getYd() + e.getHeightd();
                } else {
                    objMinY = e.getYd() - e.getHeightd();
                    objMaxY = e.getYd();
                }
                minY = Math.min(objMinY, minY);
                maxY = Math.max(objMaxY, maxY);
            }
            double offsetY = maxY * 1.2;
            for (GraphicalElement e : this.getGraphicalElements().values()) {
                if (e instanceof ConnectingObject) {
                    ConnectingObject conn = (ConnectingObject)e;
                    for (Coordinate point : conn.getPath()) {
                        point.setY(offsetY - point.getYd());
                    }
                    continue;
                }
                e.setY(offsetY - e.getYd());
            }
        }
        this.setCoordinateOrigin(newOrigin);
        for (GraphicalElement n : this.getGraphicalElements().values()) {
            double xShift;
            double yShift;
            GraphicalElement.ObjectPin currentPin = n.getObjectPin();
            if (currentPin == newObjectPin || newObjectPin == null) continue;
            if (currentPin == UPPERLEFT) {
                if (newObjectPin == LOWERLEFT) {
                    yShift = 1.0;
                    xShift = 0.0;
                } else {
                    yShift = 0.5;
                    xShift = 0.5;
                }
            } else if (currentPin == LOWERLEFT) {
                if (newObjectPin == UPPERLEFT) {
                    yShift = -1.0;
                    xShift = 0.0;
                } else {
                    yShift = -0.5;
                    xShift = 0.5;
                }
            } else if (newObjectPin == LOWERLEFT) {
                yShift = 0.5;
                xShift = -0.5;
            } else {
                yShift = -0.5;
                xShift = -0.5;
            }
            if (this.getCoordinateOrigin() == CoordinateOrigins.LOWERLEFT) {
                yShift *= -1.0;
            }
            n.setPosition(n.getXd() + xShift * n.getWidthd(), n.getYd() + yShift * n.getHeightd());
            n.setObjectPin(newObjectPin);
        }
    }

    public void scale(float multiplier) {
        this.scale((double)multiplier);
    }

    public void scale(double multiplier) {
        for (GraphicalElement e : this.getGraphicalElements().values()) {
            if (e instanceof ConnectingObject) {
                ConnectingObject conn = (ConnectingObject)e;
                for (Coordinate point : conn.getPath()) {
                    point.setX(point.getXd() * multiplier);
                    point.setY(point.getYd() * multiplier);
                }
                continue;
            }
            e.setPosition(e.getXd() * multiplier, e.getYd() * multiplier);
            e.setHeight(e.getHeightd() * multiplier);
            e.setWidth(e.getWidthd() * multiplier);
            if (!(e instanceof Subprocess)) continue;
            Subprocess tempSP = (Subprocess)e;
            tempSP.setExpandedHeight(tempSP.getExpandedHeight() * multiplier);
            tempSP.setExpandedWidth(tempSP.getExpandedWidth() * multiplier);
        }
    }

    public void scale(double targetTaskBoxWidth, double targetTaskBoxHeight) {
        ArrayList<Double> boxWidths = new ArrayList<Double>();
        ArrayList<Double> boxHeights = new ArrayList<Double>();
        for (FlowObject n : this.getAllNodes().values()) {
            if (!(n instanceof Task) && (!(n instanceof Subprocess) || ((Subprocess)n).isExpanded().booleanValue())) continue;
            boxWidths.add(n.getWidthd());
            boxHeights.add(n.getHeightd());
        }
        if (boxWidths.size() == 0) {
            mLog.severe("Unable to scale diagram because it contains no tasks.");
            throw new RuntimeException("Model contains no tasks--unable to scale.");
        }
        double widthMode = this.modeOrAvg(boxWidths);
        double heightMode = this.modeOrAvg(boxHeights);
        mLog.fine("Mode of widths = " + widthMode + "\nMode of heights = " + heightMode);
        if (widthMode == 0.0 || heightMode == 0.0) {
            mLog.severe("Unable to scale model because all nodes have size = 0");
            throw new RuntimeException("Tasks in model all have size of 0 units--unable to scale.");
        }
        double multiplier = Math.max(targetTaskBoxWidth / widthMode, targetTaskBoxHeight / heightMode);
        this.scale(multiplier);
    }

    private double modeOrAvg(List<Double> list) {
        Collections.sort(list);
        double mode = list.get(0);
        double priorValue = list.get(0);
        long runLength = 1L;
        long longest = 0L;
        for (int i = 1; i < list.size(); ++i) {
            double n = list.get(i);
            if (n == priorValue) {
                ++runLength;
            }
            if ((n != priorValue || i == list.size() - 1) && runLength > longest) {
                mode = priorValue;
                longest = runLength;
                runLength = 1L;
            }
            priorValue = n;
        }
        if (longest <= 1L) {
            double sum = 0.0;
            for (double n : list) {
                sum += n;
            }
            mode = sum / (double)list.size();
        }
        return mode;
    }

    public void shift(double shiftX, double shiftY) {
        for (GraphicalElement e : this.getGraphicalElements().values()) {
            if (e instanceof ConnectingObject) {
                ConnectingObject conn = (ConnectingObject)e;
                for (Coordinate point : conn.getPath()) {
                    point.setX(point.getXd() + shiftX);
                    point.setY(point.getYd() + shiftY);
                }
                continue;
            }
            e.setPosition(e.getXd() + shiftX, e.getYd() + shiftY);
        }
    }

    public void shift(float shiftX, float shiftY) {
        this.shift((double)shiftX, (double)shiftY);
    }

    public Boolean qaCheck() {
        return true;
    }

    public LinkedList<ConversionMessage> simplify() {
        SimplifyFlags[] flags = new SimplifyFlags[]{SimplifyFlags.REMOVE_EXTRANEOUS_FLOWS, SimplifyFlags.DETACH_SUBPROCESS_START_END, SimplifyFlags.REMOVE_COLLAPSED_SUBPROCESS_CHILDREN, SimplifyFlags.CONDITIONAL_FLOW_TO_GATEWAY, SimplifyFlags.REMOVE_AUTOMATED, SimplifyFlags.REMOVE_JOINS, SimplifyFlags.XOR_EVENT_TO_DATA, SimplifyFlags.EVENTS_TO_TASKS, SimplifyFlags.ATTACHED_EVENTS_TO_XOR, SimplifyFlags.CREATE_MISSING_OR_FLOW_LABELS, SimplifyFlags.ADD_TASKS_BETWEEN_GATEWAYS, SimplifyFlags.ADD_TASKS_BEFORE_SUBPROCESSES, SimplifyFlags.MULTIPLE_START_EVENTS_TO_GATEWAY, SimplifyFlags.EXPLODE_SUBPROCESSES, SimplifyFlags.ADD_AND_SPLIT_AFTER_START, SimplifyFlags.CONNECT_LINKS};
        return this.simplify(flags);
    }

    public LinkedList<ConversionMessage> simplify(SimplifyFlags flag) {
        SimplifyFlags[] flags = new SimplifyFlags[]{flag};
        return this.simplify(flags);
    }

    public LinkedList<ConversionMessage> simplify(SimplifyFlags[] flags) {
        GraphicalElement fromNode;
        ConnectingObject flow4;
        LinkedList<ConnectingObject> outFlows;
        ArrayList<SimplifyFlags> flagList = new ArrayList<SimplifyFlags>();
        for (SimplifyFlags f : flags) {
            flagList.add(f);
        }
        LinkedList<ConversionMessage> messages = new LinkedList<ConversionMessage>();
        LinkedList<ConnectingObject> tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
        for (ConnectingObject flow2 : tmpFlows) {
            Event e;
            if (!(flow2 instanceof Association) || flow2.getFrom() == null || !(flow2.getFrom() instanceof Event) || flow2.getTo() == null || !(flow2.getTo() instanceof Activity) || (e = (Event)flow2.getFrom()).getEventType() != Event.EventType.INTERMEDIATE || e.getTrigger() != Event.Trigger.COMPENSATION || e.getTarget() == null) continue;
            SequenceFlow newFlow = new SequenceFlow("s0_" + flow2.getID(), flow2.getName(), flow2.getFrom(), flow2.getTo());
            newFlow.setPath((LinkedList)flow2.getPath().clone());
            flow2.remove();
        }
        if (flagList.contains((Object)SimplifyFlags.CONNECT_LINKS)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            LinkedList<FlowObject> throwLinks = new LinkedList<FlowObject>();
            LinkedList<FlowObject> catchLinks = new LinkedList<FlowObject>();
            for (FlowObject node : tmpNodes) {
                if (!(node instanceof Event) || ((Event)node).getTrigger() != Event.Trigger.LINK) continue;
                if (node.getInflows().isEmpty() && !node.getOutflows().isEmpty()) {
                    catchLinks.add(node);
                    continue;
                }
                throwLinks.add(node);
            }
            int counter = 0;
            for (FlowObject fromLink : throwLinks) {
                for (FlowObject toLink : catchLinks) {
                    if (!fromLink.getName().equals(toLink.getName())) continue;
                    SequenceFlow s = new SequenceFlow("s0" + ++counter + "_" + fromLink.getID(), "", fromLink, toLink);
                }
            }
            if (counter > 0) {
                throwLinks.addAll(catchLinks);
                for (FlowObject link : throwLinks) {
                    Gateway newG;
                    LinkedList<ConnectingObject> inflows = link.getInflows(SequenceFlow.class);
                    LinkedList<ConnectingObject> outflows = link.getOutflows(SequenceFlow.class);
                    if (inflows.size() == 1 && outflows.size() == 1) {
                        ConnectingObject inflow = inflows.getFirst();
                        ConnectingObject outflow = outflows.getFirst();
                        inflow.setTo(outflow.getTo());
                        inflow.getPath().clear();
                        outflow.remove();
                        link.remove();
                        continue;
                    }
                    if (inflows.size() > 1 && outflows.size() == 1) {
                        newG = new Gateway("g0_" + link.getID(), "");
                        newG.setGatewayType(Gateway.GatewayType.OR);
                        newG.setLane(link.getLane());
                        newG.setParentSubProcess(link.getParentSubProcess());
                        newG.setPosition(link.getX(), link.getY());
                        outflows.getFirst().setFrom(newG);
                        for (ConnectingObject flow3 : inflows) {
                            flow3.setTo(newG);
                        }
                        messages.add(new ConversionMessage(newG.getID(), "Link event '" + link.getName() + "' replaced with Inclusive-Or merge."));
                        link.remove();
                        continue;
                    }
                    if (inflows.size() < 1 || outflows.size() <= 1) continue;
                    newG = new Gateway("g0_" + link.getID(), "");
                    newG.setGatewayType(Gateway.GatewayType.AND);
                    newG.setLane(link.getLane());
                    newG.setParentSubProcess(link.getParentSubProcess());
                    newG.setPosition(link.getX(), link.getY());
                    for (ConnectingObject flow3 : inflows) {
                        flow3.setTo(newG);
                    }
                    for (ConnectingObject flow3 : outflows) {
                        flow3.setFrom(newG);
                    }
                    messages.add(new ConversionMessage(newG.getID(), "Link event '" + link.getName() + "' replaced with parallel directive."));
                    link.remove();
                }
            }
        }
        if (flagList.contains((Object)SimplifyFlags.MERGE_POOLS)) {
            tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
            for (ConnectingObject flow2 : tmpFlows) {
                Subprocess sub;
                if (!(flow2 instanceof MessageFlow) || flow2.getFrom() == null || flow2.getTo() == null) continue;
                boolean convertFlow = true;
                if (flow2.getFrom() instanceof Subprocess && flow2.getTo() instanceof Event && ((Event)flow2.getTo()).getEventType() == Event.EventType.START) {
                    sub = (Subprocess)flow2.getFrom();
                    if ((!sub.isExpanded().booleanValue() || sub.getAllNodes().isEmpty()) && sub.getInflows(SequenceFlow.class).isEmpty() && sub.getOutflows(SequenceFlow.class).isEmpty()) {
                        sub.setLane((Swimlane)null);
                        convertFlow = false;
                    }
                } else if (flow2.getFrom() instanceof Event && flow2.getTo() instanceof Subprocess && ((Event)flow2.getFrom()).getEventType() == Event.EventType.END) {
                    sub = (Subprocess)flow2.getTo();
                    if ((!sub.isExpanded().booleanValue() || sub.getAllNodes().isEmpty()) && sub.getInflows(SequenceFlow.class).isEmpty() && sub.getOutflows(SequenceFlow.class).isEmpty()) {
                        sub.setLane((Swimlane)null);
                        convertFlow = false;
                    }
                } else if (flow2.getFrom() instanceof Swimlane || flow2.getTo() instanceof Swimlane) {
                    flow2.remove();
                    convertFlow = false;
                }
                if (!convertFlow) continue;
                GraphicalElement fromNode2 = flow2.getFrom();
                GraphicalElement toNode = flow2.getTo();
                if (fromNode2.getOutflows(SequenceFlow.class).size() == 1 && fromNode2.getOutflows(MessageFlow.class).size() == 1) {
                    fromNode2.setAttribute("canOptimize", true);
                }
                SequenceFlow newFlow = new SequenceFlow("s13_" + flow2.getID(), flow2.getName(), fromNode2, toNode);
                newFlow.setPath((LinkedList)flow2.getPath().clone());
                flow2.remove();
                messages.add(new ConversionMessage(fromNode2.getID(), "Message flow between '" + fromNode2.getName() + "' and '" + toNode.getName() + "' converted to a sequence flow."));
                if (toNode instanceof Event && ((Event)toNode).getEventType() == Event.EventType.START) {
                    if (("".equals(toNode.getName()) || ((Event)toNode).getTrigger() == Event.Trigger.NONE) && toNode.getOutflows(SequenceFlow.class).size() == 1) {
                        LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(toNode.getInflows());
                        ConnectingObject outFlow = toNode.getOutflows(SequenceFlow.class).getFirst();
                        for (ConnectingObject inFlow : inFlows) {
                            inFlow.setTo(outFlow.getTo());
                        }
                        toNode.remove();
                        outFlow.remove();
                        messages.add(new ConversionMessage(toNode.getID(), "Start event '" + toNode.getName() + "' removed."));
                        continue;
                    }
                    ((Event)toNode).setEventType(Event.EventType.INTERMEDIATE);
                    messages.add(new ConversionMessage(toNode.getID(), "Start event '" + toNode.getName() + "' converted to an intermediate event."));
                    continue;
                }
                if (!(fromNode2 instanceof Event) || ((Event)fromNode2).getEventType() != Event.EventType.END) continue;
                ((Event)fromNode2).setEventType(Event.EventType.INTERMEDIATE);
                messages.add(new ConversionMessage(fromNode2.getID(), "End event '" + fromNode2.getName() + "' converted to an intermediate event."));
            }
            this.removeExtraneousFlows(messages);
            tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
            for (ConnectingObject flow2 : tmpFlows) {
                if (!(flow2 instanceof SequenceFlow) || flow2.getFrom() == null || flow2.getTo() == null || !(flow2.getFrom() instanceof FlowObject) || !(flow2.getTo() instanceof FlowObject)) continue;
                FlowObject fromNode3 = (FlowObject)flow2.getFrom();
                FlowObject toNode = (FlowObject)flow2.getTo();
                if (!Boolean.TRUE.equals((Boolean)fromNode3.getAttribute("canOptimize")) || fromNode3 instanceof Gateway || ((SequenceFlow)flow2).isConditional().booleanValue() || ((SequenceFlow)flow2).isDefault().booleanValue() || !fromNode3.hasSuccessor(toNode, (SequenceFlow)flow2)) continue;
                flow2.remove();
                messages.add(new ConversionMessage(fromNode3.getID(), "Superfluous flow between '" + fromNode3.getName() + "' and '" + toNode.getName() + "' removed."));
            }
            Pool newPool = new Pool("_merged_", "", this);
            for (Pool p : this.getPools().values()) {
                if (p == newPool || !p.getLanes().isEmpty()) continue;
                LinkedList<FlowObject> poolNodes = new LinkedList<FlowObject>();
                for (FlowObject o : this.getAllNodes().values()) {
                    if (o.getLane() != p) continue;
                    poolNodes.add(o);
                }
                if (poolNodes.isEmpty()) continue;
                Lane newLane = new Lane("l13_" + p.getID(), p.getName(), newPool);
                newLane.setPosition(p.getX(), p.getY());
                newLane.setWidth(p.getWidth());
                newLane.setHeight(p.getHeight());
                for (FlowObject o : poolNodes) {
                    o.setLane(newLane);
                }
                messages.add(new ConversionMessage(newLane.getID(), "Pool '" + p.getName() + "' converted to a lane."));
            }
            for (GraphicalElement e : this.getGraphicalElements().values()) {
                if (!(e instanceof Lane)) continue;
                ((Lane)e).setPool(newPool);
            }
            for (FlowObject o : this.getAllNodes().values()) {
                if (!(o.getLane() instanceof Pool)) continue;
                o.setLane(newPool);
            }
            LinkedList<Pool> tmpPools = new LinkedList<Pool>(this.getPools().values());
            tmpPools.remove(newPool);
            for (Pool p : tmpPools) {
                p.remove();
            }
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (GraphicalElement e : this.getGraphicalElements().values()) {
                if ((!(e instanceof Pool) || e == newPool) && !(e instanceof Lane) && (!(e instanceof FlowObject) || ((FlowObject)e).getLane() == null)) continue;
                minX = Math.min((double)e.getX(), minX);
                maxX = Math.max((double)(e.getX() + e.getWidth()), maxX);
                minY = Math.min((double)e.getY(), minY);
                maxY = Math.max((double)(e.getY() + e.getHeight()), maxY);
            }
            newPool.setPosition(minX, minY);
            newPool.setWidth(maxX - minX);
            newPool.setHeight(maxY - minY);
            messages.add(new ConversionMessage(newPool.getID(), "Multiple pools merged into single pool."));
        }
        if (flagList.contains((Object)SimplifyFlags.DETACH_SUBPROCESS_START_END)) {
            for (ConnectingObject flow2 : this.getAllFlows().values()) {
                if (!(flow2 instanceof SequenceFlow)) continue;
                GraphicalElement toObj = flow2.getTo();
                GraphicalElement fromObj = flow2.getFrom();
                if (fromObj != null && fromObj instanceof FlowObject && toObj != null && toObj instanceof Event && ((FlowObject)toObj).getParentSubProcess() != null && ((Event)toObj).getEventType() == Event.EventType.START && ((FlowObject)toObj).getParentSubProcess() != ((FlowObject)fromObj).getParentSubProcess()) {
                    flow2.setTo(((FlowObject)toObj).getParentSubProcess());
                }
                if (toObj == null || !(toObj instanceof FlowObject) || fromObj == null || !(fromObj instanceof Event) || ((FlowObject)fromObj).getParentSubProcess() == null || ((Event)fromObj).getEventType() != Event.EventType.END || ((FlowObject)fromObj).getParentSubProcess() == ((FlowObject)toObj).getParentSubProcess()) continue;
                flow2.setFrom(((FlowObject)fromObj).getParentSubProcess());
            }
        }
        if (flagList.contains((Object)SimplifyFlags.REMOVE_COLLAPSED_SUBPROCESS_CHILDREN)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject node : tmpNodes) {
                if (node.getParentSubProcess() == null || node.getParentSubProcess().isExpanded().booleanValue()) continue;
                messages.add(new ConversionMessage(node.getID(), "Hidden node '" + node.getName() + "' removed from collapsed subprocess '" + node.getParentSubProcess().getName() + "'."));
                node.remove();
            }
        }
        if (flagList.contains((Object)SimplifyFlags.CONDITIONAL_FLOW_TO_GATEWAY)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject node : tmpNodes) {
                if (!(node instanceof Activity)) continue;
                GraphicalElement newG = null;
                outFlows = new LinkedList<ConnectingObject>(node.getOutflows(SequenceFlow.class));
                for (ConnectingObject flow4 : outFlows) {
                    SequenceFlow s = (SequenceFlow)flow4;
                    if (!s.isConditional().booleanValue() && !s.isDefault().booleanValue()) continue;
                    if (newG == null) {
                        newG = new Gateway("g1_" + node.getID(), "");
                        ((Gateway)newG).setGatewayType(Gateway.GatewayType.OR);
                        newG.setPosition(node.getX() + node.getWidth(), node.getY());
                        ((FlowObject)newG).setLane(node.getLane());
                        ((FlowObject)newG).setParentSubProcess(node.getParentSubProcess());
                        this.addNode((FlowObject)newG);
                    }
                    s.setFrom(newG);
                }
                if (newG == null) continue;
                if (newG.getOutflows().size() == 1) {
                    outFlows = new LinkedList<ConnectingObject>(node.getOutflows(SequenceFlow.class));
                    if (outFlows.size() == 1) {
                        SequenceFlow flow5 = (SequenceFlow)outFlows.getFirst();
                        flow5.setDefault(true);
                        flow5.setFrom(newG);
                    } else if (outFlows.isEmpty()) {
                        Event e = new Event("e1_" + newG.getID(), "");
                        e.setEventType(Event.EventType.END);
                        e.setLane(node.getLane());
                        e.setParentSubProcess(node.getParentSubProcess());
                        e.setPosition(node.getX() + node.getWidth() * 2.0f, node.getY());
                        flow4 = new SequenceFlow("s1x_" + e.getID(), "", newG, e);
                        ((SequenceFlow)flow4).setDefault(true);
                    } else {
                        for (ConnectingObject flow4 : outFlows) {
                            flow4.setFrom(newG);
                        }
                    }
                }
                new SequenceFlow("s1_" + newG.getID(), "", node, newG);
            }
        }
        if (flagList.contains((Object)SimplifyFlags.REMOVE_AUTOMATED)) {
            boolean deletedSomething;
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject node : tmpNodes) {
                Gateway g;
                Task t;
                if (!(node instanceof Task) || (t = (Task)node).getTaskType() != Task.TaskType.SERVICE && t.getTaskType() != Task.TaskType.SCRIPT) continue;
                LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(t.getInflows(SequenceFlow.class));
                LinkedList<ConnectingObject> outFlows2 = new LinkedList<ConnectingObject>(t.getOutflows(SequenceFlow.class));
                messages.add(new ConversionMessage(node.getID(), "Removed automated task '" + node.getName() + "'."));
                if (inFlows.isEmpty()) {
                    for (ConnectingObject flow6 : outFlows2) {
                        flow6.remove();
                    }
                    t.remove();
                    continue;
                }
                if (outFlows2.isEmpty()) {
                    for (ConnectingObject flow7 : inFlows) {
                        flow7.remove();
                    }
                    t.remove();
                    continue;
                }
                if (outFlows2.size() == 1) {
                    ConnectingObject outFlow = outFlows2.getFirst();
                    FlowObject toNode = (FlowObject)outFlow.getTo();
                    if (toNode instanceof Gateway && ((Gateway)toNode).getGatewayType() != Gateway.GatewayType.AND && toNode.getOutflows(SequenceFlow.class).size() > 1) {
                        g = new Gateway("g2_" + t.getID(), "");
                        g.setGatewayType(Gateway.GatewayType.AND);
                        g.setLane(t.getLane());
                        g.setParentSubProcess(t.getParentSubProcess());
                        g.setPosition(t.getX(), t.getY());
                        this.addNode(g);
                        for (ConnectingObject inFlow : inFlows) {
                            inFlow.setTo(g);
                        }
                        outFlow.setFrom(g);
                        messages.add(new ConversionMessage(g.getID(), "Parallel merge inserted before decision '" + toNode.getName() + "'."));
                        t.remove();
                        continue;
                    }
                    for (ConnectingObject inFlow : inFlows) {
                        inFlow.setTo(toNode);
                    }
                    outFlow.remove();
                    t.remove();
                    continue;
                }
                if (inFlows.size() == 1) {
                    ConnectingObject inFlow = inFlows.getFirst();
                    FlowObject fromNode4 = (FlowObject)inFlow.getFrom();
                    if (fromNode4 instanceof Gateway && ((Gateway)fromNode4).getGatewayType() != Gateway.GatewayType.AND && fromNode4.getOutflows(SequenceFlow.class).size() > 1) {
                        g = new Gateway("g2x_" + t.getID(), "");
                        g.setGatewayType(Gateway.GatewayType.AND);
                        g.setLane(t.getLane());
                        g.setParentSubProcess(t.getParentSubProcess());
                        g.setPosition(t.getX(), t.getY());
                        this.addNode(g);
                        for (ConnectingObject outFlow : outFlows2) {
                            outFlow.setFrom(g);
                        }
                        inFlow.setTo(g);
                        messages.add(new ConversionMessage(g.getID(), "Parallel directive inserted after decision '" + fromNode4.getName() + "'."));
                        t.remove();
                        continue;
                    }
                    for (ConnectingObject outflow : outFlows2) {
                        outflow.setFrom(inFlow.getFrom());
                    }
                    outFlows2.getFirst().setName(inFlow.getName());
                    inFlow.remove();
                    t.remove();
                    continue;
                }
                Gateway g2 = new Gateway("g2y_" + t.getID(), "");
                g2.setGatewayType(Gateway.GatewayType.AND);
                g2.setLane(t.getLane());
                g2.setParentSubProcess(t.getParentSubProcess());
                g2.setPosition(t.getX(), t.getY());
                this.addNode(g2);
                for (ConnectingObject flow8 : inFlows) {
                    flow8.setTo(g2);
                }
                for (ConnectingObject flow8 : outFlows2) {
                    flow8.setFrom(g2);
                }
                t.remove();
            }
            do {
                deletedSomething = false;
                tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
                for (FlowObject n : tmpNodes) {
                    LinkedList<GraphicalElement> outObjs = new LinkedList<GraphicalElement>();
                    LinkedList<ConnectingObject> outFlows3 = new LinkedList<ConnectingObject>(n.getOutflows());
                    for (ConnectingObject f : outFlows3) {
                        if (outObjs.contains(f.getTo())) {
                            f.remove();
                            deletedSomething = true;
                            continue;
                        }
                        outObjs.add(f.getTo());
                    }
                    if (!(n instanceof Gateway) || n.getInflows().size() != 1 || n.getOutflows().size() != 1) continue;
                    ConnectingObject inflow = n.getInflows().getFirst();
                    ConnectingObject outflow = n.getOutflows().getFirst();
                    messages.add(new ConversionMessage(n.getID(), "Decision '" + n.getName() + "' removed because it does not affect user activities."));
                    inflow.setTo(outflow.getTo());
                    outflow.remove();
                    n.remove();
                    deletedSomething = true;
                }
            } while (deletedSomething);
        }
        if (flagList.contains((Object)SimplifyFlags.MULTIPLE_START_EVENTS_TO_GATEWAY)) {
            // empty if block
        }
        if (flagList.contains((Object)SimplifyFlags.XOR_EVENT_TO_DATA)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Gateway) || ((Gateway)n).getGatewayType() != Gateway.GatewayType.XOR_EVENT) continue;
                Gateway g = (Gateway)n;
                g.setGatewayType(Gateway.GatewayType.XOR_DATA);
                outFlows = new LinkedList<ConnectingObject>(g.getOutflows(SequenceFlow.class));
                for (ConnectingObject flow4 : outFlows) {
                    if (flow4.getTo() == null || !(flow4.getTo() instanceof Event) || ((Event)flow4.getTo()).getEventType() != Event.EventType.INTERMEDIATE) continue;
                    Event e = (Event)flow4.getTo();
                    flow4.setName(e.getName());
                    if (e.getInflows(MessageFlow.class).isEmpty() && e.getInflows(SequenceFlow.class).size() == 1) {
                        messages.add(new ConversionMessage(e.getID(), "Event '" + e.getName() + "' converted to directive condition."));
                        if (e.getOutflows(SequenceFlow.class).size() == 1) {
                            ConnectingObject outF = e.getOutflows(SequenceFlow.class).getFirst();
                            flow4.setTo(outF.getTo());
                            outF.remove();
                        } else if (e.getOutflows(SequenceFlow.class).size() > 1) {
                            Gateway andG = new Gateway("g4_" + e.getID(), "");
                            andG.setGatewayType(Gateway.GatewayType.AND);
                            andG.setLane(e.getLane());
                            andG.setParentSubProcess(e.getParentSubProcess());
                            andG.setPosition(e.getX(), e.getY());
                            this.addNode(andG);
                            messages.add(new ConversionMessage(andG.getID(), "Parallel directive added after condition '" + e.getName() + "'."));
                            flow4.setTo(andG);
                            LinkedList<ConnectingObject> o_Flows = new LinkedList<ConnectingObject>(andG.getOutflows(SequenceFlow.class));
                            for (ConnectingObject outF : o_Flows) {
                                outF.setFrom(andG);
                            }
                        }
                        e.remove();
                        continue;
                    }
                    Task newT = new Task("t4_" + e.getID(), e.getName());
                    newT.setTaskType(Task.TaskType.RECEIVE);
                    newT.setLane(e.getLane());
                    newT.setParentSubProcess(e.getParentSubProcess());
                    newT.setPosition(e.getX(), e.getY());
                    this.addNode(newT);
                    messages.add(new ConversionMessage(newT.getID(), "Event '" + e.getName() + "' converted to task."));
                    LinkedList<ConnectingObject> i_Flows = new LinkedList<ConnectingObject>(e.getInflows());
                    for (ConnectingObject outF : i_Flows) {
                        outF.setTo(newT);
                    }
                    LinkedList<ConnectingObject> o_Flows = new LinkedList<ConnectingObject>(e.getOutflows());
                    for (ConnectingObject outF : o_Flows) {
                        outF.setFrom(newT);
                    }
                    e.remove();
                }
            }
        }
        if (flagList.contains((Object)SimplifyFlags.OR_TO_XOR)) {
            this.serialize(true, false);
            LinkedList<FlowObject> seqNodes = new LinkedList<FlowObject>(this.mSequencedNodes);
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Gateway)) continue;
                Gateway g = (Gateway)n;
                LinkedList<Gateway> newGateways = new LinkedList<Gateway>();
                if (g.getGatewayType() != Gateway.GatewayType.OR || g.getOutflows(SequenceFlow.class).size() < 3) continue;
                String namePrefix = "";
                if (g.getName() != null && !g.getName().equals("")) {
                    namePrefix = g.getName();
                    if (namePrefix.endsWith("?")) {
                        namePrefix = namePrefix.substring(0, namePrefix.length() - 1);
                    }
                    namePrefix = namePrefix + " is ";
                }
                LinkedList<ConnectingObject> outFlows4 = new LinkedList<ConnectingObject>(g.getOutflows(SequenceFlow.class));
                Collections.sort(outFlows4, new byEndpointY());
                SequenceFlow lastFlow = null;
                for (ConnectingObject flow3 : outFlows4) {
                    if (lastFlow == null && (((SequenceFlow)flow3).isDefault().booleanValue() || flow3.getName().toLowerCase().equals("otherwise"))) {
                        lastFlow = (SequenceFlow)flow3;
                        continue;
                    }
                    Gateway newG = new Gateway("g5_" + flow3.getID(), namePrefix + flow3.getName() + "?");
                    newG.setLane(g.getLane());
                    newG.setParentSubProcess(g.getParentSubProcess());
                    newG.setGatewayType(Gateway.GatewayType.XOR_DATA);
                    newG.setPosition(flow3.getPath().getLast().getX(), flow3.getPath().getLast().getY());
                    this.addNode(newG);
                    newGateways.add(newG);
                    flow3.setFrom(newG);
                    flow3.setName("Yes");
                }
                if (lastFlow == null) {
                    lastFlow = (SequenceFlow)outFlows4.getLast();
                }
                Gateway firstG = (Gateway)newGateways.getFirst();
                firstG.setPosition(g.getX(), g.getY());
                LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(g.getInflows(SequenceFlow.class));
                for (ConnectingObject flow9 : inFlows) {
                    flow9.setTo(firstG);
                }
                g.remove();
                newGateways.removeFirst();
                Gateway priorG = firstG;
                for (Gateway newG : newGateways) {
                    SequenceFlow s1 = new SequenceFlow(newG.getID() + "_N", "No", priorG, newG);
                    ConnectingObject yesFlow = (ConnectingObject)newG.getOutflows(SequenceFlow.class).toArray()[0];
                    FlowObject yesNode = (FlowObject)yesFlow.getTo();
                    FlowObject preceedingNode = seqNodes.get(seqNodes.indexOf(yesNode) - 1);
                    mLog.fine("Yes flow of " + newG.getName() + " leads to " + yesNode.getName() + " which is preceded by " + preceedingNode.getName());
                    if (preceedingNode.getOutflows(SequenceFlow.class).size() == 1) {
                        preceedingNode.getOutflows(SequenceFlow.class).getFirst().remove();
                    }
                    SequenceFlow s2 = new SequenceFlow(newG.getID() + "_in", "", preceedingNode, newG);
                    priorG = newG;
                }
                lastFlow.setFrom(priorG);
                lastFlow.setName("No");
                lastFlow.setDefault(false);
            }
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Gateway) || n.getInflows(SequenceFlow.class).size() != 1 || n.getOutflows(SequenceFlow.class).size() != 1) continue;
                ConnectingObject inFlow = n.getInflows(SequenceFlow.class).getFirst();
                ConnectingObject outFlow = n.getOutflows(SequenceFlow.class).getFirst();
                inFlow.setTo(outFlow.getTo());
                inFlow.getPath().clear();
                outFlow.remove();
                n.remove();
            }
        }
        if (flagList.contains((Object)SimplifyFlags.ATTACHED_EVENTS_TO_XOR)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                LinkedList<ConnectingObject> outFlows5;
                if (!(n instanceof Activity) || ((Activity)n).getAttachedEvents().isEmpty()) continue;
                Gateway newG = new Gateway("g6_" + n.getID(), "");
                newG.setGatewayType(Gateway.GatewayType.XOR_DATA);
                newG.setLane(n.getLane());
                newG.setParentSubProcess(n.getParentSubProcess());
                newG.setPosition(n.getX() + n.getWidth(), n.getY());
                this.addNode(newG);
                LinkedList<Event> tmpEvents = new LinkedList<Event>(((Activity)n).getAttachedEvents());
                for (Event e : tmpEvents) {
                    String flowName = e.getName();
                    if (flowName.equals("")) {
                        if (!e.getOutflows(SequenceFlow.class).isEmpty()) {
                            ConnectingObject firstFlow = e.getOutflows(SequenceFlow.class).getFirst();
                            flowName = firstFlow.getName();
                        }
                        if (flowName.equals("")) {
                            flowName = e.getTrigger().name();
                        }
                    }
                    flowName = flowName + " triggered";
                    outFlows5 = new LinkedList<ConnectingObject>(e.getOutflows());
                    for (ConnectingObject flow3 : outFlows5) {
                        flow3.setFrom(newG);
                        flow3.setName(flowName);
                    }
                    messages.add(new ConversionMessage(newG.getID(), "Attached intermediate event converted to directive condition '" + flowName + "'."));
                    e.remove();
                }
                int numFlows = n.getOutflows(SequenceFlow.class).size();
                if (numFlows == 1) {
                    flow4 = (SequenceFlow)n.getOutflows(SequenceFlow.class).getFirst();
                    flow4.setFrom(newG);
                    flow4.setName("");
                    ((SequenceFlow)flow4).setDefault(true);
                    ((SequenceFlow)flow4).setConditional(false);
                } else if (numFlows == 0) {
                    Event newEnd = new Event("e6_" + n.getID(), "");
                    newEnd.setEventType(Event.EventType.END);
                    newEnd.setLane(n.getLane());
                    newEnd.setParentSubProcess(n.getParentSubProcess());
                    newEnd.setPosition(n.getX() + n.getWidth() * 2.0f, n.getY() + n.getHeight() * 2.0f);
                    this.addNode(newEnd);
                    SequenceFlow flow10 = new SequenceFlow("s6_" + newEnd.getID(), "", newG, newEnd);
                    flow10.setDefault(true);
                    messages.add(new ConversionMessage(newEnd.getID(), "End of Activity condition added after task '" + n.getName() + "'."));
                } else if (numFlows > 1) {
                    Gateway newAndG = new Gateway("g6x_" + n.getID(), "");
                    newAndG.setGatewayType(Gateway.GatewayType.AND);
                    newAndG.setLane(newG.getLane());
                    newAndG.setParentSubProcess(n.getParentSubProcess());
                    newAndG.setPosition(n.getX() + n.getWidth() * 2.0f, n.getY());
                    this.addNode(newAndG);
                    SequenceFlow s = new SequenceFlow("s6x_" + newAndG.getID(), "", newG, newAndG);
                    s.setDefault(true);
                    outFlows5 = new LinkedList<ConnectingObject>(n.getOutflows(SequenceFlow.class));
                    for (ConnectingObject flow3 : outFlows5) {
                        flow3.setFrom(newAndG);
                    }
                    messages.add(new ConversionMessage(newAndG.getID(), "Parallel directive added after task '" + n.getName() + "'."));
                }
                new SequenceFlow("s6y_" + n.getID(), "", n, newG);
            }
        }
        if (flagList.contains((Object)SimplifyFlags.CREATE_MISSING_OR_FLOW_LABELS)) {
            for (FlowObject n : this.getAllNodes().values()) {
                if (!(n instanceof Gateway) || ((Gateway)n).getGatewayType() != Gateway.GatewayType.OR || n.getOutflows().size() <= 1) continue;
                boolean allFlowsBlank = true;
                for (ConnectingObject flow11 : n.getOutflows(SequenceFlow.class)) {
                    if (flow11.getName().equals("")) continue;
                    allFlowsBlank = false;
                    break;
                }
                if (!allFlowsBlank) continue;
                for (ConnectingObject flow12 : n.getOutflows(SequenceFlow.class)) {
                    if (flow12.getTo() == null || ((SequenceFlow)flow12).isDefault().booleanValue()) continue;
                    flow12.setName(flow12.getTo().getName());
                }
            }
        }
        if (flagList.contains((Object)SimplifyFlags.EXPLODE_SUBPROCESSES)) {
            this.cleanUp(false, messages);
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Subprocess) || n.getParentSubProcess() != null || !((Subprocess)n).isExpanded().booleanValue()) continue;
                this.recursivelyExplodeSubprocess((Subprocess)n, messages);
            }
        }
        if (flagList.contains((Object)SimplifyFlags.ADD_AND_SPLIT_AFTER_START)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Event) || ((Event)n).getEventType() != Event.EventType.START || n.getParentSubProcess() != null || !n.getInflows(SequenceFlow.class).isEmpty() || n.getOutflows(SequenceFlow.class).size() <= 1) continue;
                Gateway andG = new Gateway("g14_" + n.getID(), "");
                andG.setGatewayType(Gateway.GatewayType.AND);
                andG.setLane(n.getLane());
                andG.setPosition(n.getX() + n.getWidth(), n.getY());
                outFlows = new LinkedList<ConnectingObject>(n.getOutflows());
                for (ConnectingObject flow4 : outFlows) {
                    flow4.setFrom(andG);
                }
                SequenceFlow flow13 = new SequenceFlow("s14_" + n.getID(), "", n, andG);
                messages.add(new ConversionMessage(andG.getID(), "Parallel split inserted after start event."));
            }
        }
        if (flagList.contains((Object)SimplifyFlags.EVENTS_TO_TASKS)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                Event e;
                if (!(n instanceof Event) || (e = (Event)n).getEventType() != Event.EventType.INTERMEDIATE || e.getTarget() != null) continue;
                Task t = new Task("t9_" + e.getID(), e.getName());
                t.setLane(e.getLane());
                t.setParentSubProcess(e.getParentSubProcess());
                this.addNode(t);
                t.setPosition(e.getX(), e.getY());
                t.setWidth(e.getWidth());
                t.setHeight(e.getHeight());
                LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(e.getInflows());
                LinkedList<ConnectingObject> outFlows6 = new LinkedList<ConnectingObject>(e.getOutflows());
                for (ConnectingObject flow8 : inFlows) {
                    flow8.setTo(t);
                }
                for (ConnectingObject flow8 : outFlows6) {
                    flow8.setFrom(t);
                }
                messages.add(new ConversionMessage(t.getID(), "Event '" + e.getName() + "' converted to task."));
                e.remove();
            }
        }
        if (flagList.contains((Object)SimplifyFlags.REMOVE_JOINS)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                Gateway g;
                if (!(n instanceof Gateway) || ((Gateway)n).getGatewayType() != Gateway.GatewayType.XOR_DATA || (g = (Gateway)n).getInflows(SequenceFlow.class).size() < 1 || g.getOutflows(SequenceFlow.class).size() != 1) continue;
                ConnectingObject outflow = (ConnectingObject)g.getOutflows(SequenceFlow.class).toArray()[0];
                LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(g.getInflows());
                for (ConnectingObject inflow : inFlows) {
                    inflow.setTo(outflow.getTo());
                }
                messages.add(new ConversionMessage(outflow.getTo().getID(), "Exclusive-Or merge before task '" + outflow.getTo().getName() + "' removed."));
                outflow.remove();
                g.remove();
            }
        }
        if (flagList.contains((Object)SimplifyFlags.ADD_TASKS_BETWEEN_GATEWAYS)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                String taskName;
                if (!(n instanceof Gateway)) continue;
                Gateway toG = (Gateway)n;
                if (toG.getGatewayType() == Gateway.GatewayType.OR && toG.getOutflows(SequenceFlow.class).size() == 2) {
                    for (ConnectingObject flow14 : toG.getOutflows(SequenceFlow.class)) {
                        if (!((SequenceFlow)flow14).isDefault().booleanValue() || !flow14.getName().equals("")) continue;
                        toG.setGatewayType(Gateway.GatewayType.XOR_DATA);
                        break;
                    }
                }
                Boolean needsTask = false;
                if (toG.getOutflows(SequenceFlow.class).size() > 1) {
                    ConnectingObject flow15;
                    if (toG.getInflows(SequenceFlow.class).size() > 1 || toG.getGatewayType() == Gateway.GatewayType.OR) {
                        needsTask = true;
                    } else if (toG.getInflows(SequenceFlow.class).size() == 1 && (flow15 = toG.getInflows(SequenceFlow.class).getFirst()).getFrom() != null && ((fromNode = (FlowObject)flow15.getFrom()) instanceof Gateway || fromNode instanceof Activity) && fromNode.getOutflows(SequenceFlow.class).size() > 1) {
                        needsTask = true;
                    }
                }
                if (!needsTask.booleanValue()) continue;
                if (toG.getGatewayType() == Gateway.GatewayType.OR) {
                    taskName = "Proceed with one or more of the following choices.";
                } else if (toG.getGatewayType() == Gateway.GatewayType.AND) {
                    taskName = "Proceed in parallel with the following tasks.";
                } else {
                    taskName = toG.getName();
                    if (taskName.equals("")) {
                        taskName = "Evaluate the following conditions.";
                    } else {
                        if (taskName.endsWith("?")) {
                            taskName = taskName.substring(0, taskName.length() - 1);
                        }
                        taskName = "Determine if " + taskName;
                    }
                }
                Task task = new Task("t11_" + toG.getID(), taskName);
                task.setLane(toG.getLane());
                task.setParentSubProcess(toG.getParentSubProcess());
                task.setPosition(toG.getX() - toG.getWidth() * 2.0f, toG.getY());
                this.addNode(task);
                LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(toG.getInflows());
                for (ConnectingObject flow16 : inFlows) {
                    flow16.setTo(task);
                }
                SequenceFlow newFlow = new SequenceFlow("s11_" + task.getID(), "", task, toG);
                messages.add(new ConversionMessage(task.getID(), "Task '" + task.getName() + "' added before directive."));
            }
        }
        if (flagList.contains((Object)SimplifyFlags.ADD_TASKS_BEFORE_SUBPROCESSES)) {
            LinkedList<FlowObject> tmpNodes = new LinkedList<FlowObject>(this.getAllNodes().values());
            for (FlowObject n : tmpNodes) {
                if (!(n instanceof Subprocess) || ((Subprocess)n).isExpanded().booleanValue()) continue;
                Subprocess sub = (Subprocess)n;
                boolean needsTask = false;
                if (sub.getInflows(SequenceFlow.class).size() > 1) {
                    needsTask = true;
                } else if (sub.getInflows(SequenceFlow.class).isEmpty() && !sub.getOutflows(SequenceFlow.class).isEmpty()) {
                    needsTask = true;
                } else if (sub.getInflows(SequenceFlow.class).size() == 1 && sub.getInflows(SequenceFlow.class).getFirst().getFrom() != null) {
                    ConnectingObject inflow = sub.getInflows(SequenceFlow.class).getFirst();
                    fromNode = inflow.getFrom();
                    if ((fromNode instanceof Gateway && ((Gateway)fromNode).getGatewayType() == Gateway.GatewayType.AND || fromNode instanceof Activity) && fromNode.getOutflows(SequenceFlow.class).size() > 1) {
                        needsTask = true;
                    } else if (fromNode instanceof Event && ((Event)fromNode).getEventType() == Event.EventType.START && fromNode.getInflows(SequenceFlow.class).isEmpty()) {
                        needsTask = true;
                    } else if (fromNode instanceof Gateway && ((Gateway)fromNode).getGatewayType() != Gateway.GatewayType.AND) {
                        needsTask = true;
                        if (fromNode.getOutflows(SequenceFlow.class).size() == 2 && sub.getOutflows(SequenceFlow.class).size() == 1) {
                            Object otherNode = null;
                            for (ConnectingObject flow17 : fromNode.getOutflows(SequenceFlow.class)) {
                                if (flow17 == inflow) continue;
                                otherNode = flow17.getTo();
                                break;
                            }
                            if (otherNode.equals(sub.getOutflows(SequenceFlow.class).getFirst().getTo())) {
                                needsTask = false;
                            }
                        }
                    }
                }
                if (!needsTask) continue;
                Task newTask = new Task("t12_" + sub.getID(), "Perform external activity:");
                newTask.setLane(sub.getLane());
                newTask.setParentSubProcess(sub.getParentSubProcess());
                newTask.setPosition(sub.getX() - sub.getWidth() / 2.0f, sub.getY());
                this.addNode(newTask);
                for (ConnectingObject flow18 : sub.getInflows(SequenceFlow.class)) {
                    flow18.setTo(newTask);
                }
                SequenceFlow s = new SequenceFlow("s12_" + sub.getID(), "", newTask, sub);
                messages.add(new ConversionMessage(newTask.getID(), "Task '" + newTask.getName() + "' added before stop and complete."));
            }
        }
        if (flagList.contains((Object)SimplifyFlags.REMOVE_EXTRANEOUS_FLOWS)) {
            this.removeExtraneousFlows(messages);
        }
        tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
        for (ConnectingObject flow2 : tmpFlows) {
            if (flow2.getFrom() == null || flow2.getTo() == null) {
                String msg = "Flow";
                if (!flow2.getName().equals("")) {
                    msg = msg + " '" + flow2.getName() + "'";
                }
                if (flow2.getFrom() != null && flow2.getFrom().getName() != null) {
                    msg = msg + " from '" + flow2.getFrom().getName() + "'";
                } else if (flow2.getTo() != null && flow2.getTo().getName() != null) {
                    msg = msg + " to '" + flow2.getTo().getName() + "'";
                }
                msg = msg + " removed because it is not connected on both ends.";
                messages.add(new ConversionMessage(flow2.getID(), msg));
                flow2.remove();
                continue;
            }
            if (!flow2.getPath().isEmpty()) continue;
            flow2.getPath().add(new Coordinate(flow2.getFrom().getX(), flow2.getFrom().getY()));
            flow2.getPath().add(new Coordinate(flow2.getTo().getX(), flow2.getTo().getY()));
        }
        return messages;
    }

    private void recursivelyExplodeSubprocess(Subprocess sub, LinkedList<ConversionMessage> messages) {
        LinkedList<FlowObject> allNodes = new LinkedList<FlowObject>(sub.getAllNodes().values());
        for (FlowObject node : allNodes) {
            if (!(node instanceof Subprocess) || !((Subprocess)node).isExpanded().booleanValue()) continue;
            this.recursivelyExplodeSubprocess((Subprocess)node, messages);
        }
        switch (sub.getSubprocessType()) {
            case REFERENCE: {
                this.cloneReferenceSubprocess(sub);
                break;
            }
            case REUSABLE: {
                sub.setSubprocessType(Subprocess.SubprocessType.EMBEDDED);
            }
        }
        if (sub.isAdHoc().booleanValue()) {
            LinkedList<FlowObject> startNodes = new LinkedList<FlowObject>(sub.getStartNodes());
            Collections.sort(startNodes, new byDistanceFromParentOrigin());
            FlowObject priorNode = null;
            for (FlowObject node : startNodes) {
                if (priorNode != null) {
                    SequenceFlow s = new SequenceFlow("s8_" + node.getID(), "", priorNode, node);
                    this.addFlow(s);
                }
                priorNode = node;
            }
            sub.getStartNodes().clear();
            sub.getStartNodes().add(startNodes.getFirst());
            messages.add(new ConversionMessage(sub.getID(), "Ad-hoc subprocess '" + sub.getName() + "' converted to a series of tasks."));
        }
        LinkedList<ConnectingObject> endFlows = new LinkedList<ConnectingObject>();
        allNodes = new LinkedList<FlowObject>(sub.getAllNodes().values());
        for (FlowObject node : allNodes) {
            if (!(node instanceof Event)) continue;
            Event e = (Event)node;
            if (e.getEventType() == Event.EventType.START && !e.getInflows(MessageFlow.class).isEmpty()) {
                e.setEventType(Event.EventType.INTERMEDIATE);
                e.setTrigger(Event.Trigger.MESSAGE);
                e.setDirection(Event.Direction.CATCH);
            } else if (e.getEventType() == Event.EventType.END && !e.getOutflows(MessageFlow.class).isEmpty()) {
                e.setEventType(Event.EventType.INTERMEDIATE);
                e.setTrigger(Event.Trigger.MESSAGE);
                e.setDirection(Event.Direction.THROW);
            }
            if (e.getEventType() == Event.EventType.START && e.getInflows(SequenceFlow.class).isEmpty()) {
                LinkedList<ConnectingObject> eventOutFlows = new LinkedList<ConnectingObject>(node.getOutflows(SequenceFlow.class));
                for (ConnectingObject flow : eventOutFlows) {
                    flow.remove();
                }
                messages.add(new ConversionMessage(e.getID(), "Start event inside subprocess '" + sub.getName() + "' removed."));
                e.remove();
                continue;
            }
            if (e.getEventType() != Event.EventType.END || !e.getOutflows(SequenceFlow.class).isEmpty()) continue;
            endFlows.addAll(e.getInflows(SequenceFlow.class));
            messages.add(new ConversionMessage(e.getID(), "End event inside subprocess '" + sub.getName() + "' removed."));
            e.remove();
        }
        LinkedList<FlowObject> startNodes = new LinkedList<FlowObject>();
        for (FlowObject node : sub.getAllNodes().values()) {
            if (!node.getInflows(SequenceFlow.class).isEmpty() || node instanceof Event && ((Event)node).getTarget() != null) continue;
            startNodes.add(node);
        }
        if (startNodes.isEmpty()) {
            sub.getStartNodes().clear();
        } else {
            sub.setStartNodes(startNodes);
        }
        LinkedList<FlowObject> endNodes = new LinkedList<FlowObject>();
        for (FlowObject node : sub.getAllNodes().values()) {
            if (!node.getOutflows(SequenceFlow.class).isEmpty()) continue;
            endNodes.add(node);
        }
        if (startNodes.isEmpty()) {
            sub.setExpanded(false);
            messages.add(new ConversionMessage(sub.getID(), "Expanded subprocess '" + sub.getName() + "' converted to collapsed subprocess."));
        } else {
            Gateway andG;
            LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(sub.getInflows());
            LinkedList<ConnectingObject> outFlows = new LinkedList<ConnectingObject>(sub.getOutflows());
            for (ConnectingObject flow : inFlows) {
                if (!(flow instanceof MessageFlow) && !(flow instanceof Association)) continue;
                flow.remove();
            }
            for (ConnectingObject flow : outFlows) {
                if (!(flow instanceof MessageFlow) && !(flow instanceof Association)) continue;
                flow.remove();
            }
            inFlows = new LinkedList<ConnectingObject>(sub.getInflows());
            outFlows = new LinkedList<ConnectingObject>(sub.getOutflows());
            if (startNodes.size() > 1) {
                andG = new Gateway("g8_" + sub.getID(), "");
                andG.setGatewayType(Gateway.GatewayType.AND);
                andG.setPosition(sub.getX(), sub.getY() + sub.getHeight() / 2.0f);
                andG.setLane(sub.getLane());
                this.addNode(andG);
                for (FlowObject node : startNodes) {
                    SequenceFlow s = new SequenceFlow("s8x_" + node.getID(), "", andG, node);
                }
                startNodes.clear();
                startNodes.add(andG);
                messages.add(new ConversionMessage(andG.getID(), "Parallel directive added before tasks of subprocess '" + sub.getName() + "'."));
            }
            if (endNodes.size() + endFlows.size() > 1) {
                Gateway orG = new Gateway("g8x_" + sub.getID(), "");
                orG.setGatewayType(Gateway.GatewayType.OR);
                orG.setPosition(sub.getX() + sub.getWidth(), sub.getY() + sub.getHeight() / 2.0f);
                orG.setLane(sub.getLane());
                this.addNode(orG);
                for (FlowObject node : endNodes) {
                    SequenceFlow s2 = new SequenceFlow("s8y_" + node.getID(), "", node, orG);
                }
                for (ConnectingObject flow : endFlows) {
                    flow.setTo(orG);
                }
                endNodes.clear();
                endNodes.add(orG);
                messages.add(new ConversionMessage(orG.getID(), "Inclusive-Or merge added after tasks of subprocess '" + sub.getName() + "'."));
            }
            if (outFlows.size() > 1) {
                andG = new Gateway("g8y_" + sub.getID(), "");
                andG.setGatewayType(Gateway.GatewayType.AND);
                andG.setPosition(sub.getX() + sub.getWidth(), sub.getY() + sub.getHeight() / 2.0f);
                andG.setLane(sub.getLane());
                this.addNode(andG);
                if (!endNodes.isEmpty()) {
                    SequenceFlow s = new SequenceFlow("s8z_" + ((FlowObject)endNodes.getFirst()).getID(), "", (GraphicalElement)endNodes.getFirst(), andG);
                } else if (!endFlows.isEmpty()) {
                    ((ConnectingObject)endFlows.getFirst()).setTo(andG);
                }
                endNodes.clear();
                endNodes.add(andG);
                messages.add(new ConversionMessage(andG.getID(), "Parallel directive added after tasks of subprocess '" + sub.getName() + "'."));
            }
            FlowObject startNode = startNodes.getFirst();
            for (ConnectingObject flow : inFlows) {
                flow.setTo(startNode);
            }
            if (!endNodes.isEmpty()) {
                FlowObject endNode = (FlowObject)endNodes.getFirst();
                for (ConnectingObject flow : outFlows) {
                    flow.setFrom(endNode);
                }
            } else if (!endFlows.isEmpty()) {
                ((ConnectingObject)endFlows.getFirst()).setTo(outFlows.getFirst().getTo());
                outFlows.getFirst().remove();
            }
            messages.add(new ConversionMessage(sub.getID(), "Expanded subprocess '" + sub.getName() + "' removed (tasks moved to parent process)."));
            sub.remove();
        }
    }

    private void removeExtraneousFlows(LinkedList<ConversionMessage> messages) {
        LinkedList<ConnectingObject> tmpFlows = new LinkedList<ConnectingObject>(this.getAllFlows().values());
        for (ConnectingObject flow : tmpFlows) {
            if (!(flow instanceof SequenceFlow) || flow.getFrom() == null || flow.getTo() == null || !(flow.getFrom() instanceof FlowObject) || !(flow.getTo() instanceof FlowObject)) continue;
            FlowObject fromNode = (FlowObject)flow.getFrom();
            FlowObject toNode = (FlowObject)flow.getTo();
            if (fromNode instanceof Gateway || ((SequenceFlow)flow).isConditional().booleanValue() || ((SequenceFlow)flow).isDefault().booleanValue() || !(toNode instanceof Event) || ((Event)toNode).getEventType() != Event.EventType.END || fromNode.getOutflows(SequenceFlow.class).size() <= 1) continue;
            flow.remove();
            messages.add(new ConversionMessage(fromNode.getID(), "Superfluous flow between '" + fromNode.getName() + "' and '" + toNode.getName() + "' removed."));
            if (!toNode.getInflows(SequenceFlow.class).isEmpty()) continue;
            toNode.remove();
            messages.add(new ConversionMessage(toNode.getID(), "End event '" + toNode.getName() + "' removed."));
        }
    }

    public void convertToAbsoluteCoordinates() {
        if (this.isRelativeObjectCoordinates()) {
            this.convertCoordinates(false);
            this.setRelativeObjectCoordinates(false);
        }
    }

    public void convertToRelativeCoordinates() {
        if (!this.isRelativeObjectCoordinates()) {
            this.convertCoordinates(true);
            this.setRelativeObjectCoordinates(true);
        }
    }

    private void convertCoordinates(boolean toRelative) {
        double sign = toRelative ? -1.0 : 1.0;
        for (Pool pool : this.getPools().values()) {
            for (Lane lane : pool.getLanes().values()) {
                lane.setPosition((double)lane.getX() + sign * (double)pool.getX(), (double)lane.getY() + sign * (double)pool.getY());
            }
        }
        for (ConnectingObject f : this.getAllFlows().values()) {
            if (!(f instanceof SequenceFlow)) continue;
            f.setAttribute("moved", false);
        }
        LinkedList<GraphicalElement> gElements = new LinkedList<GraphicalElement>(this.getGraphicalElements().values());
        for (GraphicalElement e : gElements) {
            if (!(e instanceof Subprocess) || !((Subprocess)e).getSubprocessType().equals((Object)Subprocess.SubprocessType.REFERENCE)) continue;
            this.cloneReferenceSubprocess((Subprocess)e);
        }
        for (GraphicalElement e : gElements) {
            if (!(e instanceof Subprocess) || ((Subprocess)e).getParentSubProcess() != null) continue;
            this.convertSubprocessCoordinates((Subprocess)e, sign);
        }
    }

    private void convertSubprocessCoordinates(Subprocess s, double sign) {
        double sx = sign * (double)s.getX();
        double sy = sign * (double)s.getY();
        for (FlowObject node : s.getAllNodes().values()) {
            node.setPosition((double)node.getX() + sx, (double)node.getY() + sy);
            for (ConnectingObject flow : node.getOutflows()) {
                if (!(flow.getTo() instanceof FlowObject) || ((FlowObject)flow.getTo()).getParentSubProcess() != node.getParentSubProcess() || flow.getAttribute("moved") != null && !flow.getAttribute("moved").equals(false)) continue;
                for (Coordinate point : flow.getPath()) {
                    point.setX((double)point.getX() + sx);
                    point.setY((double)point.getY() + sy);
                }
                flow.setAttribute("moved", true);
            }
            if (!(node instanceof Subprocess)) continue;
            this.convertSubprocessCoordinates((Subprocess)node, sign);
        }
    }

    private void cloneReferenceSubprocess(Subprocess s) {
        if (!s.getSubprocessType().equals((Object)Subprocess.SubprocessType.REFERENCE)) {
            mLog.warning("Unable to clone subprocess" + s.getName() + ". Type is not REFERENCE.");
        } else {
            Subprocess refProc = s.getSubprocessReference();
            s.setSubprocessReference(null);
            s.getAllNodes().clear();
            s.getStartNodes().clear();
            for (FlowObject node : refProc.getAllNodes().values()) {
                FlowObject newNode = null;
                try {
                    newNode = node.clone(s.getID() + "-" + node.getID());
                }
                catch (CloneNotSupportedException e) {
                    mLog.severe("Object '" + node.getName() + "' (" + node.getID() + ") in subprocess " + s.getName() + " cannot be cloned.");
                    continue;
                }
                newNode.setParentSubProcess(s);
                node.setAttribute("clone", newNode);
            }
            for (FlowObject node : refProc.getAllNodes().values()) {
                for (ConnectingObject flow : node.getOutflows(SequenceFlow.class)) {
                    SequenceFlow newFlow = null;
                    try {
                        newFlow = ((SequenceFlow)flow).clone(s.getID() + "-" + flow.getID());
                    }
                    catch (CloneNotSupportedException e) {
                        mLog.severe("Flow '" + node.getName() + "' (" + node.getID() + ") in subprocess " + s.getName() + " cannot be cloned.");
                        continue;
                    }
                    FlowObject newFrom = (FlowObject)node.getAttribute("clone");
                    FlowObject newTo = (FlowObject)flow.getTo().getAttribute("clone");
                    if (newFrom != null && newTo != null) {
                        newFlow.setFrom(newFrom);
                        newFlow.setTo(newTo);
                        continue;
                    }
                    mLog.warning("Cloned flow " + flow.getID() + " not connected on one or both ends.");
                    newFlow.remove();
                }
            }
        }
    }

    public void layout(double taskWidth, double taskHeight) {
        Layout l = new Layout(taskWidth, taskHeight);
        l.doLayout(this);
    }

    private class byDistanceFromParentOrigin
    implements Comparator {
        private byDistanceFromParentOrigin() {
        }

        public int compare(Object o1, Object o2) {
            FlowObject node1 = (FlowObject)o1;
            FlowObject node2 = (FlowObject)o2;
            double x1 = (double)node1.getX() - (node1.getParentSubProcess() == null ? 0.0 : (double)node1.getParentSubProcess().getX());
            double y1 = (double)node1.getY() - (node1.getParentSubProcess() == null ? 0.0 : (double)node1.getParentSubProcess().getY());
            double x2 = (double)node2.getX() - (node2.getParentSubProcess() == null ? 0.0 : (double)node2.getParentSubProcess().getX());
            double y2 = (double)node2.getY() - (node2.getParentSubProcess() == null ? 0.0 : (double)node2.getParentSubProcess().getY());
            Double dist1 = Math.sqrt(x1 * x1 + y1 * y1);
            Double dist2 = Math.sqrt(x2 * x2 + y2 * y2);
            return Double.compare(dist1, dist2);
        }
    }

    private class byDistanceFromOrigin
    implements Comparator {
        private byDistanceFromOrigin() {
        }

        public int compare(Object o1, Object o2) {
            FlowObject node1 = (FlowObject)o1;
            FlowObject node2 = (FlowObject)o2;
            Double dist1 = Math.sqrt(Math.pow(node1.getX(), 2.0) + Math.pow(node1.getY(), 2.0));
            Double dist2 = Math.sqrt(Math.pow(node2.getX(), 2.0) + Math.pow(node2.getY(), 2.0));
            return Double.compare(dist1, dist2);
        }
    }

    private class byEndpointY
    implements Comparator {
        private byEndpointY() {
        }

        public int compare(Object o1, Object o2) {
            ConnectingObject flow1 = (ConnectingObject)o1;
            ConnectingObject flow2 = (ConnectingObject)o2;
            if (flow1.getPath().isEmpty() || flow2.getPath().isEmpty()) {
                return 0;
            }
            int result = Double.compare(flow1.getPath().getLast().getYd(), flow2.getPath().getLast().getYd());
            if (flow1.getModel().getCoordinateOrigin() == CoordinateOrigins.LOWERLEFT) {
                return -result;
            }
            return result;
        }
    }

    private class byPositionX
    implements Comparator {
        private byPositionX() {
        }

        public int compare(Object o1, Object o2) {
            FlowObject node1 = (FlowObject)o1;
            FlowObject node2 = (FlowObject)o2;
            int result = Double.compare(node1.getPosition().getXd(), node2.getPosition().getXd());
            return result;
        }
    }

    private class byPositionY
    implements Comparator {
        private byPositionY() {
        }

        public int compare(Object o1, Object o2) {
            FlowObject node1 = (FlowObject)o1;
            FlowObject node2 = (FlowObject)o2;
            int result = Double.compare(node1.getPosition().getYd(), node2.getPosition().getYd());
            if (node1.getModel().getCoordinateOrigin() == CoordinateOrigins.LOWERLEFT) {
                return -result;
            }
            return result;
        }
    }

    public static enum SimplifyFlags {
        REMOVE_AUTOMATED,
        OR_TO_XOR,
        REMOVE_AND_SPLIT,
        REMOVE_JOINS,
        XOR_EVENT_TO_DATA,
        EVENTS_TO_TASKS,
        ATTACHED_EVENTS_TO_XOR,
        CONDITIONAL_FLOW_TO_GATEWAY,
        CREATE_MISSING_OR_FLOW_LABELS,
        ADD_TASKS_BETWEEN_GATEWAYS,
        ADD_TASKS_BEFORE_SUBPROCESSES,
        MULTIPLE_START_EVENTS_TO_GATEWAY,
        EXPLODE_SUBPROCESSES,
        MERGE_POOLS,
        REMOVE_EXTRANEOUS_FLOWS,
        DETACH_SUBPROCESS_START_END,
        REMOVE_COLLAPSED_SUBPROCESS_CHILDREN,
        ADD_AND_SPLIT_AFTER_START,
        CONNECT_LINKS;

    }

    public static enum CoordinateOrigins {
        UPPERLEFT,
        LOWERLEFT;

    }
}

