/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.Artifact;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.DataObject;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Swimlane;

public class Utils {
    static boolean poolHasChild(Pool bpmnPool, BusinessProcessDiagram bpd) {
        boolean flag = false;
        if (bpmnPool.getLanes().size() != 0) {
            Lane bpmnLane;
            Iterator i$ = bpmnPool.getLanes().values().iterator();
            while (i$.hasNext() && !(flag = Utils.laneHasChild((Swimlane)(bpmnLane = (Lane)i$.next()), bpd))) {
            }
        } else {
            flag = Utils.laneHasChild((Swimlane)bpmnPool, bpd);
        }
        return flag;
    }

    private static boolean laneHasChild(Swimlane lane, BusinessProcessDiagram bpd) {
        boolean flag = false;
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            if (bpmnNode.getLane() == null || !lane.getID().equals(bpmnNode.getLane().getID())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    static void createDefaultPool(final BusinessProcessDiagram bpd) {
        new Pool("P0", "Default", bpd){
            {
                super(x0, x1, x2);
                this.setLaneToAllActivities();
                this.setPoolDimensions();
                this.setX(0.0f);
                this.setY(0.0f);
            }

            private void setLaneToAllActivities() {
                for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
                    if (bpmnNode instanceof Artifact) continue;
                    bpmnNode.setLane((Pool)this);
                }
            }

            private void setPoolDimensions() {
                double maxXAndWidthSum = 0.0;
                double maxYAndHeightSum = 0.0;
                for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
                    maxXAndWidthSum = Math.max(maxXAndWidthSum, (double)(bpmnNode.getX() + bpmnNode.getWidth()));
                    maxYAndHeightSum = Math.max(maxYAndHeightSum, (double)(bpmnNode.getY() + bpmnNode.getHeight()));
                }
                this.setWidth(maxXAndWidthSum + 100.0);
                this.setHeight(maxYAndHeightSum + 100.0);
            }
        };
    }

    static void removePages(BusinessProcessDiagram[] bpdArray, LinkedList<String> pageNames) {
        boolean pageFound = false;
        ArrayList<BusinessProcessDiagram> tempBpdArrayList = new ArrayList<BusinessProcessDiagram>(bpdArray.length);
        for (BusinessProcessDiagram bpd : bpdArray) {
            tempBpdArrayList.add(bpd);
        }
        for (BusinessProcessDiagram bpd : bpdArray) {
            for (String pageName : pageNames) {
                if (!pageName.equals(bpd.getName())) continue;
                pageFound = true;
                break;
            }
            if (pageFound) continue;
            tempBpdArrayList.remove(bpd);
        }
        bpdArray = (BusinessProcessDiagram[])tempBpdArrayList.toArray();
    }

    private static void bpdSimplifyToMergePools(BusinessProcessDiagram bpd) {
        bpd.simplify(BusinessProcessDiagram.SimplifyFlags.MERGE_POOLS);
        LinkedList tempNodes = new LinkedList(bpd.getAllNodes().values());
        for (FlowObject bpmnNode : tempNodes) {
            if (bpmnNode instanceof Annotation || bpmnNode instanceof DataObject || bpmnNode.getLane() != null) continue;
            LinkedList inFlows = new LinkedList(bpmnNode.getInflows(SequenceFlow.class));
            LinkedList outFlows = new LinkedList(bpmnNode.getOutflows(SequenceFlow.class));
            for (ConnectingObject flow : inFlows) {
                flow.remove();
            }
            for (ConnectingObject flow : outFlows) {
                flow.remove();
            }
            bpd.getAllNodes().remove(bpmnNode.getID());
        }
    }

    private static void makeLanesAdjacent(BusinessProcessDiagram bpd, Pool bpmnPool) {
        if (bpmnPool.getLanes().size() == 0) {
            int n = Math.round(bpmnPool.getY());
            if (n != 0) {
                Utils.moveActivitiesNUnits(bpd, (Swimlane)bpmnPool, n);
                bpmnPool.setY(0.0f);
            }
        } else {
            LinkedList<Lane> lanes = new LinkedList<Lane>();
            for (Lane bpmnLane : bpmnPool.getLanes().values()) {
                lanes.add(bpmnLane);
            }
            Collections.sort(lanes, new Comparator<Lane>(){

                @Override
                public int compare(Lane lane1, Lane lane2) {
                    float lane2y;
                    float lane1y = lane1.getY();
                    if (lane1y > (lane2y = lane2.getY())) {
                        return 1;
                    }
                    if (lane1y < lane2y) {
                        return -1;
                    }
                    return 0;
                }
            });
            boolean firstLane = true;
            Lane priorLane = (Lane)lanes.get(0);
            for (Lane bpmnLane : lanes) {
                int n = 0;
                if (firstLane) {
                    firstLane = false;
                    if (Math.round(bpmnLane.getY()) == 0) continue;
                    n = Math.round(bpmnLane.getY()) - 0;
                    Utils.moveActivitiesNUnits(bpd, (Swimlane)bpmnLane, n);
                    bpmnLane.setY(0.0f);
                    continue;
                }
                n = Math.round(bpmnLane.getY() - (priorLane.getY() + priorLane.getHeight()));
                if (n != 0) {
                    Utils.moveActivitiesNUnits(bpd, (Swimlane)bpmnLane, n);
                    bpmnLane.setY(priorLane.getY() + priorLane.getHeight());
                }
                priorLane = bpmnLane;
            }
        }
    }

    private static void moveActivitiesNUnits(BusinessProcessDiagram bpd, Swimlane bpmnLane, int n) {
        for (FlowObject bpmnNode : bpd.getAllNodes().values()) {
            if (bpmnNode.getLane() != null && bpmnNode.getLane().getID().equals(bpmnLane.getID())) {
                bpmnNode.setY(bpmnNode.getY() - (float)n);
                continue;
            }
            if (bpmnNode.getLane() != null || !(bpmnNode instanceof Annotation) || !Utils.isAnnotationInLane(bpmnNode, bpmnLane)) continue;
            bpmnNode.setY(bpmnNode.getY() - (float)n);
        }
    }

    private static boolean isAnnotationInLane(FlowObject bpmnAnnotation, Swimlane bpmnLane) {
        return bpmnAnnotation.getX() >= bpmnLane.getX() && bpmnAnnotation.getX() <= bpmnLane.getX() + bpmnLane.getWidth() && bpmnAnnotation.getY() >= bpmnLane.getY() && bpmnAnnotation.getY() <= bpmnLane.getY() + bpmnLane.getHeight();
    }

    static void mergePools(BusinessProcessDiagram[] bpdArray) {
        for (BusinessProcessDiagram bpd : bpdArray) {
            Utils.bpdSimplifyToMergePools(bpd);
            Pool pool = (Pool)bpd.getPools().values().iterator().next();
            Utils.makeLanesAdjacent(bpd, pool);
        }
    }

    private static String getPoolNameOf(FlowObject bpmnNode) {
        if (bpmnNode.getLane() instanceof Lane) {
            return bpmnNode.getLane().getPool().getName();
        }
        if (bpmnNode.getLane() != null) {
            return bpmnNode.getLane().getName();
        }
        return null;
    }

    static void removePools(BusinessProcessDiagram bpd, LinkedList<String> poolNames) {
        HashMap<String, String> userSelectedPools = new HashMap<String, String>();
        for (String poolName : poolNames) {
            userSelectedPools.put(poolName, "UserSelectedPool");
        }
        LinkedList tempNodes = new LinkedList(bpd.getAllNodes().values());
        for (FlowObject node : tempNodes) {
            if (userSelectedPools.get(Utils.getPoolNameOf(node)) != null) continue;
            bpd.getAllNodes().values().remove(node);
        }
        LinkedList flows = new LinkedList(bpd.getAllFlows().values());
        for (ConnectingObject flow : flows) {
            GraphicalElement from = flow.getFrom();
            GraphicalElement to = flow.getTo();
            if (from != null && to != null) continue;
            bpd.getAllFlows().values().remove(flow);
        }
        LinkedList pools = new LinkedList(bpd.getPools().values());
        for (Pool pool : pools) {
            if (userSelectedPools.get(pool.getName()) != null) continue;
            bpd.getPools().values().remove(pool);
        }
    }
}

