/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw.renderer;

import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.renderer.AbstractRenderer;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ChildrenRenderer
extends AbstractRenderer {
    private final boolean clip;

    private ChildrenRenderer(@NotNull Drawable drawable, boolean clip) {
        super(drawable);
        this.clip = clip;
    }

    public static ChildrenRenderer createClipped(@NotNull Drawable drawable) {
        return new ChildrenRenderer(drawable, true);
    }

    public static ChildrenRenderer createUnclipped(@NotNull Drawable drawable) {
        return new ChildrenRenderer(drawable, false);
    }

    @Override
    public void render() {
        Graphics graphics = this.getContext().getGraphics();
        Rectangle original = graphics.getClipBounds();
        Rectangle relative = this.getContext().scale(this.getDrawable().getBounds());
        if (this.clip) {
            graphics.mergeClip(relative);
        }
        graphics.translate(relative.getOrigin());
        Rectangle area = this.getContext().unscale(graphics.getClipBounds());
        Collection children = CollectionUtils.createCopy(this.getDrawable().getDrawables());
        for (Drawable child : children) {
            if (!child.intersects(area)) continue;
            child.draw();
        }
        graphics.translate(relative.getOrigin().flip());
        if (this.clip) {
            graphics.setClip(original);
        }
    }
}

