/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;

public interface Debuggable {
    public boolean accepts(@NotNull Drawable var1);

    public void attachDebugInfo(@NotNull Drawable var1, @NotNull StringList var2);

    public static abstract class Default
    implements Debuggable {
        protected final void attachKeyValue(@NotNull StringList info, @NotNull String key, @NotNull Integer value) {
            this.attachKeyValue(info, key, String.valueOf(value));
        }

        protected final void attachKeyValue(@NotNull StringList info, @NotNull String key, @NotNull String value) {
            info.add((Object)key.concat(": ").concat(value));
        }
    }

    public static interface LocatedDebuggable
    extends Debuggable {
        @NotNull
        public Point getSpecificLocation(@NotNull Drawable var1);
    }

    public static interface ColoredDebuggable
    extends Debuggable {
        @NotNull
        public Color getSpecificColor(@NotNull Drawable var1);
    }
}

