/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw.debug;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.debug.DebugableFactory;
import oracle.bpm.diagram.draw.debug.DebuggableAppender;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;

public class DebugableDrawer {
    public static void drawDebugInfo(@NotNull Drawable container) {
        for (Drawable drawable : container.getDrawables()) {
            DebuggableAppender debugable = DebugableFactory.create(drawable);
            if (!debugable.accepts(drawable)) continue;
            DebugableDrawer.drawDebugInfo(drawable, debugable);
        }
        DebugableDrawer.drawDebugInfo(container, DebugableFactory.create(container));
    }

    public static void drawList(@NotNull DiagramContext context, @NotNull StringList list, @NotNull Point location, Color color) {
        int fontHeight = context.scale(context.getFontMetrics().getHeight());
        location = context.scale(location);
        int rounded = context.scale(10);
        int width = context.scale((int)((float)DebugableDrawer.getWidestStringForInfo(context, list) * 1.1f) + rounded);
        int height = context.scale((fontHeight + rounded / 2) * list.size() + rounded);
        Graphics graphics = context.getGraphics();
        graphics.setForeground(color);
        graphics.fillRoundRect(location.getX() - rounded / 2, location.getY() - rounded / 2 - fontHeight, width, height, rounded, rounded);
        graphics.setForeground(Color.BLACK);
        graphics.drawRoundRect(location.getX() - rounded / 2, location.getY() - rounded / 2 - fontHeight, width, height, rounded, rounded);
        graphics.setForeground(Color.WHITE);
        for (int i = 0; i < list.size(); ++i) {
            String str = (String)list.get(i);
            graphics.drawString(str, location.getX(), location.getY() + (fontHeight + rounded / 2) * i);
        }
    }

    private static void drawDebugInfo(@NotNull Drawable drawable, @NotNull DebuggableAppender debugable) {
        StringList info = StringList.create((int)5);
        debugable.attachDebugInfo(drawable, info);
        if (!info.isEmpty()) {
            Point location = debugable.getSpecificLocation(drawable);
            Color color = debugable.getSpecificColor(drawable);
            DebugableDrawer.drawList(drawable.getContext(), info, location, color);
        }
    }

    private static int getWidestStringForInfo(DiagramContext context, StringList list) {
        String max = "";
        for (String string : list) {
            if (string.length() <= max.length()) continue;
            max = string;
        }
        int result = -1;
        if (max.length() != 0) {
            FontMetrics metrics = context.getFontMetrics();
            result = metrics.stringWidth(max);
        }
        return result;
    }
}

